/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.io.IOConsole;
import acm.io.IOModel;
import acm.program.Program;
import acm.util.ErrorException;
import acm.util.JTFTools;
import acm.util.ProgressBarDialog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;

class ThreadedMenuAction
implements Runnable {
    private Program targetProgram;
    private String actionCommand;

    public ThreadedMenuAction(Program program, String action) {
        this.targetProgram = program;
        this.actionCommand = action;
    }

    public void run() {
        ProgressBarDialog dialog = new ProgressBarDialog(this.targetProgram);
        try {
            if (this.actionCommand.equals("Export Applet")) {
                JTFTools.exportApplet(this.targetProgram, dialog.getProgressBar());
            } else if (this.actionCommand.equals("Submit Project")) {
                JTFTools.submitProject(this.targetProgram, dialog.getProgressBar());
            }
        }
        catch (Exception ex) {
            dialog.setVisible(false);
            IOModel io = this.targetProgram.getDialog();
            if (io == null) {
                io = this.targetProgram.getConsole();
            }
            if (io == null) {
                io = IOConsole.SYSTEM_CONSOLE;
            }
            String msg = ex.getMessage();
            if (!(ex instanceof ErrorException)) {
                msg = "" + ex;
                StringWriter wr = new StringWriter();
                PrintWriter pwr = new PrintWriter(wr);
                ex.printStackTrace(pwr);
                pwr.close();
                try {
                    BufferedReader rd = new BufferedReader(new StringReader(wr.toString()));
                    rd.readLine();
                    msg = String.valueOf(msg) + rd.readLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            io.showErrorMessage(msg);
        }
    }
}

