/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GCanvas;
import acm.graphics.GLabel;
import acm.graphics.GLine;
import java.awt.Color;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public class NameSurferViewer
extends GCanvas
implements NameSurferConstants,
ComponentListener {
    private NameSurferModel model;
    public static final int LABEL_OFFSET = 3;
    public static final int NUM_COLORS = 4;

    public NameSurferViewer(NameSurferModel model) {
        this.addComponentListener(this);
        model.addViewer(this);
        this.model = model;
        this.update();
    }

    public void update() {
        this.removeAll();
        this.drawGrid();
        this.drawLines();
    }

    private void drawGrid() {
        double size = (double)this.getWidth() / 11.0;
        int decade = 1900;
        int i = 0;
        while (i < 11) {
            String decadeStr = "" + (decade + 10 * i);
            double x = size * (double)i;
            this.add(new GLine(x, 0.0, x, this.getHeight()));
            this.add(new GLabel(decadeStr, x + 3.0, this.getHeight() - 3));
            ++i;
        }
        this.add(new GLine(0.0, 20.0, this.getWidth(), 20.0));
        this.add(new GLine(0.0, this.getHeight() - 20, this.getWidth(), this.getHeight() - 20));
    }

    private void drawLines() {
        int i = 0;
        while (i < this.model.getEntryCount()) {
            NameSurferEntry entry = this.model.getEntry(i);
            this.drawEntry(entry, this.getColor(i));
            ++i;
        }
    }

    private void drawEntry(NameSurferEntry entry, Color c) {
        String name = entry.getName();
        int height = this.getHeight() - 40;
        double size = (double)this.getWidth() / 11.0;
        int i = 0;
        while (i < 11) {
            int rank1 = entry.getRank(i);
            double x1 = (double)i * size;
            double y1 = rank1 == 0 ? (double)height : (double)(rank1 - 1) / 1000.0 * (double)height;
            if (i < 10) {
                int rank2 = entry.getRank(i + 1);
                double x2 = (double)(i + 1) * size;
                double y2 = rank2 == 0 ? (double)height : (double)(rank2 - 1) / 1000.0 * (double)height;
                GLine line = new GLine(x1, y1 + 20.0, x2, y2 + 20.0);
                line.setColor(c);
                this.add(line);
            }
            String labelStr = name;
            labelStr = rank1 == 0 ? String.valueOf(labelStr) + " *" : String.valueOf(labelStr) + " " + rank1;
            GLabel label = new GLabel(labelStr, x1 + 3.0, y1 - 3.0 + 20.0);
            label.setColor(c);
            this.add(label);
            ++i;
        }
    }

    private Color getColor(int index) {
        switch (index %= 4) {
            case 0: {
                return Color.BLACK;
            }
            case 1: {
                return Color.RED;
            }
            case 2: {
                return Color.BLUE;
            }
        }
        return Color.MAGENTA;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.update();
    }

    public void componentShown(ComponentEvent e) {
    }
}

