/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.HexInputStream;
import acm.util.JTFTools;
import acm.util.NullAudioClip;
import acm.util.SunAudioClip;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.StringTokenizer;

public class MediaTools {
    public static final String DEFAULT_IMAGE_PATH = ".:images";
    public static final String DEFAULT_AUDIO_PATH = ".:sounds";
    public static final String DEFAULT_DATAFILE_PATH = ".:datafiles";
    private static boolean cachingEnabled = true;
    private static HashMap<String, Image> imageTable = new HashMap();
    private static HashMap<String, AudioClip> audioClipTable = new HashMap();
    private static final Class RESOURCE_CLASS = new MediaTools().getClass();

    private MediaTools() {
    }

    public static Image loadImage(String name) {
        return MediaTools.loadImage(name, DEFAULT_IMAGE_PATH);
    }

    public static Image loadImage(String name, String path) {
        Image image = imageTable.get(name);
        if (image != null) {
            return image;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        StringTokenizer tokenizer = new StringTokenizer(path, ":");
        while (image == null && tokenizer.hasMoreTokens()) {
            URL codeBase;
            Applet applet2;
            URLConnection connection;
            String prefix = tokenizer.nextToken();
            prefix = prefix.equals(".") ? "" : String.valueOf(prefix) + "/";
            URL url = null;
            boolean resourceFlag = false;
            try {
                url = RESOURCE_CLASS.getResource("/" + prefix + name);
                connection = url.openConnection();
                if (connection == null || connection.getContentLength() <= 0) {
                    url = null;
                } else {
                    resourceFlag = true;
                }
            }
            catch (Exception connection2) {
                // empty catch block
            }
            if (url == null && (applet2 = JTFTools.getApplet()) != null && (codeBase = applet2.getCodeBase()) != null) {
                try {
                    url = new URL(codeBase, String.valueOf(prefix) + name);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (url == null) {
                try {
                    if (!new File(String.valueOf(prefix) + name).canRead()) continue;
                    image = toolkit.getImage(String.valueOf(prefix) + name);
                }
                catch (SecurityException applet2) {}
                continue;
            }
            try {
                connection = url.openConnection();
                if (!resourceFlag && connection.getContentLength() <= 0) continue;
                Object content = connection.getContent();
                if (content instanceof ImageProducer) {
                    image = toolkit.createImage((ImageProducer)content);
                    continue;
                }
                if (content == null) continue;
                image = toolkit.getImage(url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (image == null) {
            throw new ErrorException("Cannot find an image named " + name);
        }
        MediaTools.loadImage(image);
        if (cachingEnabled) {
            imageTable.put(name, image);
        }
        return image;
    }

    public static Image loadImage(Image image) {
        MediaTracker tracker = new MediaTracker(JTFTools.createEmptyContainer());
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException ex) {
            throw new ErrorException("Image loading process interrupted");
        }
        return image;
    }

    public static void defineImage(String name, Image image) {
        imageTable.put(name, image);
    }

    public static void flushImage(String name) {
        imageTable.remove(name);
    }

    public static Image createImage(int[][] array) {
        int height = array.length;
        int width = array[0].length;
        int[] pixels = new int[width * height];
        int i = 0;
        while (i < height) {
            System.arraycopy(array[i], 0, pixels, i * width, width);
            ++i;
        }
        return MediaTools.createImage(pixels, width, height);
    }

    public static Image createImage(int[] pixels, int width, int height) {
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, pixels, 0, width));
    }

    public static Image createImage(InputStream in) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int ch = in.read();
            while (ch != -1) {
                out.write(ch);
                ch = in.read();
            }
            return Toolkit.getDefaultToolkit().createImage(out.toByteArray());
        }
        catch (Exception ex) {
            throw new ErrorException("Exception: " + ex);
        }
    }

    public static Image createImage(String[] hexData) {
        return MediaTools.createImage(new HexInputStream(hexData));
    }

    public static int[][] getPixelArray(Image image) {
        Component observer = MediaTools.getImageObserver();
        int width = image.getWidth(observer);
        int height = image.getHeight(observer);
        int[] pixels = new int[width * height];
        int[][] array = new int[height][width];
        PixelGrabber pg = new PixelGrabber(image.getSource(), 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            throw new ErrorException("Transfer interrupted");
        }
        if ((pg.getStatus() & 0x80) != 0) {
            throw new ErrorException("Transfer aborted");
        }
        int i = 0;
        while (i < height) {
            System.arraycopy(pixels, i * width, array[i], 0, width);
            ++i;
        }
        return array;
    }

    public static AudioClip loadAudioClip(String name) {
        return MediaTools.loadAudioClip(name, DEFAULT_AUDIO_PATH);
    }

    public static AudioClip loadAudioClip(String name, String path) {
        AudioClip clip = audioClipTable.get(name);
        if (clip != null) {
            return clip;
        }
        StringTokenizer tokenizer = new StringTokenizer(path, ":");
        while (clip == null && tokenizer.hasMoreTokens()) {
            URL codeBase;
            Applet applet;
            URLConnection connection;
            String prefix = tokenizer.nextToken();
            prefix = prefix.equals(".") ? "" : String.valueOf(prefix) + "/";
            URL url = null;
            boolean resourceFlag = false;
            try {
                url = RESOURCE_CLASS.getResource("/" + prefix + name);
                connection = url.openConnection();
                if (connection == null || connection.getContentLength() <= 0) {
                    url = null;
                } else {
                    resourceFlag = true;
                }
            }
            catch (Exception connection2) {
                // empty catch block
            }
            if (url == null && (applet = JTFTools.getApplet()) != null && (codeBase = applet.getCodeBase()) != null) {
                try {
                    url = new URL(codeBase, String.valueOf(prefix) + name);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (url == null) {
                try {
                    File file = new File(String.valueOf(prefix) + name);
                    if (!file.canRead()) continue;
                    clip = MediaTools.createAudioClip(new FileInputStream(file));
                }
                catch (Exception file) {}
                continue;
            }
            try {
                connection = url.openConnection();
                if (!resourceFlag && connection.getContentLength() <= 0) continue;
                Object content = connection.getContent();
                if (content instanceof AudioClip) {
                    clip = (AudioClip)content;
                    continue;
                }
                if (!(content instanceof InputStream)) continue;
                clip = MediaTools.createAudioClip((InputStream)content);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (clip == null) {
            throw new ErrorException("Cannot find an audio clip named " + name);
        }
        if (cachingEnabled) {
            audioClipTable.put(name, clip);
        }
        return clip;
    }

    public static void defineAudioClip(String name, AudioClip clip) {
        audioClipTable.put(name, clip);
    }

    public static void flushAudioClip(String name) {
        audioClipTable.remove(name);
    }

    public static AudioClip createAudioClip(InputStream in) {
        try {
            return new SunAudioClip(in);
        }
        catch (Exception ex) {
            return new NullAudioClip();
        }
    }

    public static AudioClip createAudioClip(String[] hexData) {
        return MediaTools.createAudioClip(new HexInputStream(hexData));
    }

    public static InputStream openDataFile(String name) {
        return MediaTools.openDataFile(name, DEFAULT_DATAFILE_PATH);
    }

    public static InputStream openDataFile(String name, String path) {
        InputStream in = null;
        StringTokenizer tokenizer = new StringTokenizer(path, ":");
        while (in == null && tokenizer.hasMoreTokens()) {
            URL codeBase;
            Applet applet;
            String prefix = tokenizer.nextToken();
            prefix = prefix.equals(".") ? "" : String.valueOf(prefix) + "/";
            URL url = null;
            try {
                url = RESOURCE_CLASS.getResource("/" + prefix + name);
                URLConnection connection = url.openConnection();
                if (connection == null || connection.getContentLength() <= 0) {
                    url = null;
                }
            }
            catch (Exception connection) {
                // empty catch block
            }
            if (url == null && (applet = JTFTools.getApplet()) != null && (codeBase = applet.getCodeBase()) != null) {
                try {
                    url = new URL(codeBase, String.valueOf(prefix) + name);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (url == null) {
                try {
                    File file = new File(String.valueOf(prefix) + name);
                    if (!file.canRead()) continue;
                    in = new FileInputStream(file);
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                in = url.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (in == null) {
            throw new ErrorException("Cannot find a file named " + name);
        }
        return in;
    }

    public static InputStream getHexInputStream(String[] hexData) {
        return new HexInputStream(hexData);
    }

    public static void setCachingEnabled(boolean flag) {
        cachingEnabled = flag;
    }

    public static boolean isCachingEnabled() {
        return cachingEnabled;
    }

    public static Component getImageObserver() {
        return JTFTools.createEmptyContainer();
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }
}

