/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GCanvasListener;
import acm.graphics.GContainer;
import acm.graphics.GIterator;
import acm.graphics.GMath;
import acm.graphics.GMouseEvent;
import acm.graphics.GObject;
import acm.graphics.GObjectList;
import acm.graphics.GPoint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCanvas
extends Container
implements GContainer {
    private GCanvasListener gCanvasListener;
    private GObject lastObject;
    private GObject dragObject;
    private GObjectList contents = new GObjectList(this);
    private Image offscreenImage;
    private boolean autoRepaint;
    private boolean nativeArcFlag;
    private boolean opaque;

    public GCanvas() {
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.setOpaque(true);
        this.setAutoRepaintFlag(true);
        this.setNativeArcFlag(false);
        this.setLayout(null);
        this.gCanvasListener = new GCanvasListener(this);
        this.addComponentListener(this.gCanvasListener);
        this.addMouseListener(this.gCanvasListener);
        this.addMouseMotionListener(this.gCanvasListener);
    }

    @Override
    public void add(GObject gObject) {
        this.contents.add(gObject);
        this.conditionalRepaint();
    }

    @Override
    public final void add(GObject gObject, double d, double d2) {
        gObject.setLocation(d, d2);
        this.add(gObject);
    }

    @Override
    public final void add(GObject gObject, GPoint gPoint) {
        this.add(gObject, gPoint.getX(), gPoint.getY());
    }

    @Override
    public void remove(GObject gObject) {
        this.contents.remove(gObject);
        this.conditionalRepaint();
    }

    @Override
    public void removeAll() {
        this.contents.removeAll();
        super.removeAll();
        this.repaint();
    }

    @Override
    public Component add(Component component) {
        super.add(component);
        Dimension dimension = component.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            Dimension dimension2 = component.getPreferredSize();
            if (dimension.width == 0) {
                dimension.width = dimension2.width;
            }
            if (dimension.height == 0) {
                dimension.height = dimension2.height;
            }
            component.setSize(dimension);
        }
        return component;
    }

    public final void add(Component component, double d, double d2) {
        component.setLocation(GMath.round(d), GMath.round(d2));
        this.add(component);
    }

    public final void add(Component component, GPoint gPoint) {
        this.add(component, gPoint.getX(), gPoint.getY());
    }

    @Override
    public void remove(Component component) {
        super.remove(component);
        this.conditionalRepaint();
    }

    @Override
    public int getElementCount() {
        return this.contents.getElementCount();
    }

    @Override
    public GObject getElement(int n) {
        return this.contents.getElement(n);
    }

    @Override
    public GObject getElementAt(double d, double d2) {
        return this.contents.getElementAt(d, d2, false);
    }

    @Override
    public final GObject getElementAt(GPoint gPoint) {
        return this.getElementAt(gPoint.getX(), gPoint.getY());
    }

    public Iterator<GObject> iterator() {
        return new GIterator(this, 0);
    }

    public Iterator<GObject> iterator(int n) {
        return new GIterator(this, n);
    }

    public void setOpaque(boolean bl) {
        this.opaque = bl;
        this.conditionalRepaint();
    }

    @Override
    public boolean isOpaque() {
        return this.opaque;
    }

    @Override
    public int getWidth() {
        return this.getSize().width;
    }

    @Override
    public int getHeight() {
        return this.getSize().height;
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics graphics2 = graphics;
        if (this.isOpaque()) {
            if (this.offscreenImage == null) {
                this.initOffscreenImage();
            }
            if (this.offscreenImage != null) {
                graphics = this.offscreenImage.getGraphics();
            }
            Dimension dimension = this.getSize();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(this.getForeground());
        }
        this.contents.mapPaint(graphics);
        if (this.isOpaque() && this.offscreenImage != null) {
            graphics2.drawImage(this.offscreenImage, 0, 0, this);
        }
        super.paint(graphics2);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setAutoRepaintFlag(boolean bl) {
        this.autoRepaint = bl;
    }

    public boolean getAutoRepaintFlag() {
        return this.autoRepaint;
    }

    public void setNativeArcFlag(boolean bl) {
        this.nativeArcFlag = bl;
    }

    public boolean getNativeArcFlag() {
        return this.nativeArcFlag;
    }

    protected void sendToFront(GObject gObject) {
        this.contents.sendToFront(gObject);
        this.conditionalRepaint();
    }

    protected void sendToBack(GObject gObject) {
        this.contents.sendToBack(gObject);
        this.conditionalRepaint();
    }

    protected void sendForward(GObject gObject) {
        this.contents.sendForward(gObject);
        this.conditionalRepaint();
    }

    protected void sendBackward(GObject gObject) {
        this.contents.sendBackward(gObject);
        this.conditionalRepaint();
    }

    protected void dispatchMouseEvent(MouseEvent mouseEvent) {
        int n;
        GObject gObject = this.contents.getElementAt(mouseEvent.getX(), mouseEvent.getY(), true);
        GMouseEvent gMouseEvent = null;
        if (gObject != this.lastObject) {
            if (this.lastObject != null) {
                gMouseEvent = new GMouseEvent(this.lastObject, 505, mouseEvent);
                this.lastObject.fireMouseListeners(gMouseEvent);
            }
            if (gObject != null) {
                gMouseEvent = new GMouseEvent(gObject, 504, mouseEvent);
                gObject.fireMouseListeners(gMouseEvent);
            }
        }
        this.lastObject = gObject;
        if (this.dragObject != null) {
            gObject = this.dragObject;
        }
        if (gObject != null && (n = mouseEvent.getID()) != 505 && n != 504 && (n != 506 || this.dragObject != null)) {
            if (n == 501) {
                this.dragObject = gObject;
            } else if (n == 502) {
                this.dragObject = null;
            }
            gMouseEvent = new GMouseEvent(gObject, n, mouseEvent);
            gObject.fireMouseListeners(gMouseEvent);
        }
        if (gMouseEvent != null && gMouseEvent.isConsumed()) {
            mouseEvent.consume();
        }
    }

    protected void initOffscreenImage() {
        Dimension dimension = this.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        this.offscreenImage = this.createImage(dimension.width, dimension.height);
    }

    protected void conditionalRepaint() {
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    protected void updateEnabledList() {
        this.contents.updateEnabledList();
    }

    static MouseEvent createMouseEvent(Object object, int n, MouseEvent mouseEvent) {
        return new GMouseEvent(object, n, mouseEvent);
    }
}

