/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GCanvas;
import acm.graphics.GContainer;
import acm.graphics.GIterator;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GObjectList;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import acm.graphics.GScalable;
import acm.util.ErrorException;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCompound
extends GObject
implements GContainer,
GScalable {
    private boolean complete = false;
    private GObjectList contents = new GObjectList(this);
    private GObject lastObject;
    private GObject dragObject;
    static final long serialVersionUID = 1L;

    @Override
    public void add(GObject gObject) {
        if (this.complete) {
            throw new ErrorException("You can't add objects to a GCompound that has been marked as complete.");
        }
        this.contents.add(gObject);
        this.repaint();
    }

    @Override
    public final void add(GObject gObject, double d, double d2) {
        gObject.setLocation(d, d2);
        this.add(gObject);
    }

    @Override
    public final void add(GObject gObject, GPoint gPoint) {
        this.add(gObject, gPoint.getX(), gPoint.getY());
    }

    @Override
    public void remove(GObject gObject) {
        if (this.complete) {
            throw new ErrorException("You can't remove objects from a GCompound that has been marked as complete.");
        }
        this.contents.remove(gObject);
        this.repaint();
    }

    @Override
    public void removeAll() {
        if (this.complete) {
            throw new ErrorException("You can't remove objects from a GCompound that has been marked as complete.");
        }
        this.contents.removeAll();
        this.repaint();
    }

    @Override
    public int getElementCount() {
        return this.contents.getElementCount();
    }

    @Override
    public GObject getElement(int n) {
        return this.contents.getElement(n);
    }

    @Override
    public GObject getElementAt(double d, double d2) {
        return this.contents.getElementAt(d, d2, false);
    }

    @Override
    public final GObject getElementAt(GPoint gPoint) {
        return this.getElementAt(gPoint.getX(), gPoint.getY());
    }

    public Iterator<GObject> iterator() {
        return new GIterator(this, 0);
    }

    public Iterator<GObject> iterator(int n) {
        return new GIterator(this, n);
    }

    @Override
    public void paint(Graphics graphics) {
        graphics = graphics.create();
        graphics.translate(GMath.round(this.getX()), GMath.round(this.getY()));
        this.contents.mapPaint(graphics);
    }

    @Override
    public void scale(double d, double d2) {
        Component component = this.getComponent();
        boolean bl = false;
        if (component instanceof GCanvas) {
            bl = ((GCanvas)component).getAutoRepaintFlag();
            ((GCanvas)component).setAutoRepaintFlag(false);
        }
        for (int i = this.getElementCount() - 1; i >= 0; --i) {
            GObject gObject = this.getElement(i);
            gObject.setLocation(d * gObject.getX(), d2 * gObject.getY());
            if (!(gObject instanceof GScalable)) continue;
            ((GScalable)((Object)gObject)).scale(d, d2);
        }
        if (component instanceof GCanvas) {
            ((GCanvas)component).setAutoRepaintFlag(bl);
        }
        this.repaint();
    }

    @Override
    public final void scale(double d) {
        this.scale(d, d);
    }

    @Override
    public GRectangle getBounds() {
        GRectangle gRectangle = this.contents.getBounds();
        gRectangle.translate(this.getX(), this.getY());
        return gRectangle;
    }

    @Override
    public boolean contains(double d, double d2) {
        return this.contents.contains(d - this.getX(), d2 - this.getY());
    }

    public final GPoint getCanvasPoint(GPoint gPoint) {
        return this.getCanvasPoint(gPoint.getX(), gPoint.getY());
    }

    public GPoint getCanvasPoint(double d, double d2) {
        GContainer gContainer = this;
        while (gContainer instanceof GCompound) {
            GCompound gCompound = gContainer;
            d += gCompound.getX();
            d2 += gCompound.getY();
            gContainer = gCompound.getParent();
        }
        return new GPoint(d, d2);
    }

    public final GPoint getLocalPoint(GPoint gPoint) {
        return this.getLocalPoint(gPoint.getX(), gPoint.getY());
    }

    public GPoint getLocalPoint(double d, double d2) {
        GContainer gContainer = this;
        while (gContainer instanceof GCompound) {
            GCompound gCompound = gContainer;
            d -= gCompound.getX();
            d2 -= gCompound.getY();
            gContainer = gCompound.getParent();
        }
        return new GPoint(d, d2);
    }

    public void markAsComplete() {
        this.complete = true;
    }

    protected void sendToFront(GObject gObject) {
        this.contents.sendToFront(gObject);
        this.repaint();
    }

    protected void sendToBack(GObject gObject) {
        this.contents.sendToBack(gObject);
        this.repaint();
    }

    protected void sendForward(GObject gObject) {
        this.contents.sendForward(gObject);
        this.repaint();
    }

    protected void sendBackward(GObject gObject) {
        this.contents.sendBackward(gObject);
        this.repaint();
    }

    @Override
    protected void fireMouseListeners(MouseEvent mouseEvent) {
        int n;
        if (super.areMouseListenersEnabled()) {
            super.fireMouseListeners(mouseEvent);
            return;
        }
        GPoint gPoint = new GPoint((double)mouseEvent.getX() - this.getX(), (double)mouseEvent.getY() - this.getY());
        GObject gObject = this.getElementAt(gPoint);
        MouseEvent mouseEvent2 = null;
        if (gObject != this.lastObject) {
            if (this.lastObject != null) {
                mouseEvent2 = GCanvas.createMouseEvent(this.lastObject, 505, mouseEvent);
                this.lastObject.fireMouseListeners(mouseEvent2);
            }
            if (gObject != null) {
                mouseEvent2 = GCanvas.createMouseEvent(gObject, 504, mouseEvent);
                gObject.fireMouseListeners(mouseEvent2);
            }
        }
        this.lastObject = gObject;
        if (this.dragObject != null) {
            gObject = this.dragObject;
        }
        if (gObject != null && (n = mouseEvent.getID()) != 505 && n != 504) {
            if (n == 501) {
                this.dragObject = gObject;
            } else if (n == 502) {
                this.dragObject = null;
            }
            mouseEvent2 = GCanvas.createMouseEvent(gObject, n, mouseEvent);
            gObject.fireMouseListeners(mouseEvent2);
        }
        if (mouseEvent2 != null && mouseEvent2.isConsumed()) {
            mouseEvent.consume();
        }
    }

    @Override
    protected boolean areMouseListenersEnabled() {
        if (super.areMouseListenersEnabled()) {
            return true;
        }
        return this.contents.areMouseListenersEnabled();
    }
}

