/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GArc;
import acm.graphics.GFillable;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRectangle;
import acm.graphics.GRoundRect;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.Serializable;

class ArcRenderer
implements Serializable {
    private static final double EPSILON = 1.0E-5;
    private GObject target;
    private Polygon poly;
    private int x0;
    private int y0;
    private GRectangle oldBounds;
    private double oldStart;
    private double oldSweep;
    private boolean cacheValid;

    public ArcRenderer(GObject gObject) {
        this.target = gObject;
        this.poly = new Polygon();
        this.cacheValid = false;
    }

    public synchronized void draw(Graphics graphics) {
        this.validateCache();
        if (((GFillable)((Object)this.target)).isFilled()) {
            graphics.setColor(((GFillable)((Object)this.target)).getFillColor());
            graphics.fillPolygon(this.poly.xpoints, this.poly.ypoints, this.poly.npoints);
            graphics.setColor(this.target.getColor());
            graphics.drawPolygon(this.poly.xpoints, this.poly.ypoints, this.poly.npoints);
        } else if (this.target instanceof GArc) {
            graphics.drawPolyline(this.poly.xpoints, this.poly.ypoints, this.poly.npoints - 1);
        } else {
            graphics.drawPolygon(this.poly.xpoints, this.poly.ypoints, this.poly.npoints);
        }
    }

    private void validateCache() {
        GRectangle gRectangle = null;
        double d = 0.0;
        double d2 = 360.0;
        if (this.target instanceof GOval || this.target instanceof GRoundRect) {
            gRectangle = this.target.getBounds();
        } else {
            GArc gArc = (GArc)this.target;
            gRectangle = gArc.getFrameRectangle();
            d = gArc.getStartAngle();
            d2 = gArc.getSweepAngle();
            if (d != this.oldStart || d2 != this.oldSweep) {
                this.cacheValid = false;
            }
        }
        if (gRectangle == null) {
            return;
        }
        double d3 = gRectangle.getX();
        double d4 = gRectangle.getY();
        double d5 = gRectangle.getWidth();
        double d6 = gRectangle.getHeight();
        if (d5 <= 0.0 || d6 <= 0.0) {
            return;
        }
        if (!this.cacheValid || d5 != this.oldBounds.getWidth() || d6 != this.oldBounds.getHeight()) {
            this.poly.npoints = 0;
            if (this.target instanceof GRoundRect) {
                GRoundRect gRoundRect = (GRoundRect)this.target;
                double d7 = GMath.round(gRoundRect.getArcWidth());
                double d8 = GMath.round(gRoundRect.getArcHeight());
                this.poly.addPoint(GMath.round(d3 + d7 / 2.0 + 1.0E-5), GMath.round(d4 + 1.0E-5));
                this.addArc(d3, d4, d7, d8, 90.0, 90.0);
                this.addArc(d3, d4 + d6 - d8, d7, d8, 180.0, 90.0);
                this.addArc(d3 + d5 - d7, d4 + d6 - d8, d7, d8, 270.0, 90.0);
                this.addArc(d3 + d5 - d7, d4, d7, d8, 0.0, 90.0);
            } else {
                this.addArc(d3, d4, d5, d6, d, d2);
                if (this.target instanceof GArc) {
                    this.poly.addPoint(GMath.round(d3 + d5 / 2.0 + 1.0E-5), GMath.round(d4 + d6 / 2.0 + 1.0E-5));
                    this.oldStart = d;
                    this.oldSweep = d2;
                }
            }
            this.x0 = GMath.round((double)this.poly.xpoints[0] - d3);
            this.y0 = GMath.round((double)this.poly.ypoints[0] - d4);
            this.oldBounds = gRectangle;
        }
        if (d3 != this.oldBounds.getX() || d4 != this.oldBounds.getY()) {
            this.movePoly(GMath.round(d3 + 1.0E-5), GMath.round(d4 + 1.0E-5));
            this.oldBounds = gRectangle;
        }
        this.cacheValid = true;
    }

    private synchronized void addArc(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d4 / d3;
        double d8 = d3 / 2.0;
        double d9 = d4 / 2.0;
        double d10 = d + d8;
        double d11 = d2 + d9;
        if (d6 < 0.0) {
            d5 += d6;
            d6 = -d6;
        }
        if (d6 > 359.99) {
            d6 = 360.0;
        }
        double d12 = Math.atan2(1.0, Math.max(d3, d4));
        int n = (int)(GMath.toRadians(d6) / d12);
        d12 = GMath.toRadians(d6) / (double)n;
        double d13 = GMath.toRadians(d5);
        for (int i = 0; i <= n; ++i) {
            double d14 = d10 + d8 * Math.cos(d13);
            double d15 = d11 - d8 * Math.sin(d13) * d7;
            this.poly.addPoint(GMath.round(d14 + 1.0E-5), GMath.round(d15 + 1.0E-5));
            d13 += d12;
        }
    }

    private synchronized void movePoly(int n, int n2) {
        int n3 = n - (this.poly.xpoints[0] - this.x0);
        int n4 = n2 - (this.poly.ypoints[0] - this.y0);
        int n5 = 0;
        while (n5 < this.poly.npoints) {
            int n6 = n5;
            this.poly.xpoints[n6] = this.poly.xpoints[n6] + n3;
            int n7 = n5++;
            this.poly.ypoints[n7] = this.poly.ypoints[n7] + n4;
        }
    }
}

