/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GCanvas;
import acm.graphics.GCompound;
import acm.graphics.GContainer;
import acm.graphics.GDimension;
import acm.graphics.GFillable;
import acm.graphics.GMath;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import acm.graphics.GResizable;
import acm.util.ErrorException;
import acm.util.JTFTools;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.lang.reflect.Method;

public abstract class GObject
implements Cloneable,
Serializable {
    private GCompound compoundParent;
    private Color objectColor;
    private double xc;
    private double yc;
    private boolean isVisible = true;
    private boolean mouseListenersEnabled = false;
    private transient MouseListener mouseListener;
    private transient MouseMotionListener mouseMotionListener;
    private transient ActionListener actionListener;
    private transient GContainer transientParent;
    static final long serialVersionUID = 1L;

    protected GObject() {
    }

    public abstract void paint(Graphics var1);

    public abstract GRectangle getBounds();

    public void setLocation(double d, double d2) {
        this.xc = d;
        this.yc = d2;
        this.repaint();
    }

    public final void setLocation(GPoint gPoint) {
        this.setLocation(gPoint.getX(), gPoint.getY());
    }

    public GPoint getLocation() {
        return new GPoint(this.xc, this.yc);
    }

    public double getX() {
        return this.xc;
    }

    public double getY() {
        return this.yc;
    }

    public void move(double d, double d2) {
        this.setLocation(this.xc + d, this.yc + d2);
    }

    public final void movePolar(double d, double d2) {
        double d3 = d2 * Math.PI / 180.0;
        this.move(d * Math.cos(d3), -d * Math.sin(d3));
    }

    public GDimension getSize() {
        GRectangle gRectangle = this.getBounds();
        return new GDimension(gRectangle.getWidth(), gRectangle.getHeight());
    }

    public double getWidth() {
        return this.getBounds().getWidth();
    }

    public double getHeight() {
        return this.getBounds().getHeight();
    }

    public boolean contains(double d, double d2) {
        return this.getBounds().contains(GMath.round(d), GMath.round(d2));
    }

    public final boolean contains(GPoint gPoint) {
        return this.contains(gPoint.getX(), gPoint.getY());
    }

    public void sendToFront() {
        if (this.compoundParent != null) {
            this.compoundParent.sendToFront(this);
        } else if (this.transientParent instanceof GCanvas) {
            ((GCanvas)this.transientParent).sendToFront(this);
        } else if (this.transientParent != null) {
            try {
                Class<?> clazz = this.transientParent.getClass();
                Class[] classArray = new Class[]{Class.forName("acm.graphics.GObject")};
                Object[] objectArray = new Object[]{this};
                Method method = clazz.getMethod("sendToFront", classArray);
                if (method != null) {
                    method.invoke((Object)this.transientParent, objectArray);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mouseListenersEnabled) {
            this.updateEnabledList();
        }
    }

    public void sendToBack() {
        if (this.compoundParent != null) {
            this.compoundParent.sendToBack(this);
        } else if (this.transientParent instanceof GCanvas) {
            ((GCanvas)this.transientParent).sendToBack(this);
        } else if (this.transientParent != null) {
            try {
                Class<?> clazz = this.transientParent.getClass();
                Class[] classArray = new Class[]{Class.forName("acm.graphics.GObject")};
                Object[] objectArray = new Object[]{this};
                Method method = clazz.getMethod("sendToBack", classArray);
                if (method != null) {
                    method.invoke((Object)this.transientParent, objectArray);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mouseListenersEnabled) {
            this.updateEnabledList();
        }
    }

    public void sendForward() {
        if (this.compoundParent != null) {
            this.compoundParent.sendForward(this);
        } else if (this.transientParent instanceof GCanvas) {
            ((GCanvas)this.transientParent).sendForward(this);
        } else if (this.transientParent != null) {
            try {
                Class<?> clazz = this.transientParent.getClass();
                Class[] classArray = new Class[]{Class.forName("acm.graphics.GObject")};
                Object[] objectArray = new Object[]{this};
                Method method = clazz.getMethod("sendForward", classArray);
                if (method != null) {
                    method.invoke((Object)this.transientParent, objectArray);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mouseListenersEnabled) {
            this.updateEnabledList();
        }
    }

    public void sendBackward() {
        if (this.compoundParent != null) {
            this.compoundParent.sendBackward(this);
        } else if (this.transientParent instanceof GCanvas) {
            ((GCanvas)this.transientParent).sendBackward(this);
        } else if (this.transientParent != null) {
            try {
                Class<?> clazz = this.transientParent.getClass();
                Class[] classArray = new Class[]{Class.forName("acm.graphics.GObject")};
                Object[] objectArray = new Object[]{this};
                Method method = clazz.getMethod("sendBackward", classArray);
                if (method != null) {
                    method.invoke((Object)this.transientParent, objectArray);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mouseListenersEnabled) {
            this.updateEnabledList();
        }
    }

    public void setColor(Color color) {
        this.objectColor = color;
        this.repaint();
    }

    public Color getColor() {
        GObject gObject = this;
        while (gObject.objectColor == null) {
            GContainer gContainer = gObject.getParent();
            if (gContainer instanceof GObject) {
                gObject = (GObject)((Object)gContainer);
                continue;
            }
            if (gContainer instanceof Component) {
                return ((Component)((Object)gContainer)).getForeground();
            }
            return Color.BLACK;
        }
        return gObject.objectColor;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
        this.repaint();
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public String toString() {
        String string = this.getClass().getName();
        if (string.startsWith("acm.graphics.")) {
            string = string.substring("acm.graphics.".length());
        }
        return string + "[" + this.paramString() + "]";
    }

    public GContainer getParent() {
        return this.compoundParent != null ? this.compoundParent : this.transientParent;
    }

    public void pause(double d) {
        JTFTools.pause(d);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
        this.mouseListenersEnabled = true;
        this.updateEnabledList();
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, mouseMotionListener);
        this.mouseListenersEnabled = true;
        this.updateEnabledList();
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, mouseMotionListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void fireActionEvent(String string) {
        this.fireActionEvent(new ActionEvent(this, 1001, string));
    }

    public void fireActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public void setParent(GContainer gContainer) {
        if (gContainer instanceof GCompound) {
            this.compoundParent = (GCompound)gContainer;
        } else {
            this.transientParent = gContainer;
        }
    }

    protected void fireMouseListeners(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                if (this.mouseListener == null) break;
                this.mouseListener.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                if (this.mouseListener == null) break;
                this.mouseListener.mouseReleased(mouseEvent);
                break;
            }
            case 500: {
                if (this.mouseListener == null) break;
                this.mouseListener.mouseClicked(mouseEvent);
                break;
            }
            case 505: {
                if (this.mouseListener == null) break;
                this.mouseListener.mouseExited(mouseEvent);
                break;
            }
            case 504: {
                if (this.mouseListener == null) break;
                this.mouseListener.mouseEntered(mouseEvent);
                break;
            }
            case 503: {
                if (this.mouseMotionListener == null) break;
                this.mouseMotionListener.mouseMoved(mouseEvent);
                break;
            }
            case 506: {
                if (this.mouseMotionListener == null) break;
                this.mouseMotionListener.mouseDragged(mouseEvent);
            }
        }
    }

    protected boolean areMouseListenersEnabled() {
        return this.mouseListenersEnabled;
    }

    protected void start() {
        this.start(null);
    }

    protected void start(String[] stringArray) {
        try {
            Class<?> clazz = Class.forName("acm.program.GraphicsProgram");
            Class<?> clazz2 = Class.forName("acm.graphics.GObject");
            Class[] classArray = new Class[]{clazz2, stringArray.getClass()};
            Object[] objectArray = new Object[]{this, stringArray};
            Method method = clazz.getMethod("startGraphicsProgram", classArray);
            method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    protected Color getObjectColor() {
        return this.objectColor;
    }

    protected String paramString() {
        Serializable serializable;
        String string = "";
        if (this instanceof GResizable) {
            serializable = this.getBounds();
            string = string + "bounds=(" + ((GRectangle)serializable).getX() + ", " + ((GRectangle)serializable).getY() + ", " + ((GRectangle)serializable).getWidth() + ", " + ((GRectangle)serializable).getHeight() + ")";
        } else {
            serializable = this.getLocation();
            string = string + "location=(" + ((GPoint)serializable).getX() + ", " + ((GPoint)serializable).getY() + ")";
        }
        if (this.objectColor != null) {
            string = string + ", color=" + GObject.colorName(this.objectColor);
        }
        if (this instanceof GFillable) {
            string = string + ", filled=" + ((GFillable)((Object)this)).isFilled();
            serializable = ((GFillable)((Object)this)).getFillColor();
            if (serializable != null && serializable != this.objectColor) {
                string = string + ", fillColor=" + GObject.colorName((Color)serializable);
            }
        }
        return string;
    }

    protected static String colorName(Color color) {
        if (color.equals(Color.BLACK)) {
            return "BLACK";
        }
        if (color.equals(Color.BLUE)) {
            return "BLUE";
        }
        if (color.equals(Color.CYAN)) {
            return "CYAN";
        }
        if (color.equals(Color.DARK_GRAY)) {
            return "DARK_GRAY";
        }
        if (color.equals(Color.GRAY)) {
            return "GRAY";
        }
        if (color.equals(Color.GREEN)) {
            return "GREEN";
        }
        if (color.equals(Color.LIGHT_GRAY)) {
            return "LIGHT_GRAY";
        }
        if (color.equals(Color.MAGENTA)) {
            return "MAGENTA";
        }
        if (color.equals(Color.ORANGE)) {
            return "ORANGE";
        }
        if (color.equals(Color.PINK)) {
            return "PINK";
        }
        if (color.equals(Color.RED)) {
            return "RED";
        }
        if (color.equals(Color.WHITE)) {
            return "WHITE";
        }
        if (color.equals(Color.YELLOW)) {
            return "YELLOW";
        }
        return "0x" + Integer.toString(color.getRGB() & 0xFFFFFF, 16).toUpperCase();
    }

    protected void paintObject(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        Color color = graphics.getColor();
        if (this.objectColor != null) {
            graphics.setColor(this.objectColor);
        }
        this.paint(graphics);
        if (this.objectColor != null) {
            graphics.setColor(color);
        }
    }

    protected Component getComponent() {
        GContainer gContainer = this.getParent();
        while (gContainer instanceof GObject) {
            gContainer = ((GObject)((Object)gContainer)).getParent();
        }
        return gContainer instanceof Component ? (Component)((Object)gContainer) : null;
    }

    protected void updateEnabledList() {
        Component component = this.getComponent();
        if (component instanceof GCanvas) {
            ((GCanvas)component).updateEnabledList();
        }
    }

    protected void repaint() {
        GContainer gContainer = this.getParent();
        while (gContainer instanceof GObject) {
            gContainer = ((GObject)((Object)gContainer)).getParent();
        }
        if (gContainer instanceof GCanvas) {
            ((GCanvas)gContainer).conditionalRepaint();
        }
    }
}

