/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GMath;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import java.awt.Polygon;
import java.io.Serializable;
import java.util.ArrayList;

class VertexList
implements Serializable {
    private ArrayList<GPoint> vertices = new ArrayList();
    private double cx = 0.0;
    private double cy = 0.0;

    public VertexList() {
    }

    public VertexList(VertexList vertexList) {
        this();
        for (int i = 0; i < vertexList.vertices.size(); ++i) {
            this.vertices.add(vertexList.vertices.get(i));
        }
    }

    public synchronized void addVertex(double d, double d2) {
        this.cx = d;
        this.cy = d2;
        this.vertices.add(new GPoint(this.cx, this.cy));
    }

    public synchronized void addEdge(double d, double d2) {
        this.cx += d;
        this.cy += d2;
        this.vertices.add(new GPoint(this.cx, this.cy));
    }

    public void addArc(double d, double d2, double d3, double d4) {
        double d5 = d2 / d;
        double d6 = d / 2.0;
        double d7 = d2 / 2.0;
        double d8 = this.cx - d6 * GMath.cosDegrees(d3);
        double d9 = this.cy + d7 * GMath.sinDegrees(d3);
        if (d4 > 359.99) {
            d4 = 360.0;
        }
        if (d4 < -359.99) {
            d4 = -360.0;
        }
        double d10 = Math.atan2(1.0, Math.max(d, d2));
        int n = (int)(GMath.toRadians(Math.abs(d4)) / d10);
        d10 = GMath.toRadians(d4) / (double)n;
        double d11 = GMath.toRadians(d3);
        for (int i = 0; i < n; ++i) {
            double d12 = d8 + d6 * Math.cos(d11 += d10);
            double d13 = d9 - d6 * Math.sin(d11) * d5;
            this.addVertex(d12, d13);
        }
    }

    public synchronized void add(GPoint[] gPointArray) {
        for (int i = 0; i < gPointArray.length; ++i) {
            this.vertices.add(new GPoint(gPointArray[i].getX(), gPointArray[i].getY()));
        }
    }

    public synchronized void remove(GPoint gPoint) {
        this.vertices.remove(gPoint);
    }

    public synchronized void clear() {
        this.vertices.clear();
    }

    public int size() {
        return this.vertices.size();
    }

    public GPoint getCurrentPoint() {
        return this.vertices.size() == 0 ? null : new GPoint(this.cx, this.cy);
    }

    public synchronized GRectangle getBounds(double d, double d2, double d3, double d4, double d5) {
        int n = this.vertices.size();
        if (n == 0) {
            return new GRectangle();
        }
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = GMath.sinDegrees(d5);
        double d11 = GMath.cosDegrees(d5);
        boolean bl = true;
        for (int i = 0; i < this.vertices.size(); ++i) {
            GPoint gPoint = this.vertices.get(i);
            double d12 = d + d3 * (d11 * gPoint.getX() + d10 * gPoint.getY());
            double d13 = d2 + d4 * (d11 * gPoint.getY() - d10 * gPoint.getX());
            if (bl) {
                d6 = d12;
                d7 = d12;
                d8 = d13;
                d9 = d13;
                bl = false;
                continue;
            }
            d6 = Math.min(d6, d12);
            d7 = Math.max(d7, d12);
            d8 = Math.min(d8, d13);
            d9 = Math.max(d9, d13);
        }
        return new GRectangle(d6, d8, d7 - d6, d9 - d8);
    }

    public synchronized boolean contains(double d, double d2) {
        int n = this.vertices.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            GPoint gPoint = this.vertices.get(i);
            GPoint gPoint2 = this.vertices.get((i + 1) % n);
            if (!(gPoint.getY() < d2 && gPoint2.getY() >= d2) && (!(gPoint2.getY() < d2) || !(gPoint.getY() >= d2)) || !(gPoint.getX() + (d2 - gPoint.getY()) / (gPoint2.getY() - gPoint.getY()) * (gPoint2.getX() - gPoint.getX()) < d)) continue;
            bl = !bl;
        }
        return bl;
    }

    public synchronized Polygon createPolygon(double d, double d2, double d3, double d4, double d5) {
        double d6 = GMath.sinDegrees(d5);
        double d7 = GMath.cosDegrees(d5);
        Polygon polygon = new Polygon();
        for (int i = 0; i < this.vertices.size(); ++i) {
            GPoint gPoint = this.vertices.get(i);
            double d8 = d + d3 * (d7 * gPoint.getX() + d6 * gPoint.getY());
            double d9 = d2 + d4 * (d7 * gPoint.getY() - d6 * gPoint.getX());
            polygon.addPoint(GMath.round(d8), GMath.round(d9));
        }
        return polygon;
    }

    public void recenter() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = true;
        for (int i = 0; i < this.vertices.size(); ++i) {
            GPoint gPoint = this.vertices.get(i);
            if (bl) {
                d = gPoint.getX();
                d2 = gPoint.getX();
                d3 = gPoint.getY();
                d4 = gPoint.getY();
                bl = false;
                continue;
            }
            d = Math.min(d, gPoint.getX());
            d2 = Math.max(d2, gPoint.getX());
            d3 = Math.min(d3, gPoint.getY());
            d4 = Math.max(d4, gPoint.getY());
        }
        double d5 = (d + d2) / 2.0;
        double d6 = (d3 + d4) / 2.0;
        for (int i = 0; i < this.vertices.size(); ++i) {
            GPoint gPoint = this.vertices.get(i);
            gPoint.translate(-d5, -d6);
        }
    }
}

