/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.gui.TableLayout;
import acm.io.IOConsole;
import acm.io.IODialog;
import acm.io.IOModel;
import acm.program.AppletStarter;
import acm.program.CommandLineProgram;
import acm.program.ProgramAppletStub;
import acm.program.ProgramContentPaneLayout;
import acm.program.ProgramFrame;
import acm.program.ProgramMenuBar;
import acm.program.ProgramStartupListener;
import acm.program.ProgramWindowListener;
import acm.util.Animator;
import acm.util.ErrorException;
import acm.util.JTFTools;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Program
extends JApplet
implements IOModel,
Runnable,
MouseListener,
MouseMotionListener,
KeyListener,
ActionListener {
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    private static final int DEFAULT_X = 16;
    private static final int DEFAULT_Y = 40;
    private static final int DEFAULT_WIDTH = 754;
    private static final int DEFAULT_HEIGHT = 492;
    private static final int PRINT_MARGIN = 36;
    private ArrayList<Object> finalizers;
    private HashMap<String, String> parameterTable;
    private JFrame programFrame;
    private AppletStub appletStub;
    private String myTitle;
    private ProgramMenuBar myMenuBar;
    private Component northBorder;
    private Component southBorder;
    private Component eastBorder;
    private Component westBorder;
    private JPanel northPanel;
    private JPanel southPanel;
    private JPanel eastPanel;
    private JPanel westPanel;
    private JPanel centerPanel;
    private IOConsole myConsole;
    private IODialog myDialog;
    private IOModel inputModel;
    private IOModel outputModel;
    private Object startupObject;
    private AppletStarter appletStarter;
    private Rectangle programBounds;
    private boolean started;
    private boolean shown;
    private boolean initFinished;
    private boolean appletMode;

    protected Program() {
        JTFTools.registerApplet(this);
        this.appletMode = this.checkForAppletMode();
        this.shown = false;
        this.parameterTable = null;
        this.finalizers = new ArrayList();
        this.myTitle = this.getClass().getName();
        this.myTitle = this.myTitle.substring(this.myTitle.lastIndexOf(".") + 1);
        this.appletStub = new ProgramAppletStub(this);
        this.setAppletStub(this.appletStub);
        this.initContentPane(this.getContentPane());
        this.setVisible(false);
        this.setConsole(this.createConsole());
        this.myDialog = this.createDialogIO();
        this.myDialog.setAssociatedConsole(this.myConsole);
        this.myMenuBar = this.createMenuBar();
        this.myConsole.setMenuBar(this.myMenuBar);
    }

    @Override
    public void run() {
    }

    @Override
    public void init() {
    }

    @Override
    public void print(String string) {
        this.getOutputModel().print(string);
    }

    @Override
    public final void print(boolean bl) {
        this.print("" + bl);
    }

    @Override
    public final void print(char c) {
        this.print("" + c);
    }

    @Override
    public final void print(double d) {
        this.print("" + d);
    }

    @Override
    public final void print(float f) {
        this.print("" + f);
    }

    @Override
    public final void print(int n) {
        this.print("" + n);
    }

    @Override
    public final void print(long l) {
        this.print("" + l);
    }

    @Override
    public final void print(Object object) {
        this.print("" + object);
    }

    @Override
    public void println() {
        this.getOutputModel().println();
    }

    @Override
    public void println(String string) {
        this.getOutputModel().println(string);
    }

    @Override
    public final void println(boolean bl) {
        this.println("" + bl);
    }

    @Override
    public final void println(char c) {
        this.println("" + c);
    }

    @Override
    public final void println(double d) {
        this.println("" + d);
    }

    @Override
    public final void println(float f) {
        this.println("" + f);
    }

    @Override
    public final void println(int n) {
        this.println("" + n);
    }

    @Override
    public final void println(long l) {
        this.println("" + l);
    }

    @Override
    public final void println(Object object) {
        this.println("" + object);
    }

    @Override
    public void showErrorMessage(String string) {
        this.getOutputModel().showErrorMessage(string);
    }

    @Override
    public final String readLine() {
        return this.readLine(null);
    }

    @Override
    public String readLine(String string) {
        return this.getInputModel().readLine(string);
    }

    @Override
    public final int readInt() {
        return this.readInt(null, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public final int readInt(int n, int n2) {
        return this.readInt(null, n, n2);
    }

    @Override
    public final int readInt(String string) {
        return this.readInt(string, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public int readInt(String string, int n, int n2) {
        return this.getInputModel().readInt(string, n, n2);
    }

    @Override
    public final double readDouble() {
        return this.readDouble(null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public final double readDouble(double d, double d2) {
        return this.readDouble(null, d, d2);
    }

    @Override
    public final double readDouble(String string) {
        return this.readDouble(string, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public double readDouble(String string, double d, double d2) {
        return this.getInputModel().readDouble(string, d, d2);
    }

    @Override
    public final boolean readBoolean() {
        return this.readBoolean(null);
    }

    @Override
    public final boolean readBoolean(String string) {
        return this.readBoolean(string, "true", "false");
    }

    @Override
    public boolean readBoolean(String string, String string2, String string3) {
        return this.getInputModel().readBoolean(string, string2, string3);
    }

    public boolean isAppletMode() {
        return this.appletMode;
    }

    public void setConsole(IOConsole iOConsole) {
        this.myConsole = iOConsole;
    }

    public IOConsole getConsole() {
        return this.myConsole;
    }

    public void setDialog(IODialog iODialog) {
        this.myDialog = iODialog;
    }

    public IODialog getDialog() {
        return this.myDialog;
    }

    public void setInputModel(IOModel iOModel) {
        this.inputModel = iOModel;
    }

    public void setOutputModel(IOModel iOModel) {
        this.outputModel = iOModel;
    }

    public IOModel getInputModel() {
        return this.inputModel == null ? this.myConsole : this.inputModel;
    }

    public IOModel getOutputModel() {
        return this.outputModel == null ? this.myConsole : this.outputModel;
    }

    public BufferedReader getReader() {
        return this.getConsole().getReader();
    }

    public PrintWriter getWriter() {
        return this.getConsole().getWriter();
    }

    public JPanel getRegionPanel(String string) {
        if (string.equals(NORTH)) {
            return this.northPanel;
        }
        if (string.equals(SOUTH)) {
            return this.southPanel;
        }
        if (string.equals(WEST)) {
            return this.westPanel;
        }
        if (string.equals(EAST)) {
            return this.eastPanel;
        }
        if (string.equals(CENTER)) {
            return this.centerPanel;
        }
        throw new ErrorException("getRegionPanel: Illegal region " + string);
    }

    public void add(Component component, String string, Object object) {
        if (string.equals(NORTH)) {
            this.northPanel.add(component, object);
        } else if (string.equals(SOUTH)) {
            this.southPanel.add(component, object);
        } else if (string.equals(WEST)) {
            this.westPanel.add(component, object);
        } else if (string.equals(EAST)) {
            this.eastPanel.add(component, object);
        } else if (string.equals(CENTER)) {
            this.centerPanel.add(component, object);
        } else {
            throw new ErrorException("add: Illegal region " + string);
        }
    }

    public void addActionListeners() {
        this.addActionListeners(this);
    }

    public void addActionListeners(ActionListener actionListener) {
        this.addActionListeners(this.getContentPane(), actionListener);
    }

    public void setTitle(String string) {
        this.myTitle = string;
        if (this.programFrame != null) {
            this.programFrame.setTitle(string);
        }
    }

    public String getTitle() {
        return this.myTitle;
    }

    public ProgramMenuBar getMenuBar() {
        return this.myMenuBar;
    }

    public void start(String[] stringArray) {
        if (this.parameterTable == null) {
            this.parameterTable = Program.createParameterTable(stringArray);
        }
        if (this.getParent() == null) {
            this.initApplicationFrame();
        }
        this.validate();
        this.setVisible(true);
        if (this.programFrame != null) {
            this.programFrame.validate();
            int n = this.centerPanel.getComponentCount();
            n += this.northPanel.getComponentCount();
            n += this.southPanel.getComponentCount();
            n += this.westPanel.getComponentCount();
            if ((n += this.eastPanel.getComponentCount()) > 0) {
                this.programFrame.setVisible(true);
                this.shown = true;
            }
            this.circumventFrameSizeBug(this.programFrame, this.programBounds.getSize());
        }
        this.started = true;
        this.init();
        if (this.programFrame != null && this.myMenuBar != null) {
            this.myMenuBar.install(this.programFrame);
        }
        this.validate();
        this.startRun();
    }

    public void exit() {
        int n = this.finalizers.size();
        for (int i = 0; i < n; ++i) {
            Object object = this.finalizers.get(i);
            try {
                Class<?> clazz = object.getClass();
                Method method = clazz.getMethod("exit", new Class[0]);
                method.invoke(object, new Object[0]);
                continue;
            }
            catch (Exception exception) {
                throw new ErrorException(exception);
            }
        }
        JTFTools.terminateAppletThreads(this);
        if (!this.appletMode) {
            System.exit(0);
        }
    }

    public void addExitHook(Object object) {
        this.finalizers.add(object);
    }

    public void setParameter(String string, String string2) {
        if (this.parameterTable == null) {
            this.parameterTable = new HashMap();
        }
        this.parameterTable.put(string.toLowerCase(), string2);
    }

    public Thread getMainThread() {
        return this.appletStarter == null ? null : this.appletStarter.getMainThread();
    }

    public void pause(double d) {
        JTFTools.pause(d);
    }

    public Dimension getCentralRegionSize() {
        if (this.centerPanel == null) {
            return super.getSize();
        }
        if (this.initFinished) {
            return this.centerPanel.getSize();
        }
        Dimension dimension = this.programFrame == null ? super.getSize() : this.programFrame.getSize();
        Insets insets = this.programFrame == null ? super.getInsets() : this.programFrame.getInsets();
        dimension.width -= this.westPanel.getPreferredSize().width + this.eastPanel.getPreferredSize().width;
        dimension.width -= insets.left + insets.right;
        dimension.height -= this.northPanel.getPreferredSize().height + this.southPanel.getPreferredSize().height;
        dimension.height -= insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    protected JFrame createProgramFrame() {
        return new ProgramFrame(this.getTitle());
    }

    protected IOConsole createConsole() {
        return IOConsole.SYSTEM_CONSOLE;
    }

    protected IODialog createDialogIO() {
        return new IODialog(this.getContentPane());
    }

    protected ProgramMenuBar createMenuBar() {
        return new ProgramMenuBar(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.computeProgramBounds().getSize();
    }

    @Override
    public int getWidth() {
        String string = this.getMyCaller();
        if (string.startsWith("java.") || string.startsWith("javax.")) {
            return super.getWidth();
        }
        return this.getCentralRegionSize().width;
    }

    @Override
    public int getHeight() {
        String string = this.getMyCaller();
        if (string.startsWith("java.") || string.startsWith("javax.")) {
            return super.getHeight();
        }
        return this.getCentralRegionSize().height;
    }

    @Override
    public String getParameter(String string) {
        String string2 = null;
        if (this.parameterTable != null) {
            string2 = this.parameterTable.get(string.toLowerCase());
        }
        if (string2 != null) {
            return string2;
        }
        return super.getParameter(string);
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.setLayout(layoutManager);
        } else {
            super.setLayout(layoutManager);
        }
    }

    @Override
    public LayoutManager getLayout() {
        if (this.isRootPaneCheckingEnabled()) {
            return this.centerPanel.getLayout();
        }
        return super.getLayout();
    }

    @Override
    public void setBackground(Color color) {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.setBackground(color);
        }
        super.setBackground(color);
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            if (object == null) {
                this.centerPanel.add(component, n);
            } else if (object.equals(NORTH)) {
                this.northPanel.add(component, n);
            } else if (object.equals(SOUTH)) {
                this.southPanel.add(component, n);
            } else if (object.equals(WEST)) {
                this.westPanel.add(component, n);
            } else if (object.equals(EAST)) {
                this.eastPanel.add(component, n);
            } else if (object.equals(CENTER)) {
                this.centerPanel.add(component, n);
            } else {
                this.centerPanel.add(component, object, n);
            }
            if (!this.shown && this.programFrame != null) {
                this.programFrame.setVisible(true);
                this.shown = true;
            }
        } else {
            super.addImpl(component, object, n);
        }
    }

    @Override
    public void remove(int n) {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.remove(n);
        } else {
            super.remove(n);
        }
    }

    @Override
    public void remove(Component component) {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.remove(component);
        } else {
            super.remove(component);
        }
    }

    @Override
    public void removeAll() {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.removeAll();
        } else {
            super.removeAll();
        }
    }

    @Override
    public void validate() {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().validate();
        }
        super.validate();
    }

    @Override
    public void repaint() {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().repaint();
        }
        super.repaint();
    }

    @Override
    public final void start() {
        boolean bl = this.appletMode = this.getParent() != null;
        if (this.appletMode) {
            if (!this.started) {
                this.started = true;
                this.validate();
                this.setVisible(true);
                this.appletStarter = new AppletStarter(this);
                this.appletStarter.start();
            }
        } else {
            this.start(null);
        }
    }

    @Override
    public void destroy() {
        Animator.shutdown(this);
        if (this.appletStarter != null) {
            this.appletStarter.stop();
        }
    }

    public static void main(String[] stringArray) {
        HashMap<String, String> hashMap = Program.createParameterTable(stringArray);
        JTFTools.setDebugOptions(hashMap.get("debug"));
        String string = hashMap.get("code");
        if (string == null) {
            string = JTFTools.getMainClass();
        }
        Class<?> clazz = null;
        Program program = null;
        if (string != null) {
            if (string.endsWith(".class")) {
                string = string.substring(0, string.length() - 6);
            }
            string = string.replace('/', '.');
            CommandLineProgram.checkIfHeadless(string);
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                Object t = clazz.newInstance();
                if (t instanceof Program) {
                    program = (Program)t;
                    program.setStartupObject(null);
                } else {
                    string = hashMap.get("program");
                    if (string == null) {
                        throw new ErrorException("Main class does not specify a program");
                    }
                    program = (Program)Class.forName(string).newInstance();
                    program.setStartupObject(t);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (program == null) {
            throw new ErrorException("Cannot determine the main class.");
        }
        program.setParameterTable(hashMap);
        program.start();
    }

    public boolean menuAction(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Quit")) {
            this.exit();
        } else {
            if (string.equals("Print")) {
                Frame frame = JTFTools.getEnclosingFrame(this);
                if (frame == null) {
                    return true;
                }
                PrintJob printJob = frame.getToolkit().getPrintJob(frame, this.myTitle, null);
                if (printJob == null) {
                    return true;
                }
                Graphics graphics = printJob.getGraphics();
                graphics.translate(36, 36);
                frame.printAll(graphics);
                printJob.end();
                return true;
            }
            if (string.equals("Export Applet") || string.equals("Submit Project")) {
                JTFTools.executeExportAction(this, string);
                return true;
            }
        }
        return this.getConsole().menuAction(actionEvent);
    }

    protected Component getBorder(String string) {
        if (string.equals(NORTH)) {
            return this.northBorder;
        }
        if (string.equals(SOUTH)) {
            return this.southBorder;
        }
        if (string.equals(EAST)) {
            return this.eastBorder;
        }
        if (string.equals(WEST)) {
            return this.westBorder;
        }
        throw new ErrorException("Illegal border specification - " + string);
    }

    protected String[] getArgumentArray() {
        if (this.parameterTable == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.parameterTable.get("ARGS"), "\t", false);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    protected boolean isStarted() {
        IOConsole iOConsole = this.getConsole();
        if (iOConsole == null) {
            return false;
        }
        if (iOConsole.getParent() == null) {
            return true;
        }
        Dimension dimension = iOConsole.getSize();
        return iOConsole.isShowing() && dimension.width != 0 && dimension.height != 0;
    }

    protected void startHook() {
    }

    protected void endHook() {
    }

    protected void setAppletStub(AppletStub appletStub) {
        this.appletStub = appletStub;
        this.setStub(appletStub);
    }

    protected AppletStub getAppletStub() {
        return this.appletStub;
    }

    protected void setParameterTable(HashMap<String, String> hashMap) {
        this.parameterTable = hashMap;
    }

    protected HashMap<String, String> getParameterTable() {
        return this.parameterTable;
    }

    protected void setStartupObject(Object object) {
        this.startupObject = object;
    }

    protected Object getStartupObject() {
        return this.startupObject;
    }

    protected void startRun() {
        ProgramStartupListener programStartupListener = new ProgramStartupListener();
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane.isShowing()) {
            jRootPane.addComponentListener(programStartupListener);
            ((Component)jRootPane).validate();
            programStartupListener.waitForStartup(this);
            ((Component)jRootPane).update(((Component)jRootPane).getGraphics());
        }
        jRootPane.setCursor(Cursor.getDefaultCursor());
        this.initFinished = true;
        this.startHook();
        this.runHook();
        this.endHook();
        if (!jRootPane.isShowing() && !this.getContentPane().isShowing()) {
            this.exit();
        }
    }

    protected void runHook() {
        this.run();
    }

    protected static HashMap<String, String> createParameterTable(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            int n = string2.indexOf(61);
            if (n > 0) {
                String string3 = string2.substring(0, n).toLowerCase();
                String string4 = string2.substring(n + 1);
                hashMap.put(string3, string4);
                continue;
            }
            if (string.length() > 0) {
                string = string + '\t';
            }
            string = string + string2;
        }
        hashMap.put("ARGS", string);
        return hashMap;
    }

    private void initContentPane(Container container) {
        container.setLayout(new ProgramContentPaneLayout(this));
        this.northPanel = new JPanel();
        this.southPanel = new JPanel();
        this.eastPanel = new JPanel();
        this.westPanel = new JPanel();
        this.centerPanel = new JPanel();
        this.northPanel.setLayout(new TableLayout(1, 0, 5, 5));
        this.southPanel.setLayout(new TableLayout(1, 0, 5, 5));
        this.westPanel.setLayout(new TableLayout(0, 1, 5, 5));
        this.eastPanel.setLayout(new TableLayout(0, 1, 5, 5));
        this.centerPanel.setLayout(new GridLayout(1, 0));
        container.add((Component)this.northPanel, NORTH);
        container.add((Component)this.southPanel, SOUTH);
        container.add((Component)this.eastPanel, EAST);
        container.add((Component)this.westPanel, WEST);
        container.add((Component)this.centerPanel, CENTER);
    }

    private void addActionListeners(Component component, ActionListener actionListener) {
        if (this.isButton(component)) {
            if (!this.hasActionListener(component)) {
                try {
                    Class[] classArray = new Class[]{Class.forName("java.awt.event.ActionListener")};
                    Object[] objectArray = new Object[]{actionListener};
                    Method method = component.getClass().getMethod("addActionListener", classArray);
                    method.invoke((Object)component, objectArray);
                }
                catch (Exception exception) {
                    throw new ErrorException(exception);
                }
            }
        } else if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.addActionListeners(container.getComponent(i), actionListener);
            }
        }
    }

    private boolean isButton(Component component) {
        return component instanceof Button || component instanceof JButton;
    }

    private boolean hasActionListener(Component component) {
        try {
            Method method = component.getClass().getMethod("getActionListeners", new Class[0]);
            ActionListener[] actionListenerArray = (ActionListener[])method.invoke((Object)component, new Object[0]);
            return actionListenerArray.length > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void initApplicationFrame() {
        this.programFrame = this.createProgramFrame();
        ((ProgramAppletStub)this.appletStub).setFrame(this.programFrame);
        Container container = this.programFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getContentPane(), CENTER);
        this.programFrame.addWindowListener(new ProgramWindowListener(this));
        this.programBounds = this.computeProgramBounds();
        Insets insets = this.programFrame.getInsets();
        int n = this.programBounds.width + insets.left + insets.right;
        int n2 = this.programBounds.height + insets.top + insets.bottom;
        this.programFrame.setBounds(this.programBounds.x, this.programBounds.y, n, n2);
    }

    private int decodeSizeParameter(String string, int n, int n2) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            try {
                Class<?> clazz = this.getClass();
                Field field = clazz.getField("APPLICATION_" + string);
                Object object = field.get(null);
                if (object instanceof Integer) {
                    return (Integer)object;
                }
                if (!(object instanceof String)) {
                    return n;
                }
                string2 = (String)object;
            }
            catch (Exception exception) {
                return n;
            }
        }
        if (string2.equals("*")) {
            string2 = "100%";
        }
        if (string2.endsWith("%")) {
            int n3 = Integer.parseInt(string2.substring(0, string2.length() - 1));
            return (int)Math.round((double)n3 / 100.0 * (double)n2);
        }
        return Integer.parseInt(string2);
    }

    private Rectangle computeProgramBounds() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = this.decodeSizeParameter("WIDTH", 754, dimension.width);
        int n2 = this.decodeSizeParameter("HEIGHT", 492, dimension.height);
        int n3 = this.decodeSizeParameter("X", n >= dimension.width ? 0 : 16, dimension.width);
        int n4 = this.decodeSizeParameter("Y", n2 >= dimension.height ? 0 : 40, dimension.height);
        return new Rectangle(n3, n4, n, n2);
    }

    private boolean checkForAppletMode() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        for (int i = 1; i < stackTraceElementArray.length; ++i) {
            if (stackTraceElementArray[i].getMethodName().indexOf("Applet") < 0) continue;
            return true;
        }
        return false;
    }

    private String getMyCaller() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        return stackTraceElementArray[2].getClassName() + "." + stackTraceElementArray[2].getMethodName();
    }

    private void circumventFrameSizeBug(Frame frame, Dimension dimension) {
        Container container = this.getContentPane();
        Dimension dimension2 = container.getSize();
        if (dimension.equals(dimension2) || dimension2.width == 0 || dimension2.height == 0) {
            return;
        }
        Dimension dimension3 = frame.getSize();
        dimension3.width += dimension.width - dimension2.width;
        dimension3.height += dimension.height - dimension2.height;
        frame.setSize(dimension3.width, dimension3.height);
        frame.validate();
    }
}

