/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.JTFTools;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;

public class FileChooserFilter
extends FileFilter {
    String filenamePattern;
    String filenameDescription;

    public FileChooserFilter() {
        this.filenamePattern = null;
        this.filenameDescription = null;
    }

    public FileChooserFilter(String string) {
        this(string, string + " files");
    }

    public FileChooserFilter(String string, String string2) {
        this.filenamePattern = string;
        this.filenameDescription = string2;
    }

    public boolean accept(File file) {
        if (this.filenamePattern == null) {
            throw new ErrorException("No override definition for accept");
        }
        if (file.isDirectory()) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.filenamePattern, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.length() <= 0 || !JTFTools.matchFilenamePattern(file.getName(), string)) continue;
            return true;
        }
        return false;
    }

    public String getDescription() {
        if (this.filenameDescription == null) {
            throw new ErrorException("No override definition for getDescription");
        }
        return this.filenameDescription;
    }
}

