/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.Animator;
import acm.util.ErrorException;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.lang.reflect.Method;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SpeedBarListener
implements AdjustmentListener,
ChangeListener {
    private Animator animator;
    private Object speedBar;
    private Method getValue;
    private Method getMinimum;
    private Method getMaximum;

    SpeedBarListener() {
    }

    public static void register(Animator animator, Object object) {
        SpeedBarListener speedBarListener = new SpeedBarListener();
        speedBarListener.animator = animator;
        speedBarListener.speedBar = object;
        Class<?> clazz = object.getClass();
        Method method = SpeedBarListener.lookForMethod(clazz, "addAdjustmentListener");
        if (method == null) {
            method = SpeedBarListener.lookForMethod(clazz, "addChangeListener");
        }
        if (method == null) {
            method = SpeedBarListener.lookForMethod(clazz, "addChangeListener");
        }
        try {
            speedBarListener.getValue = clazz.getMethod("getValue", new Class[0]);
            speedBarListener.getMinimum = clazz.getMethod("getMinimum", new Class[0]);
            speedBarListener.getMaximum = clazz.getMethod("getMaximum", new Class[0]);
            Object[] objectArray = new Object[]{speedBarListener};
            method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            throw new ErrorException("Illegal speed bar object");
        }
        speedBarListener.setSpeed();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent != adjustmentEvent) {
            // empty if block
        }
        this.setSpeed();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent != changeEvent) {
            // empty if block
        }
        this.setSpeed();
    }

    public void setSpeed() {
        try {
            int n = (Integer)this.getMinimum.invoke(this.speedBar, new Object[0]);
            int n2 = (Integer)this.getMaximum.invoke(this.speedBar, new Object[0]);
            int n3 = (Integer)this.getValue.invoke(this.speedBar, new Object[0]);
            double d = (double)(n3 - n) / (double)(n2 - n);
            this.animator.setSpeed(d);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private static Method lookForMethod(Class<?> clazz, String string) {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!string.equals(methodArray[i].getName())) continue;
            return methodArray[i];
        }
        return null;
    }
}

