/*
 * Decompiled with CFR 0.152.
 */
package acm.io;

import acm.io.CharacterQueue;
import acm.io.ConsoleActionListener;
import acm.io.ConsoleInputMonitor;
import acm.io.ConsoleModel;
import acm.io.ConsoleOutputMonitor;
import acm.io.IOConsole;
import acm.program.ProgramMenuBar;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.IOException;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

class StandardConsoleModel
implements KeyListener,
FocusListener,
ConsoleModel {
    private static final int PRINT_MARGIN = 36;
    private ActionListener actionListener;
    private ConsoleOutputMonitor outputMonitor = new ConsoleOutputMonitor(this);
    private ConsoleInputMonitor inputMonitor = new ConsoleInputMonitor(this);
    private BufferedReader inputScript;
    private CharacterQueue buffer;
    private SimpleAttributeSet outputAttributes;
    private SimpleAttributeSet inputAttributes;
    private SimpleAttributeSet errorAttributes;
    private JScrollPane scrollPane = new JScrollPane(22, 32);
    private JTextPane textPane = new JTextPane();
    private Document document;
    private String lineSeparator;
    private int base;
    private boolean hasFocus;
    private IOConsole console;
    private ProgramMenuBar menuBar;

    public StandardConsoleModel() {
        this.textPane.addKeyListener(this);
        this.textPane.addFocusListener(this);
        this.scrollPane.setViewportView(this.textPane);
        this.document = this.textPane.getDocument();
        this.lineSeparator = System.getProperty("line.separator");
        this.outputAttributes = new SimpleAttributeSet();
        this.inputAttributes = new SimpleAttributeSet();
        this.errorAttributes = new SimpleAttributeSet();
        this.buffer = new CharacterQueue();
        this.base = 0;
    }

    public void setConsole(IOConsole iOConsole) {
        this.console = iOConsole;
    }

    public IOConsole getConsole() {
        return this.console;
    }

    public void print(String string, int n) {
        this.outputMonitor.print(string, n);
    }

    public String readLine() {
        return this.inputMonitor.readLine();
    }

    public void setInputScript(BufferedReader bufferedReader) {
        this.inputScript = bufferedReader;
        if (this.buffer.isWaiting()) {
            try {
                String string = this.inputScript.readLine();
                this.buffer.enqueue(string + "\n");
            }
            catch (IOException iOException) {
                throw new ErrorException(iOException);
            }
        }
    }

    public BufferedReader getInputScript() {
        return this.inputScript;
    }

    public void clear() {
        this.textPane.setText("");
        this.base = 0;
        this.buffer.clear();
    }

    public String getText() {
        return this.textPane.getText();
    }

    public String getText(int n, int n2) {
        try {
            return this.document.getText(n, n2 - n);
        }
        catch (BadLocationException badLocationException) {
            throw new ErrorException(badLocationException);
        }
    }

    public int getLength() {
        return this.document.getLength();
    }

    public Component getConsolePane() {
        return this.scrollPane;
    }

    public Component getTextPane() {
        return this.textPane;
    }

    public void cut() {
        this.copy();
        this.deleteSelection();
    }

    public void copy() {
        this.textPane.copy();
    }

    public void paste() {
        if (this.textPane.getSelectionEnd() != this.document.getLength()) {
            return;
        }
        int n = this.deleteSelection();
        this.textPane.setSelectionStart(n);
        this.textPane.paste();
        this.textPane.select(this.document.getLength(), this.document.getLength());
        if (this.document instanceof DefaultStyledDocument) {
            DefaultStyledDocument defaultStyledDocument = (DefaultStyledDocument)this.document;
            defaultStyledDocument.setCharacterAttributes(n, this.textPane.getSelectionEnd() - n, this.inputAttributes, true);
        }
    }

    public void selectAll() {
        this.textPane.selectAll();
    }

    public boolean isPointSelection() {
        return this.textPane.getSelectionStart() == this.textPane.getSelectionEnd();
    }

    public void print(PrintJob printJob) {
        Element element;
        int n;
        Graphics graphics = printJob.getGraphics();
        Dimension dimension = printJob.getPageDimension();
        FontMetrics fontMetrics = this.textPane.getFontMetrics(this.textPane.getFont());
        int n2 = fontMetrics.getHeight();
        int n3 = fontMetrics.getAscent();
        int n4 = 36;
        int n5 = 36 + n3;
        int n6 = n = (dimension.height - 72) / n2;
        ElementIterator elementIterator = new ElementIterator(this.document);
        block2: while ((element = elementIterator.next()) != null) {
            if (!element.isLeaf()) continue;
            try {
                int n7 = element.getEndOffset() - element.getStartOffset();
                this.setStyleFromAttributes(graphics, element.getAttributes());
                fontMetrics = graphics.getFontMetrics();
                String string = this.document.getText(element.getStartOffset(), n7);
                int n8 = 0;
                while (true) {
                    boolean bl = false;
                    int n9 = 1;
                    int n10 = string.indexOf("\n", n8);
                    if (n10 == -1) {
                        n10 = string.indexOf(this.lineSeparator, n8);
                        if (n10 == -1) {
                            n10 = string.length();
                            bl = true;
                        } else {
                            n9 = this.lineSeparator.length();
                        }
                    }
                    if (n8 < n10) {
                        String string2 = string.substring(n8, n10);
                        graphics.drawString(string2, n4, n5);
                        n4 += fontMetrics.stringWidth(string2);
                    }
                    if (bl) continue block2;
                    n8 = n10 + n9;
                    n4 = 36;
                    n5 += n2;
                    if (--n6 > 0) continue;
                    graphics.dispose();
                    graphics = printJob.getGraphics();
                    n5 = 36 + n3;
                    n6 = n;
                }
            }
            catch (BadLocationException badLocationException) {
                throw new ErrorException(badLocationException);
            }
        }
        printJob.end();
    }

    public void setInputStyle(int n) {
        if (this.getLength() != 0) {
            throw new ErrorException("Console styles and colors cannot be changed after I/O has started.");
        }
        this.inputAttributes.addAttribute(StyleConstants.Bold, new Boolean((n & 1) != 0));
        this.inputAttributes.addAttribute(StyleConstants.Italic, new Boolean((n & 2) != 0));
    }

    public void setInputColor(Color color) {
        if (this.getLength() != 0) {
            throw new ErrorException("Console styles and colors cannot be changed after I/O has started.");
        }
        this.inputAttributes.addAttribute(StyleConstants.Foreground, color);
    }

    public void setErrorStyle(int n) {
        if (this.getLength() != 0) {
            throw new ErrorException("Console styles and colors cannot be changed after I/O has started.");
        }
        this.errorAttributes.addAttribute(StyleConstants.Bold, new Boolean((n & 1) != 0));
        this.errorAttributes.addAttribute(StyleConstants.Italic, new Boolean((n & 2) != 0));
    }

    public void setErrorColor(Color color) {
        if (this.getLength() != 0) {
            throw new ErrorException("Console styles and colors cannot be changed after I/O has started.");
        }
        this.errorAttributes.addAttribute(StyleConstants.Foreground, color);
    }

    public void requestFocus() {
        if (this.textPane != null) {
            this.textPane.requestFocus();
        }
    }

    public void setMenuBar(ProgramMenuBar programMenuBar) {
        this.menuBar = programMenuBar;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
        if (this.menuBar != null) {
            if (this.actionListener == null) {
                this.actionListener = new ConsoleActionListener(this.console);
            }
            this.menuBar.setFocusedListener(this.actionListener);
            this.console.updateMenuBar(this.menuBar);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        if (this.menuBar != null) {
            this.menuBar.setFocusedListener(null);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (!keyEvent.isMetaDown() && !keyEvent.isControlDown()) {
            this.buffer.enqueue(keyEvent.getKeyChar());
            keyEvent.consume();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 37: {
                this.buffer.enqueue('\u0002');
                break;
            }
            case 39: {
                this.buffer.enqueue('\u0006');
            }
        }
        if (this.menuBar != null) {
            this.menuBar.fireAccelerator(keyEvent);
        }
        keyEvent.consume();
    }

    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    protected void printCallback(String string, int n) {
        this.insert(string, this.base, n);
        this.base += string.length();
        this.setCaretPosition(this.base);
    }

    protected String readLineCallback() {
        char c;
        this.base = this.getLength();
        if (this.inputScript != null) {
            String string = null;
            try {
                string = this.inputScript.readLine();
            }
            catch (IOException iOException) {
                throw new ErrorException(iOException);
            }
            if (string != null) {
                this.insert(string, this.base, 1);
                this.insert("\n", this.base + string.length(), 0);
                this.base += string.length() + 1;
                return string;
            }
            try {
                this.inputScript.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputScript = null;
        }
        this.setCaretPosition(this.base);
        while ((c = this.buffer.dequeue()) != '\n' && c != '\r') {
            if (this.getCaretPosition() < this.base) {
                this.setCaretPosition(this.getLength());
            }
            int n = this.getSelectionStart();
            switch (c) {
                case '\b': 
                case '\u007f': {
                    if (n == this.getSelectionEnd()) {
                        if (n <= this.base) break;
                        this.delete(n - 1, n);
                        --n;
                        break;
                    }
                    n = this.deleteSelection();
                    break;
                }
                case '\u0001': {
                    this.selectAll();
                    n = -1;
                    break;
                }
                case '\u0002': {
                    n = Math.max(this.getSelectionStart() - 1, this.base);
                    break;
                }
                case '\u0003': {
                    this.copy();
                    n = -1;
                    break;
                }
                case '\u0006': {
                    n = Math.min(this.getSelectionEnd() + 1, this.getLength());
                    break;
                }
                case '\u0010': {
                    this.console.printConsole();
                    n = -1;
                    break;
                }
                case '\u0013': {
                    this.console.save();
                    n = -1;
                    break;
                }
                case '\u0016': {
                    this.paste();
                    n = -1;
                    break;
                }
                case '\u0018': {
                    this.cut();
                    n = -1;
                    break;
                }
                default: {
                    if (n != this.getSelectionEnd()) {
                        n = this.deleteSelection();
                    }
                    this.insert("" + c, n, 1);
                    ++n;
                }
            }
            if (n == -1) continue;
            this.select(n, n);
            this.setCaretPosition(n);
        }
        int n = this.getLength() - this.base;
        String string = this.getText(this.base, this.base + n);
        this.insert("\n", this.base + n, 0);
        this.base += n + 1;
        return string;
    }

    public boolean isCommandEnabled(String string) {
        if (string == string) {
            // empty if block
        }
        return this.hasFocus;
    }

    private void insert(String string, int n, int n2) {
        try {
            SimpleAttributeSet simpleAttributeSet = this.outputAttributes;
            switch (n2) {
                case 1: {
                    simpleAttributeSet = this.inputAttributes;
                    break;
                }
                case 2: {
                    simpleAttributeSet = this.errorAttributes;
                }
            }
            this.document.insertString(n, string, simpleAttributeSet);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void delete(int n, int n2) {
        try {
            this.document.remove(n, n2 - n);
        }
        catch (BadLocationException badLocationException) {
            throw new ErrorException(badLocationException);
        }
    }

    private void setCaretPosition(int n) {
        this.textPane.setCaretPosition(n);
    }

    private int getCaretPosition() {
        return this.textPane.getCaretPosition();
    }

    private void select(int n, int n2) {
        this.textPane.select(n, n2);
    }

    private int getSelectionStart() {
        return this.textPane.getSelectionStart();
    }

    private int getSelectionEnd() {
        return this.textPane.getSelectionEnd();
    }

    private int deleteSelection() {
        int n = Math.max(this.base, this.getSelectionStart());
        int n2 = this.getSelectionEnd();
        if (n2 <= this.base) {
            return this.getLength();
        }
        this.delete(n, n2);
        return n;
    }

    private void setStyleFromAttributes(Graphics graphics, AttributeSet attributeSet) {
        Font font = this.textPane.getFont();
        int n = 0;
        if (Boolean.TRUE.equals(attributeSet.getAttribute(StyleConstants.Bold))) {
            n |= 1;
        }
        if (Boolean.TRUE.equals(attributeSet.getAttribute(StyleConstants.Italic))) {
            n |= 2;
        }
        graphics.setFont(new Font(font.getName(), n, font.getSize()));
        Color color = (Color)attributeSet.getAttribute(StyleConstants.Foreground);
        if (color == null) {
            color = this.textPane.getForeground();
        }
        graphics.setColor(color);
    }
}

