/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.program.Program;
import acm.util.JTFTools;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class AppletStarter
implements Runnable {
    private Program myProgram;
    private Thread mainThread;
    private Object executor;

    public AppletStarter(Program program) {
        this.myProgram = program;
    }

    public void start() {
        try {
            this.mainThread = new Thread(this);
            this.mainThread.start();
            if (JTFTools.testDebugOption("startup")) {
                System.out.println("Starting main thread using Thread package");
            }
        }
        catch (SecurityException securityException) {
            if (JTFTools.testDebugOption("startup")) {
                System.out.println("Starting main thread using Executor because " + securityException);
            }
            this.forkUsingExecutor();
        }
    }

    public void stop() {
        try {
            if (this.executor == null) {
                Class<?> clazz = Class.forName("java.lang.Thread");
                Method method = clazz.getMethod("stop", new Class[0]);
                method.invoke((Object)this.mainThread, new Object[0]);
            } else {
                Method method = this.executor.getClass().getMethod("shutdownNow", new Class[0]);
                method.invoke(this.executor, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        this.myProgram.startRun();
    }

    public Thread getMainThread() {
        return this.mainThread;
    }

    private void forkUsingExecutor() {
        try {
            Class<?> clazz = Class.forName("java.util.concurrent.ScheduledExecutor");
            Class[] classArray = new Class[]{Integer.TYPE};
            Object[] objectArray = new Object[]{new Integer(1)};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            this.executor = constructor.newInstance(objectArray);
            Class<?> clazz2 = Class.forName("java.util.concurrent.TimeUnit");
            Field field = clazz2.getField("SECONDS");
            Object object = field.get(null);
            Class[] classArray2 = new Class[]{Class.forName("java.lang.Runnable"), Long.TYPE, Class.forName("java.util.concurrent.TimeUnit")};
            Object[] objectArray2 = new Object[]{this, new Long(0L), object};
            Method method = this.executor.getClass().getMethod("schedule", classArray2);
            method.invoke(this.executor, objectArray2);
        }
        catch (Exception exception) {
            if (JTFTools.testDebugOption("startup")) {
                System.out.println("Executor failed because " + exception);
            }
            this.executor = null;
            this.mainThread = Thread.currentThread();
            this.myProgram.startRun();
        }
    }
}

