/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.io.IOConsole;
import acm.io.IODialog;
import acm.io.IOModel;
import acm.program.CommandLineProgramLoader;
import acm.util.ErrorException;
import acm.util.JTFTools;
import java.applet.AppletStub;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineProgram
implements IOModel,
Runnable,
MouseListener,
MouseMotionListener,
KeyListener,
ActionListener {
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    private HashMap<String, String> parameterTable = null;
    private ArrayList<Object> finalizers = new ArrayList();
    private AppletStub appletStub;
    private String myTitle = this.myTitle.substring(this.myTitle.lastIndexOf(".") + 1);
    private IOConsole myConsole;

    protected CommandLineProgram() {
        this.setConsole(this.createConsole());
    }

    public static void checkIfHeadless(String string) {
        GenericDeclaration genericDeclaration;
        Object object;
        if (!JTFTools.testDebugOption("headless")) {
            try {
                object = Class.forName("java.awt.GraphicsEnvironment");
                genericDeclaration = ((Class)object).getMethod("isHeadless", new Class[0]);
                if (!Boolean.TRUE.equals(((Method)genericDeclaration).invoke(null, new Object[0]))) {
                    return;
                }
            }
            catch (Exception exception) {
                return;
            }
        }
        try {
            object = new CommandLineProgramLoader(string);
            genericDeclaration = ((ClassLoader)object).loadClass(string);
            CommandLineProgram commandLineProgram = (CommandLineProgram)((Class)genericDeclaration).newInstance();
            commandLineProgram.init();
            commandLineProgram.run();
            commandLineProgram.exit();
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    @Override
    public void run() {
    }

    public void init() {
    }

    @Override
    public void print(String string) {
        this.getOutputModel().print(string);
    }

    @Override
    public final void print(boolean bl) {
        this.print("" + bl);
    }

    @Override
    public final void print(char c) {
        this.print("" + c);
    }

    @Override
    public final void print(double d) {
        this.print("" + d);
    }

    @Override
    public final void print(float f) {
        this.print("" + f);
    }

    @Override
    public final void print(int n) {
        this.print("" + n);
    }

    @Override
    public final void print(long l) {
        this.print("" + l);
    }

    @Override
    public final void print(Object object) {
        this.print("" + object);
    }

    @Override
    public void println() {
        this.getOutputModel().println();
    }

    @Override
    public void println(String string) {
        this.getOutputModel().println(string);
    }

    @Override
    public final void println(boolean bl) {
        this.println("" + bl);
    }

    @Override
    public final void println(char c) {
        this.println("" + c);
    }

    @Override
    public final void println(double d) {
        this.println("" + d);
    }

    @Override
    public final void println(float f) {
        this.println("" + f);
    }

    @Override
    public final void println(int n) {
        this.println("" + n);
    }

    @Override
    public final void println(long l) {
        this.println("" + l);
    }

    @Override
    public final void println(Object object) {
        this.println("" + object);
    }

    @Override
    public void showErrorMessage(String string) {
        this.getOutputModel().showErrorMessage(string);
    }

    @Override
    public final String readLine() {
        return this.readLine(null);
    }

    @Override
    public String readLine(String string) {
        return this.getInputModel().readLine(string);
    }

    @Override
    public final int readInt() {
        return this.readInt(null, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public final int readInt(int n, int n2) {
        return this.readInt(null, n, n2);
    }

    @Override
    public final int readInt(String string) {
        return this.readInt(string, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public int readInt(String string, int n, int n2) {
        return this.getInputModel().readInt(string, n, n2);
    }

    @Override
    public final double readDouble() {
        return this.readDouble(null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public final double readDouble(double d, double d2) {
        return this.readDouble(null, d, d2);
    }

    @Override
    public final double readDouble(String string) {
        return this.readDouble(string, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public double readDouble(String string, double d, double d2) {
        return this.getInputModel().readDouble(string, d, d2);
    }

    @Override
    public final boolean readBoolean() {
        return this.readBoolean(null);
    }

    @Override
    public final boolean readBoolean(String string) {
        return this.readBoolean(string, "true", "false");
    }

    @Override
    public boolean readBoolean(String string, String string2, String string3) {
        return this.getInputModel().readBoolean(string, string2, string3);
    }

    public boolean isAppletMode() {
        return false;
    }

    public void setConsole(IOConsole iOConsole) {
        this.myConsole = iOConsole;
    }

    public IOConsole getConsole() {
        return this.myConsole;
    }

    public IODialog getDialog() {
        return null;
    }

    public IOModel getInputModel() {
        return this.getConsole();
    }

    public IOModel getOutputModel() {
        return this.getConsole();
    }

    public BufferedReader getReader() {
        return this.getConsole().getReader();
    }

    public PrintWriter getWriter() {
        return this.getConsole().getWriter();
    }

    public JPanel getRegionPanel(String string) {
        if (string != string) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    public void add(Component component, String string, Object object) {
        if (component != component) {
            // empty if block
        }
        if (string != string) {
            // empty if block
        }
        if (object != object) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    public void addActionListeners() {
        throw new ErrorException("No graphics environment");
    }

    public void addActionListeners(ActionListener actionListener) {
        if (actionListener != actionListener) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    public void setTitle(String string) {
        this.myTitle = string;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void start(String[] stringArray) {
        if (this.parameterTable == null && stringArray != null) {
            this.parameterTable = CommandLineProgram.createParameterTable(stringArray);
        }
        this.init();
        this.run();
    }

    public void exit() {
        int n = this.finalizers.size();
        for (int i = 0; i < n; ++i) {
            Object object = this.finalizers.get(i);
            try {
                Class<?> clazz = object.getClass();
                Method method = clazz.getMethod("exit", new Class[0]);
                method.invoke(object, new Object[0]);
                continue;
            }
            catch (Exception exception) {
                throw new ErrorException(exception);
            }
        }
    }

    public void addExitHook(Object object) {
        this.finalizers.add(object);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    protected IOConsole createConsole() {
        return IOConsole.SYSTEM_CONSOLE;
    }

    protected IODialog createDialogIO() {
        throw new ErrorException("No graphics environment");
    }

    public Dimension getPreferredSize() {
        return new Dimension(0, 0);
    }

    public int getWidth() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    public String getParameter(String string) {
        String string2 = null;
        if (this.parameterTable != null) {
            string2 = this.parameterTable.get(string.toLowerCase());
        }
        return string2;
    }

    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager != layoutManager) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    public LayoutManager getLayout() {
        throw new ErrorException("No graphics environment");
    }

    public void setBackground(Color color) {
        if (color != color) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component != component) {
            // empty if block
        }
        if (object != object) {
            // empty if block
        }
        if (n != n) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    public void remove(int n) {
        if (n != n) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    public void remove(Component component) {
        if (component != component) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    public void removeAll() {
        throw new ErrorException("No graphics environment");
    }

    public void validate() {
        throw new ErrorException("No graphics environment");
    }

    public void repaint() {
        throw new ErrorException("No graphics environment");
    }

    public void destroy() {
    }

    public static void main(String[] stringArray) {
        HashMap<String, String> hashMap = CommandLineProgram.createParameterTable(stringArray);
        JTFTools.setDebugOptions(hashMap.get("debug"));
        String string = hashMap.get("code");
        if (string == null) {
            string = JTFTools.getMainClass();
        }
        Class<?> clazz = null;
        CommandLineProgram commandLineProgram = null;
        if (string != null) {
            if (string.endsWith(".class")) {
                string = string.substring(0, string.length() - 6);
            }
            string = string.replace('/', '.');
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                Object t = clazz.newInstance();
                if (!(t instanceof CommandLineProgram)) {
                    throw new ErrorException("Main class does not specify a program");
                }
                commandLineProgram = (CommandLineProgram)t;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        if (commandLineProgram == null) {
            throw new ErrorException("Cannot determine the main class.");
        }
        commandLineProgram.setParameterTable(hashMap);
        commandLineProgram.start(null);
    }

    public void menuAction(String string) {
        if (string != string) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    protected void setMacMenuBarFlag(boolean bl) {
        if (bl != bl) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    protected boolean getMacMenuBarFlag() {
        throw new ErrorException("No graphics environment");
    }

    protected Component getBorder(String string) {
        if (string != string) {
            // empty if block
        }
        throw new ErrorException("No graphics environment");
    }

    protected String[] getArgumentArray() {
        if (this.parameterTable == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.parameterTable.get("ARGS"), "\t", false);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    protected boolean isStarted() {
        throw new ErrorException("No graphics environment");
    }

    protected void startHook() {
    }

    protected void endHook() {
    }

    protected void setAppletStub(AppletStub appletStub) {
        this.appletStub = appletStub;
    }

    protected AppletStub getAppletStub() {
        return this.appletStub;
    }

    protected void setParameterTable(HashMap<String, String> hashMap) {
        this.parameterTable = hashMap;
    }

    protected HashMap<String, String> getParameterTable() {
        return this.parameterTable;
    }

    protected static HashMap<String, String> createParameterTable(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            int n = string2.indexOf(61);
            if (n > 0) {
                String string3 = string2.substring(0, n).toLowerCase();
                String string4 = string2.substring(n + 1);
                hashMap.put(string3, string4);
                continue;
            }
            if (string.length() > 0) {
                string = string + '\t';
            }
            string = string + string2;
        }
        hashMap.put("ARGS", string);
        return hashMap;
    }
}

