/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.HexInputStream;
import acm.util.ImageSaver;
import acm.util.JTFTools;
import acm.util.NullAudioClip;
import acm.util.SoundClip;
import acm.util.SunAudioClip;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.StringTokenizer;

public class MediaTools {
    public static final String DEFAULT_IMAGE_PATH = ".:images";
    public static final String DEFAULT_AUDIO_PATH = ".:sounds";
    public static final String DEFAULT_DATAFILE_PATH = ".:datafiles";
    private static boolean cachingEnabled = false;
    private static HashMap<String, Image> imageTable = new HashMap();
    private static HashMap<String, AudioClip> audioClipTable = new HashMap();
    private static HashMap<String, ImageSaver> suffixTable = new HashMap();
    private static final Class<?> RESOURCE_CLASS = new MediaTools().getClass();

    private MediaTools() {
    }

    public static Image loadImage(String string) {
        return MediaTools.loadImage(string, DEFAULT_IMAGE_PATH);
    }

    public static Image loadImage(String string, String string2) {
        Image image = imageTable.get(string);
        if (image != null) {
            return image;
        }
        if (string.startsWith("http:")) {
            try {
                image = MediaTools.loadImage(new URL(string));
                if (cachingEnabled) {
                    imageTable.put(string, image);
                }
                return image;
            }
            catch (MalformedURLException malformedURLException) {
                throw new ErrorException("loadImage: Malformed URL");
            }
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        while (image == null && stringTokenizer.hasMoreTokens()) {
            URL uRL;
            Object object;
            String string3 = stringTokenizer.nextToken();
            string3 = string3.equals(".") ? "" : string3 + "/";
            URL uRL2 = null;
            try {
                uRL2 = RESOURCE_CLASS.getResource("/" + string3 + string);
                object = uRL2.openConnection();
                if (object == null || ((URLConnection)object).getContentLength() <= 0) {
                    uRL2 = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uRL2 == null && (object = JTFTools.getApplet()) != null && (uRL = ((Applet)object).getCodeBase()) != null) {
                try {
                    uRL2 = new URL(uRL, string3 + string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (uRL2 == null) {
                try {
                    if (!new File(string3 + string).canRead()) continue;
                    image = toolkit.getImage(string3 + string);
                }
                catch (SecurityException securityException) {}
                continue;
            }
            image = MediaTools.loadImage(uRL2, false);
        }
        if (image == null) {
            throw new ErrorException("Cannot find an image named " + string);
        }
        MediaTools.loadImage(image);
        if (cachingEnabled) {
            imageTable.put(string, image);
        }
        return image;
    }

    public static Image loadImage(URL uRL) {
        return MediaTools.loadImage(uRL, true);
    }

    public static Image loadImage(Image image) {
        MediaTracker mediaTracker = new MediaTracker(JTFTools.createEmptyContainer());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            throw new ErrorException("Image loading process interrupted");
        }
        return image;
    }

    public static void defineImage(String string, Image image) {
        imageTable.put(string, image);
    }

    public static void flushImage(String string) {
        imageTable.remove(string);
    }

    public static Image createImage(int[][] nArray) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        int[] nArray2 = new int[n2 * n];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(nArray[i], 0, nArray2, i * n2, n2);
        }
        return MediaTools.createImage(nArray2, n2, n);
    }

    public static Image createImage(int[] nArray, int n, int n2) {
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n, n2, nArray, 0, n));
        MediaTools.loadImage(image);
        return image;
    }

    public static Image createImage(InputStream inputStream) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = inputStream.read();
            while (n != -1) {
                byteArrayOutputStream.write(n);
                n = inputStream.read();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(byteArrayOutputStream.toByteArray());
            MediaTools.loadImage(image);
            return image;
        }
        catch (Exception exception) {
            throw new ErrorException("Exception: " + exception);
        }
    }

    public static Image createImage(String[] stringArray) {
        return MediaTools.createImage(new HexInputStream(stringArray));
    }

    public static int[][] getPixelArray(Image image) {
        Component component = MediaTools.getImageObserver();
        int n = image.getWidth(component);
        int n2 = image.getHeight(component);
        int[] nArray = new int[n * n2];
        int[][] nArray2 = new int[n2][n];
        PixelGrabber pixelGrabber = new PixelGrabber(image.getSource(), 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new ErrorException("Transfer interrupted");
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new ErrorException("Transfer aborted");
        }
        for (int i = 0; i < n2; ++i) {
            System.arraycopy(nArray, i * n, nArray2[i], 0, n);
        }
        return nArray2;
    }

    public static void saveImage(Image image, String string) {
        MediaTools.saveImage(image, new File(string));
    }

    public static void saveImage(Image image, File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n <= 0) {
            throw new ErrorException("saveImage: No image suffix in file name");
        }
        String string2 = string.substring(n + 1);
        ImageSaver imageSaver = MediaTools.findImageSaver(string2);
        if (imageSaver == null) {
            throw new ErrorException("saveImage: No support for ." + string2 + " format");
        }
        if (file.exists() && !file.delete()) {
            throw new ErrorException("saveImage: Cannot replace " + string);
        }
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            imageSaver.setOutputStream(bufferedOutputStream);
            imageSaver.saveImage(image);
            imageSaver.updateFileType(file);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            throw new ErrorException("saveImage: " + iOException.getMessage());
        }
    }

    public static AudioClip loadAudioClip(String string) {
        return MediaTools.loadAudioClip(string, DEFAULT_AUDIO_PATH);
    }

    public static AudioClip loadAudioClip(String string, String string2) {
        AudioClip audioClip = audioClipTable.get(string);
        if (audioClip != null) {
            return audioClip;
        }
        if (string.startsWith("http:")) {
            try {
                audioClip = MediaTools.loadAudioClip(new URL(string));
                if (audioClip instanceof SoundClip) {
                    ((SoundClip)audioClip).setName(string);
                }
                if (cachingEnabled) {
                    audioClipTable.put(string, audioClip);
                }
                return audioClip;
            }
            catch (MalformedURLException malformedURLException) {
                throw new ErrorException("loadAudioClip: Malformed URL");
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        while (audioClip == null && stringTokenizer.hasMoreTokens()) {
            URL uRL;
            Object object;
            String string3 = stringTokenizer.nextToken();
            string3 = string3.equals(".") ? "" : string3 + "/";
            URL uRL2 = null;
            try {
                uRL2 = RESOURCE_CLASS.getResource("/" + string3 + string);
                object = uRL2.openConnection();
                if (object == null || ((URLConnection)object).getContentLength() <= 0) {
                    uRL2 = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uRL2 == null && (object = JTFTools.getApplet()) != null && (uRL = ((Applet)object).getCodeBase()) != null) {
                try {
                    uRL2 = new URL(uRL, string3 + string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (uRL2 == null) {
                try {
                    object = new File(string3 + string);
                    if (!((File)object).canRead()) continue;
                    audioClip = MediaTools.createAudioClip(new FileInputStream((File)object));
                }
                catch (Exception exception) {}
                continue;
            }
            audioClip = MediaTools.loadAudioClip(uRL2, false);
        }
        if (audioClip == null) {
            throw new ErrorException("Cannot find an audio clip named " + string);
        }
        if (audioClip instanceof SoundClip) {
            ((SoundClip)audioClip).setName(string);
        }
        if (cachingEnabled) {
            audioClipTable.put(string, audioClip);
        }
        return audioClip;
    }

    public static AudioClip loadAudioClip(URL uRL) {
        return MediaTools.loadAudioClip(uRL, true);
    }

    public static void defineAudioClip(String string, AudioClip audioClip) {
        audioClipTable.put(string, audioClip);
    }

    public static void flushAudioClip(String string) {
        audioClipTable.remove(string);
    }

    public static AudioClip createAudioClip(InputStream inputStream) {
        try {
            return new SunAudioClip(inputStream);
        }
        catch (Exception exception) {
            return new NullAudioClip();
        }
    }

    public static AudioClip createAudioClip(String[] stringArray) {
        return MediaTools.createAudioClip(new HexInputStream(stringArray));
    }

    public static InputStream openDataFile(String string) {
        return MediaTools.openDataFile(string, DEFAULT_DATAFILE_PATH);
    }

    public static InputStream openDataFile(String string, String string2) {
        InputStream inputStream = null;
        if (string.startsWith("http:")) {
            try {
                return MediaTools.openDataFile(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                throw new ErrorException("openDataFile: Malformed URL");
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        while (inputStream == null && stringTokenizer.hasMoreTokens()) {
            URL uRL;
            Object object;
            String string3 = stringTokenizer.nextToken();
            string3 = string3.equals(".") ? "" : string3 + "/";
            URL uRL2 = null;
            try {
                uRL2 = RESOURCE_CLASS.getResource("/" + string3 + string);
                object = uRL2.openConnection();
                if (object == null || ((URLConnection)object).getContentLength() <= 0) {
                    uRL2 = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uRL2 == null && (object = JTFTools.getApplet()) != null && (uRL = ((Applet)object).getCodeBase()) != null) {
                try {
                    uRL2 = new URL(uRL, string3 + string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (uRL2 == null) {
                try {
                    object = new File(string3 + string);
                    if (!((File)object).canRead()) continue;
                    inputStream = new FileInputStream((File)object);
                }
                catch (Exception exception) {}
                continue;
            }
            inputStream = MediaTools.openDataFile(uRL2, false);
        }
        if (inputStream == null) {
            throw new ErrorException("Cannot find a file named " + string);
        }
        return inputStream;
    }

    public static InputStream openDataFile(URL uRL) {
        return MediaTools.openDataFile(uRL, true);
    }

    public static BufferedImage createBufferedImage(Image image, int n) {
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static InputStream getHexInputStream(String[] stringArray) {
        return new HexInputStream(stringArray);
    }

    public static void setCachingEnabled(boolean bl) {
        cachingEnabled = bl;
    }

    public static boolean isCachingEnabled() {
        return cachingEnabled;
    }

    public static Component getImageObserver() {
        return JTFTools.createEmptyContainer();
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static Image loadImage(URL uRL, boolean bl) {
        Image image = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            URLConnection uRLConnection = uRL.openConnection();
            if (MediaTools.isResource(uRL) || uRLConnection.getContentLength() > 0) {
                Object object = uRLConnection.getContent();
                if (object instanceof ImageProducer) {
                    image = toolkit.createImage((ImageProducer)object);
                } else if (object != null) {
                    image = toolkit.getImage(uRL);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            if (image == null) {
                throw new ErrorException("Cannot load image from " + uRL);
            }
            MediaTools.loadImage(image);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageSaver findImageSaver(String string) {
        string = string.toUpperCase();
        HashMap<String, ImageSaver> hashMap = suffixTable;
        synchronized (hashMap) {
            ImageSaver imageSaver = suffixTable.get(string);
            if (imageSaver == null) {
                try {
                    Class<?> clazz = Class.forName("acm.util." + string + "ImageSaver");
                    imageSaver = (ImageSaver)clazz.newInstance();
                }
                catch (Exception exception) {
                    return null;
                }
                suffixTable.put(string, imageSaver);
            }
            return imageSaver;
        }
    }

    public static AudioClip loadAudioClip(URL uRL, boolean bl) {
        AudioClip audioClip = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            if (MediaTools.isResource(uRL) || uRLConnection.getContentLength() > 0) {
                audioClip = MediaTools.createAudioClip(uRLConnection.getInputStream());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl && audioClip == null) {
            throw new ErrorException("Cannot load audio clip from " + uRL);
        }
        return audioClip;
    }

    public static InputStream openDataFile(URL uRL, boolean bl) {
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            if (MediaTools.isResource(uRL) || uRLConnection.getContentLength() > 0) {
                inputStream = uRLConnection.getInputStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl && inputStream == null) {
            throw new ErrorException("Cannot read data from " + uRL);
        }
        return inputStream;
    }

    private static boolean isResource(URL uRL) {
        String string = uRL.toString().toLowerCase();
        return string.startsWith("jar:") || string.startsWith("file:");
    }
}

