/*
 * Decompiled with CFR 0.152.
 */
package acmx.classfile;

import acm.util.ErrorException;
import acmx.classfile.Attribute;
import acmx.classfile.ClassEntry;
import acmx.classfile.ConstantPoolEntry;
import acmx.classfile.ConstantPoolIterator;
import acmx.classfile.FieldIterator;
import acmx.classfile.JavaField;
import acmx.classfile.JavaMethod;
import acmx.classfile.MethodIterator;
import acmx.classfile.MethodRefEntry;
import acmx.classfile.NameAndTypeEntry;
import acmx.classfile.UTF8Entry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClass {
    public static final int MAGIC_NUMBER = -889275714;
    public static final int COMPATIBLE_MAJOR_VERSION = 45;
    public static final int COMPATIBLE_MINOR_VERSION = 3;
    public static final int UTF8 = 1;
    public static final int INTEGER = 3;
    public static final int FLOAT = 4;
    public static final int LONG = 5;
    public static final int DOUBLE = 6;
    public static final int CLASS = 7;
    public static final int STRING = 8;
    public static final int FIELD_REF = 9;
    public static final int METHOD_REF = 10;
    public static final int INTERFACE_METHOD_REF = 11;
    public static final int NAME_AND_TYPE = 12;
    private HashMap<String, Integer> utfTable;
    private HashMap<String, Integer> methodRefTable;
    private HashMap<String, Integer> nameAndTypeTable;
    private ArrayList<ConstantPoolEntry> constantPool;
    private int[] interfaces;
    private JavaField[] fields;
    private JavaMethod[] methods;
    private ArrayList<Attribute> attributes;
    private int minorVersion;
    private int majorVersion;
    private int accessFlags;
    private int classID;
    private int superclassID;

    public JavaClass(DataInputStream in) {
        try {
            this.readHeader(in);
            this.readConstantPool(in);
            this.readClassData(in);
            this.readInterfaces(in);
            this.readFields(in);
            this.readMethods(in);
            this.readAttributes(in);
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(-889275714);
        out.writeShort(this.minorVersion);
        out.writeShort(this.majorVersion);
        int constantPoolCount = this.constantPool.size();
        out.writeShort(constantPoolCount);
        int index = 1;
        while (index < constantPoolCount) {
            ConstantPoolEntry entry = this.constantPool.get(index);
            entry.write(out);
            if (entry.takesTwoSlots()) {
                ++index;
            }
            ++index;
        }
        out.writeShort(this.accessFlags);
        out.writeShort(this.classID);
        out.writeShort(this.superclassID);
        out.writeShort(this.interfaces.length);
        int i = 0;
        while (i < this.interfaces.length) {
            out.writeShort(this.interfaces[i]);
            ++i;
        }
        out.writeShort(this.fields.length);
        i = 0;
        while (i < this.fields.length) {
            this.fields[i].write(out);
            ++i;
        }
        out.writeShort(this.methods.length);
        i = 0;
        while (i < this.methods.length) {
            this.methods[i].write(out);
            ++i;
        }
        out.writeShort(this.attributes.size());
        i = 0;
        while (i < this.attributes.size()) {
            this.attributes.get(i).write(out);
            ++i;
        }
    }

    public void unparseClass(PrintWriter wr) {
        wr.println(String.valueOf(this.createClassHeaderLine()) + " {");
        wr.println("Constant pool:");
        this.unparseConstantPool(wr, "  ");
        int i = 0;
        while (i < this.fields.length) {
            JavaField field = this.fields[i];
            wr.println("  " + field);
            ++i;
        }
        i = 0;
        while (i < this.methods.length) {
            JavaMethod method = this.methods[i];
            wr.println("  " + method);
            ++i;
        }
        i = 0;
        while (i < this.attributes.size()) {
            Attribute attribute = this.attributes.get(i);
            wr.println("  " + attribute);
            ++i;
        }
        wr.println("}");
    }

    public void unparseConstantPool(PrintWriter wr) {
        this.unparseConstantPool(wr, "");
    }

    public void setMajorVersion(int version) {
        this.majorVersion = version;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMinorVersion(int version) {
        this.minorVersion = version;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setAccessFlags(int flags) {
        this.accessFlags = flags;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public int getClassID() {
        return this.classID;
    }

    public void setClassID(int id) {
        this.classID = id;
    }

    public int getSuperclassID() {
        return this.superclassID;
    }

    public void setSuperclassID(int id) {
        this.superclassID = id;
    }

    public String getClassName() {
        ClassEntry classEntry = (ClassEntry)this.getConstantPoolEntry(this.classID);
        return classEntry.getName().replace('/', '.');
    }

    public String getSuperclassName() {
        ClassEntry classEntry = (ClassEntry)this.getConstantPoolEntry(this.superclassID);
        return classEntry.getName().replace('/', '.');
    }

    public int getConstantPoolCount() {
        return this.constantPool.size();
    }

    public ConstantPoolEntry getConstantPoolEntry(int index) {
        return this.constantPool.get(index);
    }

    public Iterator<ConstantPoolEntry> constantPoolIterator() {
        return new ConstantPoolIterator(this);
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    public JavaField getField(int index) {
        return this.fields[index];
    }

    public Iterator<JavaField> fieldIterator() {
        return new FieldIterator(this);
    }

    public int getMethodCount() {
        return this.methods.length;
    }

    public JavaMethod getMethod(int index) {
        return this.methods[index];
    }

    public Iterator<JavaMethod> methodIterator() {
        return new MethodIterator(this);
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public Attribute getAttribute(int index) {
        return this.attributes.get(index);
    }

    public Iterator<Attribute> attributeIterator() {
        return this.attributes.iterator();
    }

    public String getUTF8Name(int index) {
        UTF8Entry entry = (UTF8Entry)this.constantPool.get(index);
        return entry.getName();
    }

    public int createUTF8Entry(String name) {
        Integer ip = this.utfTable.get(name);
        if (ip != null) {
            return ip;
        }
        int index = this.constantPool.size();
        this.constantPool.add(new UTF8Entry(name, this));
        this.utfTable.put(name, new Integer(index));
        return index;
    }

    public int createNameAndTypeEntry(int nameIndex, int typeIndex) {
        Integer ip = this.nameAndTypeTable.get(String.valueOf(nameIndex) + ":" + typeIndex);
        if (ip != null) {
            return ip;
        }
        NameAndTypeEntry ntEntry = new NameAndTypeEntry(nameIndex, typeIndex, this);
        int index = this.constantPool.size();
        this.constantPool.add(ntEntry);
        this.nameAndTypeTable.put(String.valueOf(nameIndex) + ":" + typeIndex, index);
        return index;
    }

    public int createMethodRefEntry(String prototype) {
        Integer ip = this.methodRefTable.get(prototype);
        if (ip != null) {
            return ip;
        }
        StringTokenizer tokenizer = new StringTokenizer(prototype, ":");
        String className = tokenizer.nextToken();
        String methodName = tokenizer.nextToken();
        String descriptor = tokenizer.nextToken();
        int classNameIndex = this.createUTF8Entry(className);
        int methodNameIndex = this.createUTF8Entry(methodName);
        int descriptorIndex = this.createUTF8Entry(descriptor);
        int classIndex = this.constantPool.size();
        this.constantPool.add(new ClassEntry(classNameIndex, this));
        int ntIndex = classIndex + 1;
        this.constantPool.add(new NameAndTypeEntry(methodNameIndex, descriptorIndex, this));
        int methodRefIndex = classIndex + 2;
        this.constantPool.add(new MethodRefEntry(classIndex, ntIndex, this));
        this.methodRefTable.put(prototype, new Integer(methodRefIndex));
        return methodRefIndex;
    }

    public static String typeToString(String descriptor) {
        int arrayDepth = 0;
        String result = "";
        int cp = 0;
        while (cp < descriptor.length()) {
            char ch = descriptor.charAt(cp);
            if (ch == '[') {
                ++arrayDepth;
            } else {
                String argType = "";
                switch (ch) {
                    case 'B': {
                        argType = "byte";
                        break;
                    }
                    case 'C': {
                        argType = "char";
                        break;
                    }
                    case 'D': {
                        argType = "double";
                        break;
                    }
                    case 'F': {
                        argType = "float";
                        break;
                    }
                    case 'I': {
                        argType = "int";
                        break;
                    }
                    case 'J': {
                        argType = "long";
                        break;
                    }
                    case 'S': {
                        argType = "short";
                        break;
                    }
                    case 'V': {
                        argType = "void";
                        break;
                    }
                    case 'Z': {
                        argType = "boolean";
                        break;
                    }
                    case 'L': {
                        int semi = descriptor.indexOf(59, cp);
                        argType = descriptor.substring(cp + 1, semi);
                        argType = argType.substring(argType.lastIndexOf(47) + 1);
                        cp = semi;
                    }
                }
                if (result.length() > 0) {
                    result = String.valueOf(result) + ", ";
                }
                result = String.valueOf(result) + argType;
                int i = 0;
                while (i < arrayDepth) {
                    result = String.valueOf(result) + "[]";
                    ++i;
                }
                arrayDepth = 0;
            }
            ++cp;
        }
        return result;
    }

    public static String nameAndTypeToString(String name, String descriptor) {
        String str = "";
        if (descriptor.startsWith("(")) {
            int paren = descriptor.indexOf(")");
            str = JavaClass.typeToString(descriptor.substring(paren + 1));
            str = String.valueOf(str) + " " + name;
            str = String.valueOf(str) + "(" + JavaClass.typeToString(descriptor.substring(1, paren)) + ")";
        } else {
            str = String.valueOf(JavaClass.typeToString(descriptor)) + " " + name;
        }
        return str;
    }

    private void readHeader(DataInputStream in) throws IOException {
        if (in.readInt() != -889275714) {
            throw new ErrorException("Not a class file");
        }
        this.minorVersion = in.readShort();
        this.majorVersion = in.readShort();
    }

    private void readConstantPool(DataInputStream in) throws IOException {
        this.utfTable = new HashMap();
        this.methodRefTable = new HashMap();
        this.nameAndTypeTable = new HashMap();
        this.constantPool = new ArrayList();
        this.constantPool.add(null);
        int count = in.readShort();
        int index = 1;
        while (index < count) {
            ConstantPoolEntry entry = ConstantPoolEntry.readNext(in, this);
            if (entry instanceof UTF8Entry) {
                String name = ((UTF8Entry)entry).getName();
                this.utfTable.put(name, new Integer(index));
            }
            this.constantPool.add(entry);
            if (entry.takesTwoSlots()) {
                this.constantPool.add(null);
                ++index;
            }
            ++index;
        }
    }

    private void readClassData(DataInputStream in) throws IOException {
        this.accessFlags = in.readShort();
        this.classID = in.readShort();
        this.superclassID = in.readShort();
    }

    private void readInterfaces(DataInputStream in) throws IOException {
        int count = in.readShort();
        this.interfaces = new int[count];
        int i = 0;
        while (i < count) {
            this.interfaces[i] = in.readShort();
            ++i;
        }
    }

    private void readFields(DataInputStream in) throws IOException {
        int count = in.readShort();
        this.fields = new JavaField[count];
        int i = 0;
        while (i < count) {
            this.fields[i] = new JavaField(in, this);
            ++i;
        }
    }

    private void readMethods(DataInputStream in) throws IOException {
        int count = in.readShort();
        this.methods = new JavaMethod[count];
        int i = 0;
        while (i < count) {
            this.methods[i] = new JavaMethod(in, this);
            ++i;
        }
    }

    private void readAttributes(DataInputStream in) throws IOException {
        int count = in.readShort();
        this.attributes = new ArrayList();
        int i = 0;
        while (i < count) {
            this.attributes.add(new Attribute(in, this));
            ++i;
        }
    }

    private String createClassHeaderLine() {
        String modifiers = "";
        String entryType = "class";
        String className = this.getClassName();
        String superclassName = this.getSuperclassName();
        String header = String.valueOf(modifiers) + entryType + " " + className + " extends " + superclassName;
        if (this.interfaces.length > 0) {
            header = String.valueOf(header) + " implements ";
            int i = 0;
            while (i < this.interfaces.length) {
                if (i > 0) {
                    header = String.valueOf(header) + ", ";
                }
                ClassEntry interfaceEntry = (ClassEntry)this.getConstantPoolEntry(this.interfaces[i]);
                header = String.valueOf(header) + interfaceEntry.getName();
                ++i;
            }
        }
        return header;
    }

    private void unparseConstantPool(PrintWriter wr, String prefix) {
        int n = this.getConstantPoolCount();
        int index = 1;
        while (index < n) {
            ConstantPoolEntry entry = this.getConstantPoolEntry(index);
            wr.println(String.valueOf(prefix) + index + ": " + entry);
            if (entry.takesTwoSlots()) {
                ++index;
            }
            ++index;
        }
    }
}

