/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionTable {
    private HashMap<String, String> optionTable = new HashMap();

    public OptionTable(String str) {
        this(str, null);
    }

    public OptionTable(String str, String[] keys) {
        try {
            StreamTokenizer tokenizer = this.createTokenizer(str);
            int ttype = tokenizer.nextToken();
            while (ttype != -1) {
                if (ttype != -3) {
                    throw new ErrorException("Illegal option string: " + str);
                }
                String key = tokenizer.sval;
                if (keys != null && !this.keyExists(key, keys)) {
                    throw new ErrorException("Unrecognized option: " + key);
                }
                ttype = tokenizer.nextToken();
                if (ttype == 61) {
                    ttype = tokenizer.nextToken();
                    if (ttype != -3 && ttype != 34 && ttype != 39) {
                        throw new ErrorException("Illegal option string: " + str);
                    }
                    this.optionTable.put(key, tokenizer.sval);
                    ttype = tokenizer.nextToken();
                    continue;
                }
                this.optionTable.put(key, "");
            }
        }
        catch (IOException ex) {
            throw new ErrorException("Illegal option string: " + str);
        }
    }

    public OptionTable(Map<String, String> map) {
        for (String key : map.keySet()) {
            String value = map.get(key);
            this.optionTable.put(key, value);
        }
    }

    public boolean isSpecified(String key) {
        return this.optionTable.containsKey(key);
    }

    public String getOption(String key) {
        return this.getOption(key, null);
    }

    public String getOption(String key, String defValue) {
        String value = this.optionTable.get(key);
        return value == null || value.equals("") ? defValue : value;
    }

    public int getIntOption(String key) {
        return this.getIntOption(key, 0);
    }

    public int getIntOption(String key, int defValue) {
        String binding = this.getOption(key, null);
        if (binding == null || binding.equals("")) {
            return defValue;
        }
        return Integer.decode(binding);
    }

    public double getDoubleOption(String key) {
        return this.getDoubleOption(key, 0.0);
    }

    public double getDoubleOption(String key, double defValue) {
        String binding = this.getOption(key, null);
        if (binding == null || binding.equals("")) {
            return defValue;
        }
        return Double.valueOf(binding);
    }

    public HashMap<String, String> getMap() {
        return this.optionTable;
    }

    private StreamTokenizer createTokenizer(String str) {
        StreamTokenizer t = new StreamTokenizer(new StringReader(str));
        t.resetSyntax();
        t.wordChars(33, 60);
        t.wordChars(62, 126);
        t.quoteChar(34);
        t.quoteChar(39);
        t.whitespaceChars(32, 32);
        t.whitespaceChars(9, 9);
        return t;
    }

    private boolean keyExists(String key, String[] keys) {
        int i = 0;
        while (i < keys.length) {
            if (key.equals(keys[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

