/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acm.util.JTFTools;
import acmx.export.javax.swing.border.Border;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public abstract class JComponent
extends Container {
    private Container contents;
    private boolean forwarding;
    private boolean isOpaque;

    public JComponent() {
        this.setLayout(new BorderLayout());
        this.forwarding = false;
        this.contents = JTFTools.createEmptyContainer();
        this.contents.setLayout(new FlowLayout());
        this.add((Component)this.contents, "Center");
        this.forwarding = true;
    }

    public void remove(Component comp) {
        if (this.forwarding) {
            this.contents.remove(comp);
        } else {
            super.remove(comp);
        }
    }

    public void removeAll() {
        if (this.forwarding) {
            this.contents.removeAll();
        } else {
            super.removeAll();
        }
    }

    public void setLayout(LayoutManager layout) {
        if (this.forwarding) {
            this.contents.setLayout(layout);
        } else {
            super.setLayout(layout);
        }
    }

    public LayoutManager getLayout() {
        return this.forwarding ? this.contents.getLayout() : super.getLayout();
    }

    public int getComponentCount() {
        return this.forwarding ? this.contents.getComponentCount() : super.getComponentCount();
    }

    public Component getComponent(int i) {
        return this.forwarding ? this.contents.getComponent(i) : super.getComponent(i);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.forwarding) {
            this.contents.add(comp, constraints, index);
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    public void setBorder(Border border) {
        this.addBorder(border, "North");
        this.addBorder(border, "South");
        this.addBorder(border, "East");
        this.addBorder(border, "West");
    }

    public void setOpaque(boolean opaque) {
        this.isOpaque = opaque;
    }

    public void paint(Graphics g) {
        if (this.isOpaque && !this.childrenFillContainer()) {
            Color oldColor = g.getColor();
            Dimension size = this.getSize();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            g.setColor(oldColor);
        }
        super.paint(g);
        this.paintComponent(g);
    }

    protected void paintComponent(Graphics g) {
        if (g != g) {
            // empty if block
        }
    }

    private boolean childrenFillContainer() {
        Rectangle myBounds = this.getBounds();
        Rectangle obscured = null;
        int nComponents = this.getComponentCount();
        int i = 0;
        while (i < nComponents) {
            Rectangle childBounds = this.getComponent(i).getBounds();
            if (obscured == null) {
                obscured = childBounds;
            } else {
                obscured.add(childBounds);
            }
            Rectangle intersection = obscured.intersection(myBounds);
            if (intersection.equals(myBounds)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void addBorder(Border border, String side) {
        Component comp = border.getBorder(side);
        if (comp != null) {
            super.addImpl(comp, side, -1);
        }
    }
}

