/*
 * Decompiled with CFR 0.152.
 */
package acmx.classfile;

import acmx.classfile.Attribute;
import acmx.classfile.JVMOperation;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CodeIterator
implements Iterator<JVMOperation> {
    private Attribute attribute;
    private byte[] data;
    private int codeEnd;
    private int pc;

    public CodeIterator(Attribute codeAttribute) {
        this.attribute = codeAttribute;
        if (this.attribute == null) {
            return;
        }
        this.data = this.attribute.getData();
        int codeLength = 0;
        int i = 4;
        while (i < 8) {
            codeLength = codeLength << 8 | this.data[i] & 0xFF;
            ++i;
        }
        this.pc = 8;
        this.codeEnd = this.pc + codeLength;
    }

    @Override
    public boolean hasNext() {
        return this.pc < this.codeEnd;
    }

    @Override
    public JVMOperation next() {
        JVMOperation op = new JVMOperation(this.attribute, this.pc);
        this.pc += op.length();
        return op;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

