/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GArc;
import acm.graphics.GCanvas;
import acm.graphics.GMath;
import acm.graphics.GRect;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public class GRoundRect
extends GRect {
    public static final double DEFAULT_ARC = 10.0;
    private double aWidth;
    private double aHeight;
    private GArc renderer;

    public GRoundRect(double width, double height) {
        this(0.0, 0.0, width, height, 10.0);
    }

    public GRoundRect(double x, double y, double width, double height) {
        this(x, y, width, height, 10.0);
    }

    public GRoundRect(double x, double y, double width, double height, double arcSize) {
        this(x, y, width, height, arcSize, arcSize);
    }

    public GRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        super(x, y, width, height);
        this.aWidth = arcWidth;
        this.aHeight = arcHeight;
        this.renderer = new GArc(this);
    }

    public double getArcWidth() {
        return this.aWidth;
    }

    public double getArcHeight() {
        return this.aHeight;
    }

    public void paint(Graphics g) {
        Component comp = this.getComponent();
        if (comp instanceof GCanvas && !((GCanvas)comp).getNativeArcFlag()) {
            this.renderer.paint(g);
        } else {
            Rectangle r = this.getAWTBounds();
            int iArcWidth = GMath.round(this.aWidth);
            int iArcHeight = GMath.round(this.aHeight);
            if (this.isFilled()) {
                g.setColor(this.getFillColor());
                g.fillRoundRect(r.x, r.y, r.width, r.height, iArcWidth, iArcHeight);
                g.setColor(this.getColor());
            }
            g.drawRoundRect(r.x, r.y, r.width, r.height, iArcWidth, iArcHeight);
        }
    }
}

