/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing.text;

import acm.util.ErrorException;
import acmx.export.javax.swing.JTextPane;
import acmx.export.javax.swing.text.AbstractElement;
import acmx.export.javax.swing.text.AttributeSet;
import acmx.export.javax.swing.text.BadLocationException;
import acmx.export.javax.swing.text.Document;
import acmx.export.javax.swing.text.Element;
import java.util.ArrayList;

public class DefaultStyledDocument
implements Document {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private int selectionStart;
    private int selectionEnd;
    private int length;
    private int lineCount;
    private ArrayList<Element> elements;
    private JTextPane textPane;

    public DefaultStyledDocument() {
        this.clear();
    }

    public final void clear() {
        this.elements = new ArrayList();
        this.length = 0;
        this.lineCount = 0;
        this.selectionStart = 0;
        this.selectionEnd = 0;
        if (this.textPane != null) {
            this.textPane.repaint();
        }
    }

    public int getLength() {
        return this.length;
    }

    public final void setPane(JTextPane pane) {
        this.textPane = pane;
    }

    public final int getLineCount() {
        return this.lineCount;
    }

    public String getText(int offset, int len) throws BadLocationException {
        if (offset < 0 || offset + len > this.length) {
            throw new BadLocationException("Illegal offset " + offset);
        }
        int start = this.findOffsetPosition(offset);
        int finish = this.findOffsetPosition(offset + len);
        String text = "";
        int i = start;
        while (i < finish) {
            Element element = this.elements.get(i);
            String str = element.getString();
            if (str.equals("\n")) {
                str = LINE_SEPARATOR;
            }
            text = String.valueOf(text) + str;
            ++i;
        }
        return text;
    }

    public void insertString(int offset, String str, AttributeSet style) throws BadLocationException {
        if (offset < 0 || offset > this.length) {
            throw new BadLocationException("Illegal offset " + offset);
        }
        int index = this.findOffsetPosition(offset);
        int len = str.length();
        this.elements.add(index, new AbstractElement(str, style));
        this.length += len;
        if (str.equals("\n")) {
            ++this.lineCount;
        }
        if (this.selectionStart >= offset) {
            this.selectionStart += len;
        }
        if (this.selectionEnd >= offset) {
            this.selectionEnd += len;
        }
        this.textPane.repaint();
    }

    public void remove(int offset, int len) throws BadLocationException {
        if (offset < 0 || offset + len > this.length) {
            throw new BadLocationException("Illegal offset " + offset);
        }
        int start = this.findOffsetPosition(offset);
        int finish = this.findOffsetPosition(offset + len);
        int i = start;
        while (i < finish) {
            Element element = this.elements.get(start);
            if (element.getString().equals("\n")) {
                --this.lineCount;
            }
            this.elements.remove(start);
            ++i;
        }
        if (this.selectionStart >= offset) {
            this.selectionStart = Math.max(offset, this.selectionStart - len);
        }
        if (this.selectionEnd >= offset) {
            this.selectionEnd = Math.max(offset, this.selectionEnd - len);
        }
        this.length -= len;
        this.textPane.repaint();
    }

    public void setCharacterAttributes(int offset, int len, AttributeSet style, boolean replace) {
        int start = this.findOffsetPosition(offset);
        int finish = this.findOffsetPosition(offset + len);
        int i = start;
        while (i < finish) {
            Element element = this.elements.get(i);
            if (replace) {
                element.setStyle(style);
            }
            ++i;
        }
        this.textPane.repaint();
    }

    public final int getSelectionStart() {
        return this.selectionStart;
    }

    public final int getSelectionEnd() {
        return this.selectionEnd;
    }

    public final void setSelectionStart(int start) {
        this.selectionStart = start;
    }

    public final void setSelectionEnd(int end) {
        this.selectionEnd = end;
    }

    public final ArrayList getElements() {
        return this.elements;
    }

    public final int findOffsetPosition(int offset) {
        int nElements = this.elements.size();
        if (offset == this.length) {
            return nElements;
        }
        int cp = this.length;
        int i = nElements - 1;
        while (i >= 0) {
            Element element = this.elements.get(i);
            if ((cp -= element.getLength()) == offset) {
                return i;
            }
            if (cp < offset) {
                String str = element.getString();
                AttributeSet style = element.getAttributes();
                AbstractElement s1 = new AbstractElement(str.substring(0, offset - cp), style);
                AbstractElement s2 = new AbstractElement(str.substring(offset - cp), style);
                this.elements.set(i, s2);
                this.elements.add(i, s1);
                return i + 1;
            }
            --i;
        }
        throw new ErrorException("Should not occur");
    }

    public final String getText() {
        String text = "";
        int nElements = this.elements.size();
        int i = 0;
        while (i < nElements) {
            Element element = this.elements.get(i);
            String str = element.getString();
            if (str.equals("\n")) {
                str = LINE_SEPARATOR;
            }
            text = String.valueOf(text) + str;
            ++i;
        }
        return text;
    }
}

