/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acm.util.JTFTools;
import acmx.export.javax.swing.MouseForwarder;
import acmx.export.javax.swing.MouseMotionForwarder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class SwingInteractor
extends Container {
    public static final boolean FORCE_AWT_COMPONENTS = true;
    public static final int INTERACTOR_HEIGHT = 22;
    private Component centralComponent;
    private Color background;
    private Color foreground;
    private Font font;

    public SwingInteractor() {
        this.setLayout(new BorderLayout());
    }

    protected void setContents(Component contents) {
        this.centralComponent = contents;
        this.background = contents.getBackground();
        this.foreground = contents.getForeground();
        this.font = contents.getFont();
        super.addImpl(contents, "Center", -1);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.centralComponent != null) {
            this.centralComponent.setEnabled(enabled);
            this.centralComponent.repaint();
        }
    }

    public void setForeground(Color fg) {
        this.foreground = fg;
        super.setForeground(fg);
        if (this.centralComponent != null) {
            this.centralComponent.setForeground(fg);
            this.centralComponent.repaint();
        }
    }

    public Color getForeground() {
        if (this.foreground == null) {
            Container parent = this.getParent();
            if (parent == null) {
                return null;
            }
            return parent.getForeground();
        }
        return this.foreground;
    }

    public void setBackground(Color bg) {
        this.background = bg;
        super.setBackground(bg);
        if (this.centralComponent != null) {
            this.centralComponent.setBackground(bg);
            this.centralComponent.repaint();
        }
    }

    public Color getBackground() {
        if (this.background == null) {
            Container parent = this.getParent();
            if (parent == null) {
                return null;
            }
            return parent.getBackground();
        }
        return this.background;
    }

    public void setFont(Font f) {
        this.font = JTFTools.getStandardFont(f);
        super.setFont(this.font);
        if (this.centralComponent != null) {
            this.centralComponent.setFont(this.font);
            this.centralComponent.repaint();
        }
    }

    public Font getFont() {
        if (this.font == null) {
            Container parent = this.getParent();
            if (parent == null) {
                return null;
            }
            return parent.getFont();
        }
        return this.font;
    }

    public void addMouseListener(MouseListener listener) {
        this.centralComponent.addMouseListener(new MouseForwarder(listener, this));
    }

    public void addMouseMotionListener(MouseMotionListener listener) {
        this.centralComponent.addMouseMotionListener(new MouseMotionForwarder(listener, this));
    }
}

