/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GImage;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import javax.imageio.ImageIO;

public class SimpleClient {
    private static final String ERROR_KEY = "Error:";

    public static GImage getImage(String host, String fileName) {
        try {
            if (!host.endsWith("/")) {
                host = String.valueOf(host) + "/";
            }
            URL url = new URL(String.valueOf(host) + "images/" + fileName);
            BufferedImage image = ImageIO.read(url);
            return new GImage((Image)image);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String saveImage(String host, String fileName) {
        if (!host.endsWith("/")) {
            host = String.valueOf(host) + "/";
        }
        try {
            byte[] bytes = Files.readAllBytes(Paths.get("images/" + fileName, new String[0]));
            String contents = Base64.getUrlEncoder().encodeToString(bytes);
            String params = "newImg";
            params = String.valueOf(params) + "?file=" + contents;
            params = String.valueOf(params) + "&fileName=" + fileName;
            URL destination = new URL(String.valueOf(host) + params);
            HttpURLConnection conn = (HttpURLConnection)destination.openConnection();
            conn.setRequestMethod("GET");
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            StringBuilder result = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            String fromServer = result.toString();
            rd.close();
            return fromServer;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String makeRequest(String host, Request request) throws IOException {
        if (!host.endsWith("/")) {
            host = String.valueOf(host) + "/";
        }
        try {
            StringBuilder result = new StringBuilder();
            URL destination = new URL(String.valueOf(host) + request.toGetRequest());
            HttpURLConnection conn = (HttpURLConnection)destination.openConnection();
            conn.setRequestMethod("GET");
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            String fromServer = result.toString();
            if (fromServer.startsWith(ERROR_KEY)) {
                String msg = fromServer.substring(ERROR_KEY.length());
                throw new IOException(msg.trim());
            }
            rd.close();
            return fromServer;
        }
        catch (ConnectException e) {
            throw new ConnectException("Unable to connect to the server. Did you start it?");
        }
    }
}

