/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acm.util.ErrorException;
import acmx.export.javax.swing.SimulatedTimer;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class Timer {
    private Class timerClass;
    private Object realTimer;
    private SimulatedTimer simulatedTimer;

    public Timer(int delay, ActionListener listener) {
        try {
            this.timerClass = Class.forName("java.swing.Timer");
            Class[] types = new Class[]{Integer.TYPE, Class.forName("java.awt.event.ActionListener")};
            Object[] args = new Object[]{new Integer(delay), listener};
            Constructor newTimer = this.timerClass.getConstructor(types);
            this.realTimer = newTimer.newInstance(args);
        }
        catch (Exception ex) {
            this.simulatedTimer = new SimulatedTimer(this);
            this.simulatedTimer.setDelay(delay);
            this.simulatedTimer.setInitialDelay(delay);
            this.simulatedTimer.addActionListener(listener);
        }
    }

    public void addActionListener(ActionListener listener) {
        if (this.realTimer == null) {
            this.simulatedTimer.addActionListener(listener);
        } else {
            try {
                Class[] types = new Class[]{Class.forName("java.awt.event.ActionListener")};
                Object[] args = new Object[]{listener};
                Method addActionListener = this.timerClass.getMethod("addActionListener", types);
                addActionListener.invoke(this.realTimer, args);
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
        }
    }

    public void removeActionListener(ActionListener listener) {
        if (this.realTimer == null) {
            this.simulatedTimer.removeActionListener(listener);
        } else {
            try {
                Class[] types = new Class[]{Class.forName("java.awt.event.ActionListener")};
                Object[] args = new Object[]{listener};
                Method removeActionListener = this.timerClass.getMethod("removeActionListener", types);
                removeActionListener.invoke(this.realTimer, args);
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
        }
    }

    public void setDelay(int delay) {
        if (this.realTimer == null) {
            this.simulatedTimer.setDelay(delay);
        } else {
            try {
                Class[] types = new Class[]{Integer.TYPE};
                Object[] args = new Object[]{new Integer(delay)};
                Method setDelay = this.timerClass.getMethod("setDelay", types);
                setDelay.invoke(this.realTimer, args);
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
        }
    }

    public int getDelay() {
        if (this.realTimer == null) {
            return this.simulatedTimer.getDelay();
        }
        try {
            Method getDelay = this.timerClass.getMethod("getDelay", new Class[0]);
            return (Integer)getDelay.invoke(this.realTimer, new Object[0]);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    public void setInitialDelay(int delay) {
        if (this.realTimer == null) {
            this.simulatedTimer.setInitialDelay(delay);
        } else {
            try {
                Class[] types = new Class[]{Integer.TYPE};
                Object[] args = new Object[]{new Integer(delay)};
                Method setInitialDelay = this.timerClass.getMethod("setInitialDelay", types);
                setInitialDelay.invoke(this.realTimer, args);
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
        }
    }

    public int getInitialDelay() {
        if (this.realTimer == null) {
            return this.simulatedTimer.getInitialDelay();
        }
        try {
            Method getInitialDelay = this.timerClass.getMethod("getInitialDelay", new Class[0]);
            return (Integer)getInitialDelay.invoke(this.realTimer, new Object[0]);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    public void setRepeats(boolean repeat) {
        if (this.realTimer == null) {
            this.simulatedTimer.setRepeats(repeat);
        } else {
            try {
                Class[] types = new Class[]{Boolean.TYPE};
                Object[] args = new Object[]{new Boolean(repeat)};
                Method setRepeats = this.timerClass.getMethod("setRepeats", types);
                setRepeats.invoke(this.realTimer, args);
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
        }
    }

    public boolean isRepeats() {
        if (this.realTimer == null) {
            return this.simulatedTimer.isRepeats();
        }
        try {
            Method isRepeats = this.timerClass.getMethod("isRepeats", new Class[0]);
            return (Boolean)isRepeats.invoke(this.realTimer, new Object[0]);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    public void start() {
        if (this.realTimer == null) {
            this.simulatedTimer.start();
        } else {
            try {
                Method start = this.timerClass.getMethod("start", new Class[0]);
                start.invoke(this.realTimer, new Object[0]);
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
        }
    }

    public boolean isRunning() {
        if (this.realTimer == null) {
            return this.simulatedTimer.isRunning();
        }
        try {
            Method isRunning = this.timerClass.getMethod("isRunning", new Class[0]);
            return (Boolean)isRunning.invoke(this.realTimer, new Object[0]);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    public void stop() {
        if (this.realTimer == null) {
            this.simulatedTimer.stop();
        } else {
            try {
                Method stop = this.timerClass.getMethod("stop", new Class[0]);
                stop.invoke(this.realTimer, new Object[0]);
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
        }
    }

    public void restart() {
        if (this.realTimer == null) {
            this.simulatedTimer.restart();
        } else {
            try {
                Method restart = this.timerClass.getMethod("restart", new Class[0]);
                restart.invoke(this.realTimer, new Object[0]);
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
        }
    }
}

