/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acm.util.JTFTools;
import acmx.export.javax.swing.JFileChooserModel;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;

class AWTFileChooser
implements JFileChooserModel {
    private File currentDirectory;
    private File selectedFile;
    private String dialogTitle;

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setDialogTitle(String title) {
        this.dialogTitle = title;
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public void setSelectedFile(File file) {
        this.selectedFile = file;
    }

    public void setFileSelectionMode(int mode) {
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File dir) {
        this.currentDirectory = dir;
    }

    public int showOpenDialog(Component parent) {
        return this.showFileDialog(parent, 0, this.dialogTitle == null ? "Load File" : this.dialogTitle);
    }

    public int showSaveDialog(Component parent) {
        return this.showFileDialog(parent, 1, this.dialogTitle == null ? "Save File" : this.dialogTitle);
    }

    private int showFileDialog(Component parent, int mode, String title) {
        Frame frame = JTFTools.getEnclosingFrame(parent);
        FileDialog dialog = new FileDialog(frame, title, mode);
        if (this.currentDirectory == null) {
            try {
                this.currentDirectory = new File(System.getProperty("user.dir"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.currentDirectory != null) {
            dialog.setDirectory(this.currentDirectory.getPath());
        }
        if (this.selectedFile != null) {
            dialog.setFile(this.selectedFile.getName());
        }
        dialog.setVisible(true);
        String filename = dialog.getFile();
        if (filename == null) {
            return 1;
        }
        this.selectedFile = new File(dialog.getDirectory(), filename);
        return 0;
    }
}

