/*
 * Decompiled with CFR 0.152.
 */
package acmx.classfile;

import acmx.classfile.ConstantPoolEntry;
import acmx.classfile.JavaClass;
import acmx.classfile.NameAndTypeEntry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class RefEntry
extends ConstantPoolEntry {
    private int classIndex;
    private int ntIndex;

    protected RefEntry(DataInputStream in, int type, JavaClass jc) throws IOException {
        super(type, jc);
        this.classIndex = in.readShort();
        this.ntIndex = in.readShort();
    }

    protected RefEntry(int classID, int nameAndTypeID, int type, JavaClass jc) {
        super(type, jc);
        this.classIndex = classID;
        this.ntIndex = nameAndTypeID;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public int getNameAndTypeIndex() {
        return this.ntIndex;
    }

    public void setNameAndTypeIndex(int index) {
        this.ntIndex = index;
    }

    public void write(DataOutputStream out) throws IOException {
        out.write(this.getEntryType());
        out.writeShort(this.classIndex);
        out.writeShort(this.ntIndex);
    }

    public String toString() {
        String typeName = RefEntry.getTypeName(this.getEntryType());
        JavaClass jc = this.getOwner();
        NameAndTypeEntry ntEntry = (NameAndTypeEntry)jc.getConstantPoolEntry(this.ntIndex);
        String refName = ntEntry.getName();
        String refType = ntEntry.getDescriptor();
        return "[" + typeName + ":" + JavaClass.nameAndTypeToString(refName, refType) + "]";
    }
}

