/*
 * Decompiled with CFR 0.152.
 */
package acmx.classfile;

import acmx.classfile.ConstantPoolEntry;
import acmx.classfile.JavaClass;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class NameAndTypeEntry
extends ConstantPoolEntry {
    private int nameIndex;
    private int descriptorIndex;

    protected NameAndTypeEntry(DataInputStream in, JavaClass jc) throws IOException {
        super(12, jc);
        this.nameIndex = in.readShort();
        this.descriptorIndex = in.readShort();
    }

    protected NameAndTypeEntry(int nameID, int descriptorID, JavaClass jc) {
        super(12, jc);
        this.nameIndex = nameID;
        this.descriptorIndex = descriptorID;
    }

    public String getName() {
        return this.getOwner().getUTF8Name(this.nameIndex);
    }

    public void setName(String name) {
        this.nameIndex = this.getOwner().createUTF8Entry(name);
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public String getDescriptor() {
        return this.getOwner().getUTF8Name(this.descriptorIndex);
    }

    public void setTypeDescriptor(String name) {
        this.descriptorIndex = this.getOwner().createUTF8Entry(name);
    }

    public void write(DataOutputStream out) throws IOException {
        out.write(this.getEntryType());
        out.writeShort(this.nameIndex);
        out.writeShort(this.descriptorIndex);
    }

    public String toString() {
        return "[NameAndType:" + JavaClass.nameAndTypeToString(this.getName(), this.getDescriptor()) + "]";
    }
}

