/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.java.util;

import acm.util.ErrorException;
import acmx.export.java.util.Comparator;
import acmx.export.java.util.List;
import java.lang.reflect.Method;

public final class Collections {
    public static final int binarySearch(List list, Object key) {
        return Collections.binarySearch(list, key, null);
    }

    public static final int binarySearch(List list, Object key, Comparator comparator) {
        int lh = 0;
        int rh = list.size() - 1;
        while (lh <= rh) {
            int mid = (lh + rh) / 2;
            int cmp = Collections.compare(key, list.get(mid), comparator);
            if (cmp == 0) {
                return mid;
            }
            if (cmp < 0) {
                rh = mid - 1;
                continue;
            }
            lh = mid + 1;
        }
        return -1;
    }

    public static final void sort(List list) {
        Collections.sort(list, null);
    }

    public static final void sort(List list, Comparator comparator) {
        int lh = 0;
        while (lh < list.size()) {
            int rh = lh;
            Object smallestValue = list.get(rh);
            int i = lh + 1;
            while (i < list.size()) {
                int cmp = Collections.compare(smallestValue, list.get(i), comparator);
                if (cmp > 0) {
                    rh = i;
                    smallestValue = list.get(i);
                }
                ++i;
            }
            Object temp = list.get(lh);
            list.set(lh, list.get(rh));
            list.set(rh, temp);
            ++lh;
        }
    }

    public static final Object min(List list) {
        return Collections.min(list, null);
    }

    public static final Object min(List list, Comparator comparator) {
        Object smallestValue = list.get(0);
        int i = 1;
        while (i < list.size()) {
            int cmp = Collections.compare(smallestValue, list.get(i), comparator);
            if (cmp > 0) {
                smallestValue = list.get(i);
            }
            ++i;
        }
        return smallestValue;
    }

    public static final Object max(List list) {
        return Collections.max(list, null);
    }

    public static final Object max(List list, Comparator comparator) {
        Object largestValue = list.get(0);
        int i = 1;
        while (i < list.size()) {
            int cmp = Collections.compare(largestValue, list.get(i), comparator);
            if (cmp < 0) {
                largestValue = list.get(i);
            }
            ++i;
        }
        return largestValue;
    }

    public static final void reverse(List list) {
        int lh = 0;
        while (lh < list.size() / 2) {
            int rh = list.size() - lh - 1;
            Object temp = list.get(lh);
            list.set(lh, list.get(rh));
            list.set(rh, temp);
            ++lh;
        }
    }

    public static final void shuffle(List list) {
        int lh = 0;
        while (lh < list.size()) {
            int rh = lh + (int)((double)(list.size() - lh) * Math.random());
            Object temp = list.get(lh);
            list.set(lh, list.get(rh));
            list.set(rh, temp);
            ++lh;
        }
    }

    public static final void swap(List list, int lh, int rh) {
        Object temp = list.get(lh);
        list.set(lh, list.get(rh));
        list.set(rh, temp);
    }

    public static final void rotate(List list, int n) {
        throw new ErrorException("Not yet implemented");
    }

    public static final boolean replaceAll(List list, Object oldValue, Object newValue) {
        boolean result = false;
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) == null ? oldValue == null : list.get(i).equals(oldValue)) {
                list.set(i, newValue);
                result = true;
            }
            ++i;
        }
        return result;
    }

    private static int compare(Object x, Object y, Comparator comparator) {
        if (comparator != null) {
            return comparator.compare(x, y);
        }
        if (x instanceof String) {
            return ((String)x).compareTo((String)y);
        }
        try {
            Class<?> baseType = x.getClass();
            Class[] types = new Class[]{Class.forName("java.lang.Object")};
            Object[] args = new Object[]{y};
            Method compareTo = baseType.getMethod("compareTo", types);
            return (Integer)compareTo.invoke(x, args);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }
}

