/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acm.util.ErrorException;
import acmx.export.javax.swing.JScrollBarModel;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

class AWTScrollBar
extends Component
implements JScrollBarModel,
MouseListener,
MouseMotionListener,
Runnable,
Adjustable {
    protected static final int HORIZONTAL = 0;
    protected static final int VERTICAL = 1;
    protected static final int UNIT_INCREMENT = 1;
    protected static final int BLOCK_INCREMENT = 4;
    protected static final int UNIT_DECREMENT = 2;
    protected static final int BLOCK_DECREMENT = 3;
    protected static final int TRACK = 5;
    private static final Color END_BACKGROUND = new Color(0xD0D0D0);
    private static final Color END_HIGHLIGHT = Color.WHITE;
    private static final Color END_SHADOW = new Color(0xB0B0B0);
    private static final Color BAR_BACKGROUND = new Color(0xA0A0A0);
    private static final Color BAR_HIGHLIGHT = new Color(0xB0B0B0);
    private static final Color BAR_SHADOW = new Color(0x808080);
    private static final Color DEFAULT_SLIDER = new Color(0x8080FF);
    private static final int NORTH = 0;
    private static final int EAST = 1;
    private static final int SOUTH = 2;
    private static final int WEST = 3;
    private static final int INITIAL_SCROLL_DELAY = 300;
    private static final int SCROLL_DELAY = 34;
    private static final int DEFAULT_BREADTH = 14;
    private static final int MINIMUM_LENGTH = 42;
    private ArrayList<AdjustmentListener> adjustmentListeners;
    private Color sliderColor;
    private int myOrientation;
    private int myValue;
    private int visibleAmount;
    private int minimum;
    private int maximum;
    private int unitIncrement;
    private int blockIncrement;
    private int currentAction;
    private int cx;
    private int cy;
    private int dragOffset;
    private boolean draggingSlider;
    private Thread scrollerThread;

    public AWTScrollBar(int orientation) {
        this.myOrientation = orientation;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.adjustmentListeners = new ArrayList();
        this.sliderColor = DEFAULT_SLIDER;
        this.unitIncrement = 1;
        this.blockIncrement = 10;
    }

    public int getOrientation() {
        return this.myOrientation;
    }

    public void setMinimum(int min) {
        this.minimum = min;
        this.repaint();
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMaximum(int max) {
        this.maximum = max;
        this.repaint();
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setVisibleAmount(int extent) {
        this.visibleAmount = extent;
        this.repaint();
    }

    public int getVisibleAmount() {
        return this.visibleAmount;
    }

    public void setValue(int value) {
        this.myValue = value;
        this.repaint();
    }

    public int getValue() {
        return this.myValue;
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public void setUnitIncrement(int value) {
        this.unitIncrement = value;
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public void setBlockIncrement(int value) {
        this.blockIncrement = value;
    }

    public void run() {
        try {
            Thread.sleep(300L);
            while (this.currentAction == this.classifyScrollAction(this.cx, this.cy)) {
                this.applyScrollAction(this.currentAction, 0);
                Thread.sleep(34L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void addAdjustmentListener(AdjustmentListener listener) {
        this.adjustmentListeners.add(listener);
    }

    public void removeAdjustmentListener(AdjustmentListener listener) {
        this.adjustmentListeners.remove(listener);
    }

    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.currentAction = this.classifyScrollAction(e.getX(), e.getY());
        if (this.currentAction == 0) {
            return;
        }
        this.cx = e.getX();
        this.cy = e.getY();
        if (this.currentAction == 5) {
            this.draggingSlider = true;
            this.dragOffset = this.computeDragOffset(this.cx, this.cy);
        } else {
            this.applyScrollAction(this.currentAction, 0);
            this.scrollerThread = new Thread(this);
            this.scrollerThread.start();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.currentAction = -1;
        this.draggingSlider = false;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.draggingSlider) {
            this.applyScrollAction(5, this.computeDragValue(e.getX(), e.getY()));
        } else {
            this.cx = e.getX();
            this.cy = e.getY();
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        switch (this.myOrientation) {
            case 0: {
                return new Dimension(42, 14);
            }
            case 1: {
                return new Dimension(14, 42);
            }
        }
        throw new ErrorException("Illegal orientation");
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        int width = size.width;
        int height = size.height;
        switch (this.myOrientation) {
            case 0: {
                this.drawScrollbarBody(g, height + 1, 0, width - 2 * height - 1, height);
                this.drawEndControl(g, -1, -1, height + 2, 3);
                this.drawEndControl(g, width - height - 1, -1, height + 2, 1);
                break;
            }
            case 1: {
                this.drawScrollbarBody(g, 0, width + 1, width, height - 2 * width - 1);
                this.drawEndControl(g, -1, -1, width + 2, 0);
                this.drawEndControl(g, -1, height - width - 1, width + 2, 2);
            }
        }
        g.setColor(Color.BLACK);
        this.drawOuterBorder(g);
    }

    protected void fireAdjustmentListeners(AdjustmentEvent e) {
        int nListeners = this.adjustmentListeners.size();
        int i = 0;
        while (i < nListeners) {
            this.adjustmentListeners.get(i).adjustmentValueChanged(e);
            ++i;
        }
    }

    protected int classifyScrollAction(int x, int y) {
        int pos = 0;
        int length = 0;
        int breadth = 0;
        if (this.myOrientation == 0) {
            pos = x;
            length = this.getSize().width;
            breadth = this.getSize().height;
        } else {
            pos = y;
            length = this.getSize().height;
            breadth = this.getSize().width;
        }
        double fraction = (double)(this.myValue - this.minimum) / (double)(this.maximum - this.minimum);
        int p = (int)(fraction * (double)(length - 3 * breadth) + 0.5);
        if (pos >= 0 && pos <= breadth) {
            return 2;
        }
        if (pos > breadth && pos <= p + breadth) {
            return 3;
        }
        if (pos > p + breadth && pos <= p + 2 * breadth) {
            return 5;
        }
        if (pos > p + 2 * breadth && pos <= length - breadth) {
            return 4;
        }
        if (pos > length - breadth && pos < length) {
            return 1;
        }
        return 0;
    }

    private void applyScrollAction(int actionType, int newValue) {
        switch (actionType) {
            case 2: {
                newValue = this.myValue - this.unitIncrement;
                break;
            }
            case 3: {
                newValue = this.myValue - this.blockIncrement;
                break;
            }
            case 1: {
                newValue = this.myValue + this.unitIncrement;
                break;
            }
            case 4: {
                newValue = this.myValue + this.blockIncrement;
                break;
            }
            case 5: {
                break;
            }
            default: {
                return;
            }
        }
        newValue = Math.min(Math.max(newValue, this.minimum), this.maximum);
        if (this.getValue() != newValue) {
            this.myValue = newValue;
            this.repaint();
            AWTScrollBar source = this.getParent() instanceof Adjustable ? (Adjustable)((Object)this.getParent()) : this;
            this.fireAdjustmentListeners(new AdjustmentEvent(source, 601, actionType, newValue));
        }
    }

    protected int getDragOffset() {
        return this.dragOffset;
    }

    protected int computeDragOffset(int x, int y) {
        int pos = 0;
        int length = 0;
        int breadth = 0;
        if (this.myOrientation == 0) {
            pos = x;
            length = this.getSize().width;
            breadth = this.getSize().height;
        } else {
            pos = y;
            length = this.getSize().height;
            breadth = this.getSize().width;
        }
        double fraction = (double)(this.myValue - this.minimum) / (double)(this.maximum - this.minimum);
        int p = (int)(fraction * (double)(length - 3 * breadth) + 0.5);
        return pos - p;
    }

    protected int computeDragValue(int x, int y) {
        int pos = 0;
        int length = 0;
        int breadth = 0;
        if (this.myOrientation == 0) {
            pos = x;
            length = this.getSize().width;
            breadth = this.getSize().height;
        } else {
            pos = y;
            length = this.getSize().height;
            breadth = this.getSize().width;
        }
        int myValue = this.minimum + (int)((double)((pos - this.dragOffset) * (this.maximum - this.minimum) / (length - 3 * breadth)) + 0.5);
        return Math.min(Math.max(myValue, this.minimum), this.maximum);
    }

    protected void drawOuterBorder(Graphics g) {
        Dimension size = this.getSize();
        g.drawRect(0, 0, size.width - 1, size.height - 1);
    }

    protected void drawEndControl(Graphics g, int x, int y, int size, int dir) {
        g.setColor(END_BACKGROUND);
        g.fillRect(x + 1, y + 1, size - 2, size - 2);
        g.setColor(Color.BLACK);
        g.drawRect(x, y, size - 1, size - 1);
        g.setColor(this.isEnabled() ? Color.BLACK : Color.GRAY);
        int x0 = 0;
        int y0 = 0;
        int x1 = 0;
        int y1 = 0;
        int i = 0;
        while (i < size / 4) {
            switch (dir) {
                case 0: {
                    x0 = x + size / 2 - i - 1;
                    y0 = y + 3 * size / 8 + i;
                    x1 = x0 + 2 * i;
                    y1 = y0;
                    break;
                }
                case 2: {
                    x0 = x + size / 2 - i - 1;
                    y0 = y + 5 * size / 8 - i - 1;
                    x1 = x0 + 2 * i;
                    y1 = y0;
                    break;
                }
                case 3: {
                    x0 = x + 3 * size / 8 + i;
                    y0 = y + size / 2 - i - 1;
                    x1 = x0;
                    y1 = y0 + 2 * i;
                    break;
                }
                case 1: {
                    x0 = x + 5 * size / 8 - i - 1;
                    y0 = y + size / 2 - i - 1;
                    x1 = x0;
                    y1 = y0 + 2 * i;
                    break;
                }
                default: {
                    throw new ErrorException("Illegal direction");
                }
            }
            g.drawLine(x0, y0, x1, y1);
            ++i;
        }
        g.setColor(END_HIGHLIGHT);
        g.drawLine(x + 1, y + size - 3, x + 1, y + 1);
        g.drawLine(x + 1, y + 1, x + size - 3, y + 1);
        g.setColor(END_SHADOW);
        g.drawLine(x + 2, y + size - 2, x + size - 2, y + size - 2);
        g.drawLine(x + size - 2, y + size - 2, x + size - 2, y + 2);
    }

    protected void drawScrollbarBody(Graphics g, int x, int y, int width, int height) {
        g.setColor(BAR_BACKGROUND);
        g.fillRect(x, y, width, height);
        g.setColor(BAR_SHADOW);
        g.drawLine(x, y + height - 2, x, y);
        g.drawLine(x, y, x + width - 1, y);
        g.drawLine(x + 1, y + height - 3, x + 1, y + 1);
        g.drawLine(x + 1, y + 1, x + width - 1, y + 1);
        g.setColor(BAR_HIGHLIGHT);
        g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y + height - 1, x + width - 1, y + 3);
        g.drawLine(x + 1, y + height - 2, x + width - 2, y + height - 2);
        g.drawLine(x + width - 2, y + height - 2, x + width - 2, y + 3);
        if (this.sliderColor == null) {
            return;
        }
        double fraction = 0.0;
        int p = 0;
        switch (this.myOrientation) {
            case 0: {
                if (width <= height) {
                    return;
                }
                fraction = (double)(this.myValue - this.minimum) / (double)(this.maximum - this.minimum);
                p = (int)(fraction * (double)(width - height) + 0.5);
                this.drawSlider(g, x + p, y, height, x + width, this.sliderColor);
                break;
            }
            case 1: {
                if (height <= width) {
                    return;
                }
                fraction = (double)(this.myValue - this.minimum) / (double)(this.maximum - this.minimum);
                p = (int)(fraction * (double)(height - width) + 0.5);
                this.drawSlider(g, x, y + p, width, y + height, this.sliderColor);
            }
        }
    }

    protected void drawSlider(Graphics g, int x, int y, int size, int max, Color color) {
        g.setColor(color);
        g.fillRect(x, y, size, size);
        g.setColor(color.brighter());
        g.drawLine(x, y + size - 2, x, y);
        g.drawLine(x, y, x + size - 2, y);
        g.setColor(color.darker());
        g.drawLine(x + 1, y + size - 1, x + size - 1, y + size - 1);
        g.drawLine(x + size - 1, y + size - 1, x + size - 1, y + 1);
        g.setColor(Color.BLACK);
        switch (this.myOrientation) {
            case 0: {
                g.drawLine(x - 1, y, x - 1, y + size);
                g.drawLine(x + size, y, x + size, y + size);
                break;
            }
            case 1: {
                g.drawLine(x, y - 1, x + size, y - 1);
                g.drawLine(x, y + size, x + size, y + size);
            }
        }
        g.setColor(BAR_SHADOW);
        switch (this.myOrientation) {
            case 0: {
                if (x + size + 1 >= max) break;
                g.drawLine(x + size + 1, y, x + size + 1, y + size - 1);
                if (x + size + 2 >= max) break;
                g.drawLine(x + size + 2, y, x + size + 2, y + size - 2);
                break;
            }
            case 1: {
                if (y + size + 1 >= max) break;
                g.drawLine(x, y + size + 1, x + size - 1, y + size + 1);
                if (y + size + 2 >= max) break;
                g.drawLine(x, y + size + 2, x + size - 2, y + size + 2);
            }
        }
        if (this.isEnabled()) {
            this.drawThumbControl(g, x, y, size, color);
        }
    }

    protected void drawThumbControl(Graphics g, int x, int y, int size, Color color) {
        int x0 = x + size / 2 - 4;
        int y0 = y + size / 2 - 4;
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        int i = 0;
        while (i < 8) {
            if (this.myOrientation == 0) {
                x1 = x0 + i;
                y1 = i % 2 == 0 ? y0 : y0 + 1;
                x2 = x1;
                y2 = y1 + 6;
            } else {
                x1 = i % 2 == 0 ? x0 : x0 + 1;
                y1 = y0 + i;
                x2 = x1 + 6;
                y2 = y1;
            }
            g.setColor(i % 2 == 0 ? color.brighter() : color.darker());
            g.drawLine(x1, y1, x2, y2);
            ++i;
        }
    }
}

