/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acm.util.JTFTools;
import acmx.export.javax.swing.ButtonGroup;
import acmx.export.javax.swing.JApplet;
import acmx.export.javax.swing.JRadioButton;
import acmx.export.javax.swing.JRadioButtonModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

class AWTRadioButton
extends Component
implements JRadioButtonModel,
MouseListener,
MouseMotionListener {
    private static final int MARGIN = 4;
    private static final int MIN_WIDTH = 24;
    private static final int MIN_HEIGHT = 22;
    private static final Color BGCOLOR = JApplet.BGCOLOR;
    private static final Color ENABLED_BORDER_COLOR = new Color(0x666666);
    private static final Color DISABLED_BORDER_COLOR = new Color(0x999999);
    private static final Color DISABLED_TEXT_COLOR = new Color(0x666666);
    private static final Color ENABLED_INTERIOR_COLOR = Color.WHITE;
    private static final Color DISABLED_INTERIOR_COLOR = new Color(0xCCCCCC);
    private static final Font FONT = new Font("SansSerif", 1, 10);
    private ArrayList<ActionListener> actionListeners;
    private String label;
    private String actionCommand;
    private Color oldBackground;
    private boolean inside;
    private boolean selected;
    private ButtonGroup buttonGroup;
    private JRadioButton parent;

    public AWTRadioButton(JRadioButton button) {
        this.setBackground(BGCOLOR);
        this.setFont(JTFTools.getStandardFont(FONT));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.actionListeners = new ArrayList();
        this.parent = button;
    }

    public void setText(String text) {
        this.label = text;
        this.repaint();
    }

    public String getText() {
        return this.label;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean state) {
        JRadioButton button;
        this.selected = state;
        if (this.buttonGroup != null && state && (button = (JRadioButton)this.buttonGroup.getSelection()) != this.parent) {
            if (button != null) {
                button.setSelected(false);
            }
            this.buttonGroup.setSelectedCallback(this.parent);
        }
        this.repaint();
    }

    public void setButtonGroup(ButtonGroup group) {
        this.buttonGroup = group;
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    public void fireActionListeners(ActionEvent e) {
        int nListeners = this.actionListeners.size();
        int i = 0;
        while (i < nListeners) {
            this.actionListeners.get(i).actionPerformed(e);
            ++i;
        }
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int boxSize = fm.getHeight();
        int width = Math.max(fm.stringWidth(this.label) + 8 + boxSize, 24);
        int height = Math.max(fm.getHeight() + 2, 22);
        return new Dimension(width, height);
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int x = 0;
        int y = (size.height + fm.getAscent()) / 2 - 2;
        int boxSize = fm.getHeight();
        g.setColor(this.isEnabled() ? ENABLED_INTERIOR_COLOR : DISABLED_INTERIOR_COLOR);
        g.fillOval(x, y - boxSize + 2, boxSize, boxSize);
        if (this.isSelected()) {
            g.setColor(this.isEnabled() ? this.getForeground() : DISABLED_BORDER_COLOR);
            int cx = x + boxSize / 2;
            int cy = y - boxSize / 2 + 2;
            g.fillOval(cx - 1, cy - 2, 4, 4);
        }
        g.setColor(this.isEnabled() ? ENABLED_BORDER_COLOR : DISABLED_BORDER_COLOR);
        g.drawOval(x, y - boxSize + 2, boxSize, boxSize);
        g.setColor(this.isEnabled() ? this.getForeground() : DISABLED_TEXT_COLOR);
        g.drawString(this.label, x += boxSize + 3, y);
    }

    public void mousePressed(MouseEvent e) {
        this.oldBackground = this.getBackground();
        this.setBackground(this.oldBackground.darker());
        this.repaint();
        this.inside = true;
    }

    public void mouseReleased(MouseEvent e) {
        this.setBackground(this.oldBackground);
        this.repaint();
        if (this.contains(e.getPoint())) {
            String command = this.actionCommand;
            if (command == null) {
                command = this.label;
            }
            this.setSelected(!this.selected);
            this.fireActionListeners(new ActionEvent(e.getSource(), 1001, command, e.getModifiers()));
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.inside != this.contains(e.getPoint())) {
            boolean bl = this.inside = !this.inside;
            if (this.inside) {
                this.mousePressed(e);
            } else {
                this.mouseReleased(e);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }
}

