/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acm.util.JTFTools;
import acmx.export.javax.swing.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

class SimulatedTimer
implements Runnable {
    private ArrayList<ActionListener> actionListeners = new ArrayList();
    private boolean running = false;
    private boolean repeatFlag = true;
    private int standardDelay;
    private int initialDelay;
    private Timer parent;
    private Thread timerThread;

    public SimulatedTimer(Timer timer) {
        this.parent = timer;
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    public void setDelay(int delay) {
        this.standardDelay = delay;
    }

    public int getDelay() {
        return this.standardDelay;
    }

    public void setInitialDelay(int delay) {
        this.initialDelay = delay;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setRepeats(boolean repeat) {
        this.repeatFlag = repeat;
    }

    public boolean isRepeats() {
        return this.repeatFlag;
    }

    public void start() {
        if (!this.running) {
            this.running = true;
            this.timerThread = new Thread(this);
            this.timerThread.start();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() {
        this.running = false;
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public void run() {
        JTFTools.pause(this.initialDelay);
        while (this.running) {
            this.fireActionListeners(new ActionEvent(this.parent, 1001, ""));
            JTFTools.pause(this.standardDelay);
            this.running &= this.repeatFlag;
        }
    }

    private void fireActionListeners(ActionEvent e) {
        int nListeners = this.actionListeners.size();
        int i = 0;
        while (i < nListeners) {
            ActionListener listener = this.actionListeners.get(i);
            listener.actionPerformed(e);
            ++i;
        }
    }
}

