/*
 * Decompiled with CFR 0.152.
 */
package acmx.classfile;

import acm.util.ErrorException;
import acmx.classfile.Attribute;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class JVMOperation {
    public static final int JVM_nop = 0;
    public static final int JVM_aconst_null = 1;
    public static final int JVM_iconst_m1 = 2;
    public static final int JVM_iconst_0 = 3;
    public static final int JVM_iconst_1 = 4;
    public static final int JVM_iconst_2 = 5;
    public static final int JVM_iconst_3 = 6;
    public static final int JVM_iconst_4 = 7;
    public static final int JVM_iconst_5 = 8;
    public static final int JVM_lconst_0 = 9;
    public static final int JVM_lconst_1 = 10;
    public static final int JVM_fconst_0 = 11;
    public static final int JVM_fconst_1 = 12;
    public static final int JVM_fconst_2 = 13;
    public static final int JVM_dconst_0 = 14;
    public static final int JVM_dconst_1 = 15;
    public static final int JVM_bipush = 16;
    public static final int JVM_sipush = 17;
    public static final int JVM_ldc = 18;
    public static final int JVM_ldc_w = 19;
    public static final int JVM_ldc2_w = 20;
    public static final int JVM_iload = 21;
    public static final int JVM_lload = 22;
    public static final int JVM_fload = 23;
    public static final int JVM_dload = 24;
    public static final int JVM_aload = 25;
    public static final int JVM_iload_0 = 26;
    public static final int JVM_iload_1 = 27;
    public static final int JVM_iload_2 = 28;
    public static final int JVM_iload_3 = 29;
    public static final int JVM_lload_0 = 30;
    public static final int JVM_lload_1 = 31;
    public static final int JVM_lload_2 = 32;
    public static final int JVM_lload_3 = 33;
    public static final int JVM_fload_0 = 34;
    public static final int JVM_fload_1 = 35;
    public static final int JVM_fload_2 = 36;
    public static final int JVM_fload_3 = 37;
    public static final int JVM_dload_0 = 38;
    public static final int JVM_dload_1 = 39;
    public static final int JVM_dload_2 = 40;
    public static final int JVM_dload_3 = 41;
    public static final int JVM_aload_0 = 42;
    public static final int JVM_aload_1 = 43;
    public static final int JVM_aload_2 = 44;
    public static final int JVM_aload_3 = 45;
    public static final int JVM_iaload = 46;
    public static final int JVM_laload = 47;
    public static final int JVM_faload = 48;
    public static final int JVM_daload = 49;
    public static final int JVM_aaload = 50;
    public static final int JVM_baload = 51;
    public static final int JVM_caload = 52;
    public static final int JVM_saload = 53;
    public static final int JVM_istore = 54;
    public static final int JVM_lstore = 55;
    public static final int JVM_fstore = 56;
    public static final int JVM_dstore = 57;
    public static final int JVM_astore = 58;
    public static final int JVM_istore_0 = 59;
    public static final int JVM_istore_1 = 60;
    public static final int JVM_istore_2 = 61;
    public static final int JVM_istore_3 = 62;
    public static final int JVM_lstore_0 = 63;
    public static final int JVM_lstore_1 = 64;
    public static final int JVM_lstore_2 = 65;
    public static final int JVM_lstore_3 = 66;
    public static final int JVM_fstore_0 = 67;
    public static final int JVM_fstore_1 = 68;
    public static final int JVM_fstore_2 = 69;
    public static final int JVM_fstore_3 = 70;
    public static final int JVM_dstore_0 = 71;
    public static final int JVM_dstore_1 = 72;
    public static final int JVM_dstore_2 = 73;
    public static final int JVM_dstore_3 = 74;
    public static final int JVM_astore_0 = 75;
    public static final int JVM_astore_1 = 76;
    public static final int JVM_astore_2 = 77;
    public static final int JVM_astore_3 = 78;
    public static final int JVM_iastore = 79;
    public static final int JVM_lastore = 80;
    public static final int JVM_fastore = 81;
    public static final int JVM_dastore = 82;
    public static final int JVM_aastore = 83;
    public static final int JVM_bastore = 84;
    public static final int JVM_castore = 85;
    public static final int JVM_sastore = 86;
    public static final int JVM_pop = 87;
    public static final int JVM_pop2 = 88;
    public static final int JVM_dup = 89;
    public static final int JVM_dup_x1 = 90;
    public static final int JVM_dup_x2 = 91;
    public static final int JVM_dup2 = 92;
    public static final int JVM_dup2_x1 = 93;
    public static final int JVM_dup2_x2 = 94;
    public static final int JVM_swap = 95;
    public static final int JVM_iadd = 96;
    public static final int JVM_ladd = 97;
    public static final int JVM_fadd = 98;
    public static final int JVM_dadd = 99;
    public static final int JVM_isub = 100;
    public static final int JVM_lsub = 101;
    public static final int JVM_fsub = 102;
    public static final int JVM_dsub = 103;
    public static final int JVM_imul = 104;
    public static final int JVM_lmul = 105;
    public static final int JVM_fmul = 106;
    public static final int JVM_dmul = 107;
    public static final int JVM_idiv = 108;
    public static final int JVM_ldiv = 109;
    public static final int JVM_fdiv = 110;
    public static final int JVM_ddiv = 111;
    public static final int JVM_irem = 112;
    public static final int JVM_lrem = 113;
    public static final int JVM_frem = 114;
    public static final int JVM_drem = 115;
    public static final int JVM_ineg = 116;
    public static final int JVM_lneg = 117;
    public static final int JVM_fneg = 118;
    public static final int JVM_dneg = 119;
    public static final int JVM_ishl = 120;
    public static final int JVM_lshl = 121;
    public static final int JVM_ishr = 122;
    public static final int JVM_lshr = 123;
    public static final int JVM_iushr = 124;
    public static final int JVM_lushr = 125;
    public static final int JVM_iand = 126;
    public static final int JVM_land = 127;
    public static final int JVM_ior = 128;
    public static final int JVM_lor = 129;
    public static final int JVM_ixor = 130;
    public static final int JVM_lxor = 131;
    public static final int JVM_iinc = 132;
    public static final int JVM_i2l = 133;
    public static final int JVM_i2f = 134;
    public static final int JVM_i2d = 135;
    public static final int JVM_l2i = 136;
    public static final int JVM_l2f = 137;
    public static final int JVM_l2d = 138;
    public static final int JVM_f2i = 139;
    public static final int JVM_f2l = 140;
    public static final int JVM_f2d = 141;
    public static final int JVM_d2i = 142;
    public static final int JVM_d2l = 143;
    public static final int JVM_d2f = 144;
    public static final int JVM_i2b = 145;
    public static final int JVM_i2c = 146;
    public static final int JVM_i2s = 147;
    public static final int JVM_lcmp = 148;
    public static final int JVM_fcmpl = 149;
    public static final int JVM_fcmpg = 150;
    public static final int JVM_dcmpl = 151;
    public static final int JVM_dcmpg = 152;
    public static final int JVM_ifeq = 153;
    public static final int JVM_ifne = 154;
    public static final int JVM_iflt = 155;
    public static final int JVM_ifge = 156;
    public static final int JVM_ifgt = 157;
    public static final int JVM_ifle = 158;
    public static final int JVM_if_icmpeq = 159;
    public static final int JVM_if_icmpne = 160;
    public static final int JVM_if_icmplt = 161;
    public static final int JVM_if_icmpge = 162;
    public static final int JVM_if_icmpgt = 163;
    public static final int JVM_if_icmple = 164;
    public static final int JVM_if_acmpeq = 165;
    public static final int JVM_if_acmpne = 166;
    public static final int JVM_goto = 167;
    public static final int JVM_jsr = 168;
    public static final int JVM_ret = 169;
    public static final int JVM_tableswitch = 170;
    public static final int JVM_lookupswitch = 171;
    public static final int JVM_ireturn = 172;
    public static final int JVM_lreturn = 173;
    public static final int JVM_freturn = 174;
    public static final int JVM_dreturn = 175;
    public static final int JVM_areturn = 176;
    public static final int JVM_return = 177;
    public static final int JVM_getstatic = 178;
    public static final int JVM_putstatic = 179;
    public static final int JVM_getfield = 180;
    public static final int JVM_putfield = 181;
    public static final int JVM_invokevirtual = 182;
    public static final int JVM_invokespecial = 183;
    public static final int JVM_invokestatic = 184;
    public static final int JVM_invokeinterface = 185;
    public static final int JVM_new = 187;
    public static final int JVM_newarray = 188;
    public static final int JVM_anewarray = 189;
    public static final int JVM_arraylength = 190;
    public static final int JVM_athrow = 191;
    public static final int JVM_checkcast = 192;
    public static final int JVM_instanceof = 193;
    public static final int JVM_monitorenter = 194;
    public static final int JVM_monitorexit = 195;
    public static final int JVM_wide = 196;
    public static final int JVM_multianewarray = 197;
    public static final int JVM_ifnull = 198;
    public static final int JVM_ifnonnull = 199;
    public static final int JVM_goto_w = 200;
    public static final int JVM_jsr_w = 201;
    public static final int JVM_breakpoint = 202;
    public static final int JVM_impdep1 = 254;
    public static final int JVM_impdep2 = 255;
    private static final int X = -1;
    private static final String[] OPCODE_NAMES = new String[]{"nop", "aconst_null", "iconst_m1", "iconst_0", "iconst_1", "iconst_2", "iconst_3", "iconst_4", "iconst_5", "lconst_0", "lconst_1", "fconst_0", "fconst_1", "fconst_2", "dconst_0", "dconst_1", "bipush", "sipush", "ldc", "ldc_w", "ldc2_w", "iload", "lload", "fload", "dload", "aload", "iload_0", "iload_1", "iload_2", "iload_3", "lload_0", "lload_1", "lload_2", "lload_3", "fload_0", "fload_1", "fload_2", "fload_3", "dload_0", "dload_1", "dload_2", "dload_3", "aload_0", "aload_1", "aload_2", "aload_3", "iaload", "laload", "faload", "daload", "aaload", "baload", "caload", "saload", "istore", "lstore", "fstore", "dstore", "astore", "istore_0", "istore_1", "istore_2", "istore_3", "lstore_0", "lstore_1", "lstore_2", "lstore_3", "fstore_0", "fstore_1", "fstore_2", "fstore_3", "dstore_0", "dstore_1", "dstore_2", "dstore_3", "astore_0", "astore_1", "astore_2", "astore_3", "iastore", "lastore", "fastore", "dastore", "aastore", "bastore", "castore", "sastore", "pop", "pop2", "dup", "dup_x1", "dup_x2", "dup2", "dup2_x1", "dup2_x2", "swap", "iadd", "ladd", "fadd", "dadd", "isub", "lsub", "fsub", "dsub", "imul", "lmul", "fmul", "dmul", "idiv", "ldiv", "fdiv", "ddiv", "irem", "lrem", "frem", "drem", "ineg", "lneg", "fneg", "dneg", "ishl", "lshl", "ishr", "lshr", "iushr", "lushr", "iand", "land", "ior", "lor", "ixor", "lxor", "iinc", "i2l", "i2f", "i2d", "l2i", "l2f", "l2d", "f2i", "f2l", "f2d", "d2i", "d2l", "d2f", "i2b", "i2c", "i2s", "lcmp", "fcmpl", "fcmpg", "dcmpl", "dcmpg", "ifeq", "ifne", "iflt", "ifge", "ifgt", "ifle", "if_icmpeq", "if_icmpne", "if_icmplt", "if_icmpge", "if_icmpgt", "if_icmple", "if_acmpeq", "if_acmpne", "goto", "jsr", "ret", "tableswitch", "lookupswitch", "ireturn", "lreturn", "freturn", "dreturn", "areturn", "return", "getstatic", "putstatic", "getfield", "putfield", "invokevirtual", "invokespecial", "invokestatic", "invokeinterface", "???", "new", "newarray", "anewarray", "arraylength", "athrow", "checkcast", "instanceof", "monitorenter", "monitorexit", "wide", "multianewarray", "ifnull", "ifnonnull", "goto_w", "jsr_w", "breakpoint", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "???", "impdep1", "impdep2"};
    private static final int[] OPERAND_COUNT;
    private Attribute attribute;
    private int pc;
    private byte[] code;

    static {
        int[] nArray = new int[256];
        nArray[16] = 1;
        nArray[17] = 2;
        nArray[18] = 1;
        nArray[19] = 2;
        nArray[20] = 2;
        nArray[21] = 1;
        nArray[22] = 1;
        nArray[23] = 1;
        nArray[24] = 1;
        nArray[25] = 1;
        nArray[54] = 1;
        nArray[55] = 1;
        nArray[56] = 1;
        nArray[57] = 1;
        nArray[58] = 1;
        nArray[132] = 2;
        nArray[153] = 2;
        nArray[154] = 2;
        nArray[155] = 2;
        nArray[156] = 2;
        nArray[157] = 2;
        nArray[158] = 2;
        nArray[159] = 2;
        nArray[160] = 2;
        nArray[161] = 2;
        nArray[162] = 2;
        nArray[163] = 2;
        nArray[164] = 2;
        nArray[165] = 2;
        nArray[166] = 2;
        nArray[167] = 2;
        nArray[168] = 2;
        nArray[169] = 1;
        nArray[170] = -1;
        nArray[171] = -1;
        nArray[178] = 2;
        nArray[179] = 2;
        nArray[180] = 2;
        nArray[181] = 2;
        nArray[182] = 2;
        nArray[183] = 2;
        nArray[184] = 2;
        nArray[185] = 4;
        nArray[187] = 2;
        nArray[188] = 1;
        nArray[189] = 2;
        nArray[192] = 2;
        nArray[193] = 2;
        nArray[196] = -1;
        nArray[197] = 3;
        nArray[198] = 2;
        nArray[199] = 2;
        nArray[200] = 4;
        nArray[201] = 4;
        OPERAND_COUNT = nArray;
    }

    public JVMOperation(Attribute codeAttribute, int startIndex) {
        this.attribute = codeAttribute;
        this.pc = startIndex;
        this.code = this.attribute.getData();
    }

    public int getOpcode() {
        return this.code[this.pc] & 0xFF;
    }

    public int getMethodRefIndex() {
        switch (this.code[this.pc] & 0xFF) {
            case 182: 
            case 184: {
                return (this.code[this.pc + 1] & 0xFF) << 8 | this.code[this.pc + 2] & 0xFF;
            }
        }
        return -1;
    }

    public void setMethodRef(int index) {
        switch (this.code[this.pc] & 0xFF) {
            case 182: 
            case 184: {
                this.code[this.pc] = -72;
                this.code[this.pc + 1] = (byte)(index >> 8 & 0xFF);
                this.code[this.pc + 2] = (byte)(index & 0xFF);
                break;
            }
            default: {
                throw new ErrorException("setMethodRefIndex called on nonmethod");
            }
        }
    }

    public int length() {
        int opcode = this.code[this.pc] & 0xFF;
        int operandCount = OPERAND_COUNT[opcode];
        if (operandCount >= 0) {
            return operandCount + 1;
        }
        if (opcode == 196) {
            return (this.code[this.pc + 1] & 0xFF) == 132 ? 6 : 4;
        }
        try {
            int offset = this.pc + 4 & 0xFFFFFFFC;
            int pad = offset - this.pc - 1;
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.code, offset, this.code.length - offset));
            if (opcode == 170) {
                in.skip(4L);
                int low = in.readInt();
                int high = in.readInt();
                in.close();
                return 13 + pad + 4 * (high - low + 1);
            }
            if (opcode == 171) {
                in.skip(4L);
                int nPairs = in.readInt();
                in.close();
                return 9 + pad + 8 * nPairs;
            }
            throw new ErrorException("Undefined instruction");
        }
        catch (IOException ex) {
            throw new ErrorException(ex);
        }
    }

    public String toString() {
        return OPCODE_NAMES[this.code[this.pc] & 0xFF];
    }
}

