/*
 * Decompiled with CFR 0.152.
 */
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;

public class SimpleServer {
    private int port = 8000;
    private SimpleServerListener webApp;

    public SimpleServer(SimpleServerListener webApp, int port) {
        this.webApp = webApp;
        this.port = port;
    }

    public SimpleServer(SimpleServerListener webApp) {
        this.webApp = webApp;
    }

    public void start() {
        try {
            HttpServer server = HttpServer.create(new InetSocketAddress(this.port), 0);
            server.createContext("/img", new ServerFileHandler());
            server.createContext("/images", new ServerFileHandler());
            server.createContext("/favicon.ico", new FaveIconHandler());
            server.createContext("/resources", new ServerFileHandler());
            server.createContext("/saveImage", new ServerImageReceiver());
            server.createContext("/", new GetRequestHandler());
            server.setExecutor(null);
            server.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Request constructRequest(String getRequestString) {
        String[] requestParts = getRequestString.split("\\?");
        String command = requestParts[0];
        Request request = new Request(command);
        if (requestParts.length == 2) {
            String[] paramParts;
            String paramStr = requestParts[1];
            String[] stringArray = paramParts = paramStr.split("&");
            int n = paramParts.length;
            int n2 = 0;
            while (n2 < n) {
                String paramPart = stringArray[n2];
                String key = paramPart.split("=")[0];
                String value = "";
                if (paramPart.split("=").length == 2) {
                    value = paramPart.split("=")[1];
                }
                request.addRaw(key, value);
                ++n2;
            }
        }
        return request;
    }

    private static String getUriString(HttpExchange exchange) {
        URI uri = exchange.getRequestURI();
        String uriStr = uri.toString();
        uriStr = uriStr.substring(1);
        return uriStr;
    }

    private void makeStandardExchange(HttpExchange exchange) throws IOException {
        exchange.getResponseHeaders().set("Access-Control-Allow-Origin", "*");
        exchange.getResponseHeaders().set("Content-Type", "text/plain");
        exchange.getResponseHeaders().set("Access-Control-Allow-Methods", "GET");
    }

    class FaveIconHandler
    implements HttpHandler {
        FaveIconHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            try {
                File file = new File("images/faveicon.ico");
                SimpleServer.this.makeStandardExchange(exchange);
                exchange.sendResponseHeaders(200, file.length());
                OutputStream outputStream = exchange.getResponseBody();
                Files.copy(file.toPath(), outputStream);
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class GetRequestHandler
    implements HttpHandler {
        GetRequestHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            try {
                String uriStr = SimpleServer.getUriString(exchange);
                Request request = SimpleServer.this.constructRequest(uriStr);
                if (request == null) {
                    throw new IOException("Malformed request " + uriStr);
                }
                String response = SimpleServer.this.webApp.requestMade(request);
                if (response == null) {
                    throw new RuntimeException("Server request returned null.");
                }
                SimpleServer.this.makeStandardExchange(exchange);
                exchange.sendResponseHeaders(200, response.length());
                OutputStream os = exchange.getResponseBody();
                os.write(response.getBytes());
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    class ServerFileHandler
    implements HttpHandler {
        ServerFileHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            try {
                String uriStr = SimpleServer.getUriString(exchange);
                File file = new File(uriStr);
                exchange.sendResponseHeaders(200, file.length());
                SimpleServer.this.makeStandardExchange(exchange);
                OutputStream outputStream = exchange.getResponseBody();
                Files.copy(file.toPath(), outputStream);
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    class ServerImageReceiver
    implements HttpHandler {
        ServerImageReceiver() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            try {
                String uriStr = SimpleServer.getUriString(exchange);
                Request r = SimpleServer.this.constructRequest(uriStr);
                String fileStr = r.getParam("file");
                byte[] bytes = Base64.getUrlDecoder().decode(fileStr);
                String fileName = r.getParam("fileName");
                Path path = Paths.get("images", fileName);
                FileOutputStream fos = new FileOutputStream(path.toString());
                fos.write(bytes);
                fos.close();
                String response = "success";
                SimpleServer.this.makeStandardExchange(exchange);
                exchange.sendResponseHeaders(200, response.length());
                OutputStream os = exchange.getResponseBody();
                os.write(response.getBytes());
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }
}

