/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GImage;
import acm.program.ConsoleProgram;
import java.io.IOException;

public class TesterClient
extends ConsoleProgram {
    private static String HOST = "http://localhost:8000";

    public void run() {
        this.runTests();
    }

    private void runTests() {
        Request base = new Request("abc");
        this.runTest(base, false);
        base.addParam("a", "77");
        this.runTest(base, false);
        base.addParam("b", "");
        this.runTest(base, false);
        base.addParam("c", "this is a sentance\"&&&==");
        this.runTest(base, false);
        Request errorRequest = new Request("makeError");
        errorRequest.addParam("msg", ": bad times");
        this.runTest(errorRequest, true);
        errorRequest.addParam("msg", ":;;,,!! bad times");
        this.runTest(errorRequest, true);
        this.println("Sending an image (and making it 50 x 50)");
        SimpleClient.saveImage(HOST, "ChrisP.jpg", 50, 50);
        GImage img = SimpleClient.getImage(HOST, "ChrisP.jpg");
        this.println(img.getSize());
        this.println("");
        try {
            Request emptyCommand = new Request("");
            this.runTest(emptyCommand, true);
        }
        catch (RuntimeException e) {
            this.println("got it! " + e.getMessage());
        }
    }

    private void runTest(Request request, boolean expectError) {
        this.println(request.toString());
        try {
            String result = SimpleClient.makeRequest(HOST, request);
            if (expectError) {
                this.println("Test failed. Expected an error but didn't get one");
            } else if (!result.equals(request.toString())) {
                this.println("Test failed.");
                this.println("Expected response: " + request.toString());
                this.println("Actuall response:  " + result);
            } else {
                this.println("Test passed");
            }
        }
        catch (IOException e) {
            if (expectError) {
                this.println("Test passed. Error message was " + e.getMessage());
            }
            this.println("Test failed. Received unexpected error: " + e.getMessage());
        }
        this.println("");
    }
}

