/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.AnnotableNode;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import java.util.LinkedList;
import java.util.List;

public class PositionUtils {
    public static <T extends Node> void sortByBeginPosition(List<T> nodes) {
        PositionUtils.sortByBeginPosition(nodes, false);
    }

    public static <T extends Node> void sortByBeginPosition(List<T> nodes, boolean ignoringAnnotations) {
        int i;
        Node[] arrayNodos = new Node[]{};
        arrayNodos = nodes.toArray(arrayNodos);
        for (i = 0; i < arrayNodos.length; ++i) {
            for (int j = i + 1; j < arrayNodos.length; ++j) {
                Node nodeI = arrayNodos[i];
                Node nodeJ = arrayNodos[j];
                if (PositionUtils.areInOrder(nodeI, nodeJ, ignoringAnnotations)) continue;
                arrayNodos[i] = nodeJ;
                arrayNodos[j] = nodeI;
            }
        }
        for (i = 0; i < arrayNodos.length; ++i) {
            nodes.set(i, arrayNodos[i]);
        }
    }

    public static boolean areInOrder(Node a, Node b) {
        return PositionUtils.areInOrder(a, b, false);
    }

    public static boolean areInOrder(Node a, Node b, boolean ignoringAnnotations) {
        if (ignoringAnnotations) {
            return PositionUtils.beginLineWithoutConsideringAnnotation(a) < PositionUtils.beginLineWithoutConsideringAnnotation(b) || PositionUtils.beginLineWithoutConsideringAnnotation(a) == PositionUtils.beginLineWithoutConsideringAnnotation(b) && PositionUtils.beginColumnWithoutConsideringAnnotation(a) < PositionUtils.beginColumnWithoutConsideringAnnotation(b);
        }
        return a.getBeginLine() < b.getBeginLine() || a.getBeginLine() == b.getBeginLine() && a.getBeginColumn() < b.getBeginColumn();
    }

    public static AnnotationExpr getLastAnnotation(Node node) {
        if (node instanceof AnnotableNode) {
            LinkedList<AnnotationExpr> annotations = new LinkedList<AnnotationExpr>();
            annotations.addAll(((AnnotableNode)((Object)node)).getAnnotations());
            if (annotations.size() == 0) {
                return null;
            }
            PositionUtils.sortByBeginPosition(annotations);
            AnnotationExpr lastAnnotation = (AnnotationExpr)annotations.get(annotations.size() - 1);
            return lastAnnotation;
        }
        return null;
    }

    private static int beginLineWithoutConsideringAnnotation(Node node) {
        return PositionUtils.beginNodeWithoutConsideringAnnotations(node).getBeginLine();
    }

    private static int beginColumnWithoutConsideringAnnotation(Node node) {
        return PositionUtils.beginNodeWithoutConsideringAnnotations(node).getBeginColumn();
    }

    private static Node beginNodeWithoutConsideringAnnotations(Node node) {
        if (node instanceof MethodDeclaration) {
            MethodDeclaration casted = (MethodDeclaration)node;
            return casted.getType();
        }
        if (node instanceof FieldDeclaration) {
            FieldDeclaration casted = (FieldDeclaration)node;
            return casted.getType();
        }
        if (node instanceof ClassOrInterfaceDeclaration) {
            ClassOrInterfaceDeclaration casted = (ClassOrInterfaceDeclaration)node;
            return casted.getNameExpr();
        }
        return node;
    }

    public static boolean nodeContains(Node container, Node contained, boolean ignoringAnnotations) {
        if (!ignoringAnnotations || PositionUtils.getLastAnnotation(container) == null) {
            return container.contains(contained);
        }
        if (!container.contains(contained)) {
            return false;
        }
        if (container instanceof AnnotableNode) {
            int bl = PositionUtils.beginLineWithoutConsideringAnnotation(container);
            int bc = PositionUtils.beginColumnWithoutConsideringAnnotation(container);
            if (bl > contained.getBeginLine()) {
                return false;
            }
            if (bl == contained.getBeginLine() && bc > contained.getBeginColumn()) {
                return false;
            }
            if (container.getEndLine() < contained.getEndLine()) {
                return false;
            }
            return container.getEndLine() != contained.getEndLine() || container.getEndColumn() >= contained.getEndColumn();
        }
        return true;
    }
}

