/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.visitor;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.TypeParameter;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import com.github.javaparser.ast.body.BaseParameter;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EmptyMemberDeclaration;
import com.github.javaparser.ast.body.EmptyTypeDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.InitializerDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.MultiTypeParameter;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.body.VariableDeclaratorId;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.IntegerLiteralMinValueExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.LongLiteralMinValueExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.QualifiedNameExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.SuperExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.AssertStmt;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.BreakStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.ContinueStmt;
import com.github.javaparser.ast.stmt.DoStmt;
import com.github.javaparser.ast.stmt.EmptyStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.ForeachStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.LabeledStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.SwitchEntryStmt;
import com.github.javaparser.ast.stmt.SwitchStmt;
import com.github.javaparser.ast.stmt.SynchronizedStmt;
import com.github.javaparser.ast.stmt.ThrowStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.stmt.TypeDeclarationStmt;
import com.github.javaparser.ast.stmt.WhileStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.ast.type.WildcardType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import java.util.Iterator;
import java.util.List;

public class EqualsVisitor
implements GenericVisitor<Boolean, Node> {
    private static final EqualsVisitor SINGLETON = new EqualsVisitor();

    public static boolean equals(Node n1, Node n2) {
        return SINGLETON.nodeEquals(n1, n2);
    }

    private EqualsVisitor() {
    }

    private boolean commonNodeEquality(Node n1, Node n2) {
        if (!this.nodeEquals(n1.getComment(), n2.getComment())) {
            return false;
        }
        return this.nodesEquals(n1.getOrphanComments(), n2.getOrphanComments());
    }

    private <T extends Node> boolean nodesEquals(List<T> nodes1, List<T> nodes2) {
        if (nodes1 == null) {
            return nodes2 == null;
        }
        if (nodes2 == null) {
            return false;
        }
        if (nodes1.size() != nodes2.size()) {
            return false;
        }
        for (int i = 0; i < nodes1.size(); ++i) {
            if (this.nodeEquals((Node)nodes1.get(i), (Node)nodes2.get(i))) continue;
            return false;
        }
        return true;
    }

    private <T extends Node> boolean nodeEquals(T n1, T n2) {
        if (n1 == n2) {
            return true;
        }
        if (n1 == null) {
            return n2 == null;
        }
        if (n2 == null) {
            return false;
        }
        if (n1.getClass() != n2.getClass()) {
            return false;
        }
        if (!this.commonNodeEquality(n1, n2)) {
            return false;
        }
        return n1.accept(this, n2);
    }

    private boolean objEquals(Object n1, Object n2) {
        if (n1 == n2) {
            return true;
        }
        if (n1 == null) {
            return n2 == null;
        }
        if (n2 == null) {
            return false;
        }
        return n1.equals(n2);
    }

    @Override
    public Boolean visit(CompilationUnit n1, Node arg) {
        CompilationUnit n2 = (CompilationUnit)arg;
        if (!this.nodeEquals(n1.getPackage(), n2.getPackage())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getImports(), n2.getImports())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getTypes(), n2.getTypes())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getComments(), n2.getComments())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(PackageDeclaration n1, Node arg) {
        PackageDeclaration n2 = (PackageDeclaration)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ImportDeclaration n1, Node arg) {
        ImportDeclaration n2 = (ImportDeclaration)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(TypeParameter n1, Node arg) {
        TypeParameter n2 = (TypeParameter)arg;
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getTypeBound(), n2.getTypeBound())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(LineComment n1, Node arg) {
        LineComment n2 = (LineComment)arg;
        if (!this.objEquals(n1.getContent(), n2.getContent())) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(n1.getBeginLine(), n2.getBeginLine())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(BlockComment n1, Node arg) {
        BlockComment n2 = (BlockComment)arg;
        if (!this.objEquals(n1.getContent(), n2.getContent())) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(n1.getBeginLine(), n2.getBeginLine())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ClassOrInterfaceDeclaration n1, Node arg) {
        ClassOrInterfaceDeclaration n2 = (ClassOrInterfaceDeclaration)arg;
        if (n1.getModifiers() != n2.getModifiers()) {
            return Boolean.FALSE;
        }
        if (n1.isInterface() != n2.isInterface()) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getTypeParameters(), n2.getTypeParameters())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getExtends(), n2.getExtends())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getImplements(), n2.getImplements())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getMembers(), n2.getMembers())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(EnumDeclaration n1, Node arg) {
        EnumDeclaration n2 = (EnumDeclaration)arg;
        if (n1.getModifiers() != n2.getModifiers()) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getImplements(), n2.getImplements())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getEntries(), n2.getEntries())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getMembers(), n2.getMembers())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(EmptyTypeDeclaration n1, Node arg) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(EnumConstantDeclaration n1, Node arg) {
        EnumConstantDeclaration n2 = (EnumConstantDeclaration)arg;
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getArgs(), n2.getArgs())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getClassBody(), n2.getClassBody())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(AnnotationDeclaration n1, Node arg) {
        AnnotationDeclaration n2 = (AnnotationDeclaration)arg;
        if (n1.getModifiers() != n2.getModifiers()) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getMembers(), n2.getMembers())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(AnnotationMemberDeclaration n1, Node arg) {
        AnnotationMemberDeclaration n2 = (AnnotationMemberDeclaration)arg;
        if (n1.getModifiers() != n2.getModifiers()) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getDefaultValue(), n2.getDefaultValue())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(FieldDeclaration n1, Node arg) {
        FieldDeclaration n2 = (FieldDeclaration)arg;
        if (n1.getModifiers() != n2.getModifiers()) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getVariables(), n2.getVariables())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(VariableDeclarator n1, Node arg) {
        VariableDeclarator n2 = (VariableDeclarator)arg;
        if (!this.nodeEquals(n1.getId(), n2.getId())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getInit(), n2.getInit())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(VariableDeclaratorId n1, Node arg) {
        VariableDeclaratorId n2 = (VariableDeclaratorId)arg;
        if (n1.getArrayCount() != n2.getArrayCount()) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ConstructorDeclaration n1, Node arg) {
        ConstructorDeclaration n2 = (ConstructorDeclaration)arg;
        if (n1.getModifiers() != n2.getModifiers()) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getBlock(), n2.getBlock())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getParameters(), n2.getParameters())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getThrows(), n2.getThrows())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getTypeParameters(), n2.getTypeParameters())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(MethodDeclaration n1, Node arg) {
        MethodDeclaration n2 = (MethodDeclaration)arg;
        if (n1.getModifiers() != n2.getModifiers()) {
            return Boolean.FALSE;
        }
        if (n1.getArrayCount() != n2.getArrayCount()) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getParameters(), n2.getParameters())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getThrows(), n2.getThrows())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getTypeParameters(), n2.getTypeParameters())) {
            return Boolean.FALSE;
        }
        if (n1.isDefault() != n2.isDefault()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(Parameter n1, Node arg) {
        Parameter n2 = (Parameter)arg;
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return Boolean.FALSE;
        }
        return this.visit((BaseParameter)n1, arg);
    }

    @Override
    public Boolean visit(MultiTypeParameter n1, Node arg) {
        MultiTypeParameter n2 = (MultiTypeParameter)arg;
        if (n1.getTypes().size() != n2.getTypes().size()) {
            return Boolean.FALSE;
        }
        Iterator<Type> n1types = n1.getTypes().iterator();
        Iterator<Type> n2types = n2.getTypes().iterator();
        while (n1types.hasNext() && n2types.hasNext()) {
            if (this.nodeEquals((Node)n1types.next(), (Node)n2types.next())) continue;
            return Boolean.FALSE;
        }
        return this.visit((BaseParameter)n1, arg);
    }

    protected Boolean visit(BaseParameter n1, Node arg) {
        BaseParameter n2 = (BaseParameter)arg;
        if (n1.getModifiers() != n2.getModifiers()) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getId(), n2.getId())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(EmptyMemberDeclaration n1, Node arg) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(InitializerDeclaration n1, Node arg) {
        InitializerDeclaration n2 = (InitializerDeclaration)arg;
        if (!this.nodeEquals(n1.getBlock(), n2.getBlock())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(JavadocComment n1, Node arg) {
        JavadocComment n2 = (JavadocComment)arg;
        if (!this.objEquals(n1.getContent(), n2.getContent())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ClassOrInterfaceType n1, Node arg) {
        ClassOrInterfaceType n2 = (ClassOrInterfaceType)arg;
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getScope(), n2.getScope())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getTypeArgs(), n2.getTypeArgs())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(PrimitiveType n1, Node arg) {
        PrimitiveType n2 = (PrimitiveType)arg;
        if (n1.getType() != n2.getType()) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ReferenceType n1, Node arg) {
        ReferenceType n2 = (ReferenceType)arg;
        if (n1.getArrayCount() != n2.getArrayCount()) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return Boolean.FALSE;
        }
        List<List<AnnotationExpr>> n1a = n1.getArraysAnnotations();
        List<List<AnnotationExpr>> n2a = n2.getArraysAnnotations();
        if (n1a != null && n2a != null) {
            if (n1a.size() != n2a.size()) {
                return Boolean.FALSE;
            }
            int i = 0;
            for (List<AnnotationExpr> aux : n1a) {
                if (!this.nodesEquals(aux, n2a.get(i))) {
                    return Boolean.FALSE;
                }
                ++i;
            }
        } else if (n1a != n2a) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(VoidType n1, Node arg) {
        VoidType n2 = (VoidType)arg;
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(WildcardType n1, Node arg) {
        WildcardType n2 = (WildcardType)arg;
        if (!this.nodeEquals(n1.getExtends(), n2.getExtends())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getSuper(), n2.getSuper())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ArrayAccessExpr n1, Node arg) {
        ArrayAccessExpr n2 = (ArrayAccessExpr)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getIndex(), n2.getIndex())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ArrayCreationExpr n1, Node arg) {
        ArrayCreationExpr n2 = (ArrayCreationExpr)arg;
        if (n1.getArrayCount() != n2.getArrayCount()) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getInitializer(), n2.getInitializer())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getDimensions(), n2.getDimensions())) {
            return Boolean.FALSE;
        }
        List<List<AnnotationExpr>> n1a = n1.getArraysAnnotations();
        List<List<AnnotationExpr>> n2a = n2.getArraysAnnotations();
        if (n1a != null && n2a != null) {
            if (n1a.size() != n2a.size()) {
                return Boolean.FALSE;
            }
            int i = 0;
            for (List<AnnotationExpr> aux : n1a) {
                if (!this.nodesEquals(aux, n2a.get(i))) {
                    return Boolean.FALSE;
                }
                ++i;
            }
        } else if (n1a != n2a) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ArrayInitializerExpr n1, Node arg) {
        ArrayInitializerExpr n2 = (ArrayInitializerExpr)arg;
        if (!this.nodesEquals(n1.getValues(), n2.getValues())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(AssignExpr n1, Node arg) {
        AssignExpr n2 = (AssignExpr)arg;
        if (n1.getOperator() != n2.getOperator()) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getTarget(), n2.getTarget())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getValue(), n2.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(BinaryExpr n1, Node arg) {
        BinaryExpr n2 = (BinaryExpr)arg;
        if (n1.getOperator() != n2.getOperator()) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getLeft(), n2.getLeft())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getRight(), n2.getRight())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(CastExpr n1, Node arg) {
        CastExpr n2 = (CastExpr)arg;
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getExpr(), n2.getExpr())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ClassExpr n1, Node arg) {
        ClassExpr n2 = (ClassExpr)arg;
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ConditionalExpr n1, Node arg) {
        ConditionalExpr n2 = (ConditionalExpr)arg;
        if (!this.nodeEquals(n1.getCondition(), n2.getCondition())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getThenExpr(), n2.getThenExpr())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getElseExpr(), n2.getElseExpr())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(EnclosedExpr n1, Node arg) {
        EnclosedExpr n2 = (EnclosedExpr)arg;
        if (!this.nodeEquals(n1.getInner(), n2.getInner())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(FieldAccessExpr n1, Node arg) {
        FieldAccessExpr n2 = (FieldAccessExpr)arg;
        if (!this.nodeEquals(n1.getScope(), n2.getScope())) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(n1.getField(), n2.getField())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getTypeArgs(), n2.getTypeArgs())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(InstanceOfExpr n1, Node arg) {
        InstanceOfExpr n2 = (InstanceOfExpr)arg;
        if (!this.nodeEquals(n1.getExpr(), n2.getExpr())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(StringLiteralExpr n1, Node arg) {
        StringLiteralExpr n2 = (StringLiteralExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(IntegerLiteralExpr n1, Node arg) {
        IntegerLiteralExpr n2 = (IntegerLiteralExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(LongLiteralExpr n1, Node arg) {
        LongLiteralExpr n2 = (LongLiteralExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(IntegerLiteralMinValueExpr n1, Node arg) {
        IntegerLiteralMinValueExpr n2 = (IntegerLiteralMinValueExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(LongLiteralMinValueExpr n1, Node arg) {
        LongLiteralMinValueExpr n2 = (LongLiteralMinValueExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(CharLiteralExpr n1, Node arg) {
        CharLiteralExpr n2 = (CharLiteralExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(DoubleLiteralExpr n1, Node arg) {
        DoubleLiteralExpr n2 = (DoubleLiteralExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(BooleanLiteralExpr n1, Node arg) {
        BooleanLiteralExpr n2 = (BooleanLiteralExpr)arg;
        if (n1.getValue() != n2.getValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(NullLiteralExpr n1, Node arg) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(MethodCallExpr n1, Node arg) {
        MethodCallExpr n2 = (MethodCallExpr)arg;
        if (!this.nodeEquals(n1.getScope(), n2.getScope())) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getArgs(), n2.getArgs())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getTypeArgs(), n2.getTypeArgs())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(NameExpr n1, Node arg) {
        NameExpr n2 = (NameExpr)arg;
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ObjectCreationExpr n1, Node arg) {
        ObjectCreationExpr n2 = (ObjectCreationExpr)arg;
        if (!this.nodeEquals(n1.getScope(), n2.getScope())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getAnonymousClassBody(), n2.getAnonymousClassBody())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getArgs(), n2.getArgs())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getTypeArgs(), n2.getTypeArgs())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(QualifiedNameExpr n1, Node arg) {
        QualifiedNameExpr n2 = (QualifiedNameExpr)arg;
        if (!this.nodeEquals(n1.getQualifier(), n2.getQualifier())) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ThisExpr n1, Node arg) {
        ThisExpr n2 = (ThisExpr)arg;
        if (!this.nodeEquals(n1.getClassExpr(), n2.getClassExpr())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(SuperExpr n1, Node arg) {
        SuperExpr n2 = (SuperExpr)arg;
        if (!this.nodeEquals(n1.getClassExpr(), n2.getClassExpr())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(UnaryExpr n1, Node arg) {
        UnaryExpr n2 = (UnaryExpr)arg;
        if (n1.getOperator() != n2.getOperator()) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getExpr(), n2.getExpr())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(VariableDeclarationExpr n1, Node arg) {
        VariableDeclarationExpr n2 = (VariableDeclarationExpr)arg;
        if (n1.getModifiers() != n2.getModifiers()) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getVars(), n2.getVars())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(MarkerAnnotationExpr n1, Node arg) {
        MarkerAnnotationExpr n2 = (MarkerAnnotationExpr)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(SingleMemberAnnotationExpr n1, Node arg) {
        SingleMemberAnnotationExpr n2 = (SingleMemberAnnotationExpr)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getMemberValue(), n2.getMemberValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(NormalAnnotationExpr n1, Node arg) {
        NormalAnnotationExpr n2 = (NormalAnnotationExpr)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getPairs(), n2.getPairs())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(MemberValuePair n1, Node arg) {
        MemberValuePair n2 = (MemberValuePair)arg;
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getValue(), n2.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ExplicitConstructorInvocationStmt n1, Node arg) {
        ExplicitConstructorInvocationStmt n2 = (ExplicitConstructorInvocationStmt)arg;
        if (!this.nodeEquals(n1.getExpr(), n2.getExpr())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getArgs(), n2.getArgs())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getTypeArgs(), n2.getTypeArgs())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(TypeDeclarationStmt n1, Node arg) {
        TypeDeclarationStmt n2 = (TypeDeclarationStmt)arg;
        if (!this.nodeEquals(n1.getTypeDeclaration(), n2.getTypeDeclaration())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(AssertStmt n1, Node arg) {
        AssertStmt n2 = (AssertStmt)arg;
        if (!this.nodeEquals(n1.getCheck(), n2.getCheck())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getMessage(), n2.getMessage())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(BlockStmt n1, Node arg) {
        BlockStmt n2 = (BlockStmt)arg;
        if (!this.nodesEquals(n1.getStmts(), n2.getStmts())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(LabeledStmt n1, Node arg) {
        LabeledStmt n2 = (LabeledStmt)arg;
        if (!this.nodeEquals(n1.getStmt(), n2.getStmt())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(EmptyStmt n1, Node arg) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ExpressionStmt n1, Node arg) {
        ExpressionStmt n2 = (ExpressionStmt)arg;
        if (!this.nodeEquals(n1.getExpression(), n2.getExpression())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(SwitchStmt n1, Node arg) {
        SwitchStmt n2 = (SwitchStmt)arg;
        if (!this.nodeEquals(n1.getSelector(), n2.getSelector())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getEntries(), n2.getEntries())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(SwitchEntryStmt n1, Node arg) {
        SwitchEntryStmt n2 = (SwitchEntryStmt)arg;
        if (!this.nodeEquals(n1.getLabel(), n2.getLabel())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getStmts(), n2.getStmts())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(BreakStmt n1, Node arg) {
        BreakStmt n2 = (BreakStmt)arg;
        if (!this.objEquals(n1.getId(), n2.getId())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ReturnStmt n1, Node arg) {
        ReturnStmt n2 = (ReturnStmt)arg;
        if (!this.nodeEquals(n1.getExpr(), n2.getExpr())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(IfStmt n1, Node arg) {
        IfStmt n2 = (IfStmt)arg;
        if (!this.nodeEquals(n1.getCondition(), n2.getCondition())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getThenStmt(), n2.getThenStmt())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getElseStmt(), n2.getElseStmt())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(WhileStmt n1, Node arg) {
        WhileStmt n2 = (WhileStmt)arg;
        if (!this.nodeEquals(n1.getCondition(), n2.getCondition())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ContinueStmt n1, Node arg) {
        ContinueStmt n2 = (ContinueStmt)arg;
        if (!this.objEquals(n1.getId(), n2.getId())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(DoStmt n1, Node arg) {
        DoStmt n2 = (DoStmt)arg;
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getCondition(), n2.getCondition())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ForeachStmt n1, Node arg) {
        ForeachStmt n2 = (ForeachStmt)arg;
        if (!this.nodeEquals(n1.getVariable(), n2.getVariable())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getIterable(), n2.getIterable())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ForStmt n1, Node arg) {
        ForStmt n2 = (ForStmt)arg;
        if (!this.nodesEquals(n1.getInit(), n2.getInit())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getCompare(), n2.getCompare())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getUpdate(), n2.getUpdate())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ThrowStmt n1, Node arg) {
        ThrowStmt n2 = (ThrowStmt)arg;
        if (!this.nodeEquals(n1.getExpr(), n2.getExpr())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(SynchronizedStmt n1, Node arg) {
        SynchronizedStmt n2 = (SynchronizedStmt)arg;
        if (!this.nodeEquals(n1.getExpr(), n2.getExpr())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getBlock(), n2.getBlock())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(TryStmt n1, Node arg) {
        TryStmt n2 = (TryStmt)arg;
        if (!this.nodeEquals(n1.getTryBlock(), n2.getTryBlock())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getCatchs(), n2.getCatchs())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getFinallyBlock(), n2.getFinallyBlock())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(CatchClause n1, Node arg) {
        CatchClause n2 = (CatchClause)arg;
        if (!this.nodeEquals(n1.getExcept(), n2.getExcept())) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getCatchBlock(), n2.getCatchBlock())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(LambdaExpr n1, Node arg) {
        LambdaExpr n2 = (LambdaExpr)arg;
        if (!this.nodesEquals(n1.getParameters(), n2.getParameters())) {
            return Boolean.FALSE;
        }
        if (n1.isParametersEnclosed() != n2.isParametersEnclosed()) {
            return Boolean.FALSE;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(MethodReferenceExpr n1, Node arg) {
        MethodReferenceExpr n2 = (MethodReferenceExpr)arg;
        if (!this.nodeEquals(n1.getScope(), n2.getScope())) {
            return Boolean.FALSE;
        }
        if (!this.nodesEquals(n1.getTypeParameters(), n2.getTypeParameters())) {
            return Boolean.FALSE;
        }
        if (!this.objEquals(n1.getIdentifier(), n2.getIdentifier())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(TypeExpr n, Node arg) {
        TypeExpr n2 = (TypeExpr)arg;
        if (!this.nodeEquals(n.getType(), n2.getType())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

