/*
 * Decompiled with CFR 0.152.
 */
package graphs;

import graphs.EmptyGraph;
import graphs.GitGraph;
import graphs.Indentation;
import graphs.RunsGraph;
import graphs.SourceLengthGraph;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.VBox;
import stanford.edu.gitviewer.Intermediate;

public class GraphChoser {
    VBox graphChoserBox = new VBox();
    GitGraph currGraph = null;
    ComboBox<String> comboBox = new ComboBox();
    List<Intermediate> historyCache = null;
    double selectedTimeCache = 0.0;

    public GraphChoser(String graphType) {
        this.populateComboBox();
        this.setGraphType(graphType);
        this.comboBox.setValue((Object)graphType);
        this.graphChoserBox.getChildren().add(this.comboBox);
        this.graphChoserBox.getChildren().add((Object)this.currGraph.getView());
        this.graphChoserBox.setAlignment(Pos.CENTER);
        this.comboBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                String graphType = (String)GraphChoser.this.comboBox.getValue();
                GraphChoser.this.setGraphType(graphType);
                GraphChoser.this.graphChoserBox.getChildren().remove(1);
                GraphChoser.this.graphChoserBox.getChildren().add(1, (Object)GraphChoser.this.currGraph.getView());
                if (GraphChoser.this.historyCache != null) {
                    GraphChoser.this.currGraph.drawGraph(GraphChoser.this.historyCache);
                    GraphChoser.this.currGraph.setSelectedTime(GraphChoser.this.selectedTimeCache);
                }
            }
        });
    }

    private void setGraphType(String graphType) {
        if (graphType.equals("SourceLength")) {
            this.currGraph = new SourceLengthGraph();
        } else if (graphType.equals("Indentation")) {
            this.currGraph = new Indentation();
        } else if (graphType.equals("None")) {
            this.currGraph = new EmptyGraph();
        } else if (graphType.equals("Runs")) {
            this.currGraph = new RunsGraph();
        } else {
            throw new IllegalArgumentException("Invalid graph: " + graphType);
        }
    }

    public VBox getView() {
        return this.graphChoserBox;
    }

    public void drawGraph(List<Intermediate> history) {
        this.historyCache = history;
        this.currGraph.drawGraph(history);
    }

    public void setSelectedTime(double workingHours) {
        this.selectedTimeCache = workingHours;
        this.currGraph.setSelectedTime(workingHours);
    }

    private void populateComboBox() {
        ArrayList<String> graphTypes = new ArrayList<String>();
        graphTypes.add("SourceLength");
        graphTypes.add("Runs");
        graphTypes.add("Indentation");
        graphTypes.add("None");
        ObservableList options = FXCollections.observableArrayList(graphTypes);
        this.comboBox.setItems(options);
    }
}

