/*
 * Decompiled with CFR 0.152.
 */
package graphs;

import graphs.GitGraph;
import java.util.List;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import stanford.edu.gitviewer.Intermediate;

public class SourceLengthGraph
implements GitGraph {
    private static final double EPSILON = 1.0E-9;
    final NumberAxis xAxis = new NumberAxis();
    final NumberAxis yAxis = new NumberAxis();
    final LineChart<Number, Number> lineChart = new LineChart((Axis)this.xAxis, (Axis)this.yAxis);
    private Double maxY = null;
    private XYChart.Series<Number, Number> vertical;
    boolean disabled = false;

    public LineChart<Number, Number> getView() {
        this.lineChart.setAnimated(false);
        return this.lineChart;
    }

    @Override
    public void drawGraph(List<Intermediate> history) {
        boolean bl = this.disabled = history.size() <= 1;
        if (this.disabled) {
            return;
        }
        this.maxY = null;
        this.lineChart.getData().clear();
        this.xAxis.setLabel("Time into Problem (hours)");
        this.yAxis.setLabel("Characters");
        XYChart.Series<Number, Number> comments = this.getCommentSeries(history);
        XYChart.Series<Number, Number> codes = this.getCodeSeries(history);
        this.addVerticalMarker();
        this.lineChart.getData().add(comments);
        this.lineChart.getData().add(codes);
    }

    @Override
    public void setSelectedTime(double time) {
        if (!this.disabled) {
            this.setVerticalLocation(time);
        }
    }

    private void addVerticalMarker() {
        this.vertical = new XYChart.Series();
        this.vertical.setName("Selection");
        this.setVerticalLocation(0.0);
        this.lineChart.getData().add(this.vertical);
    }

    private XYChart.Series<Number, Number> getCodeSeries(List<Intermediate> history) {
        XYChart.Series codeSeries = new XYChart.Series();
        codeSeries.setName("Code");
        for (Intermediate intermediate : history) {
            double x = intermediate.workingHours;
            if (intermediate.nonComments == 0) continue;
            double y = intermediate.nonComments;
            codeSeries.getData().add((Object)new XYChart.Data((Object)x, (Object)y));
            if (this.maxY != null && !(y > this.maxY)) continue;
            this.maxY = y;
        }
        return codeSeries;
    }

    private XYChart.Series<Number, Number> getCommentSeries(List<Intermediate> history) {
        XYChart.Series commentSeries = new XYChart.Series();
        commentSeries.setName("Comments");
        for (Intermediate intermediate : history) {
            double x = intermediate.workingHours;
            if (intermediate.totalComments == 0) continue;
            double y = intermediate.totalComments;
            commentSeries.getData().add((Object)new XYChart.Data((Object)x, (Object)y));
            if (this.maxY != null && !(y > this.maxY)) continue;
            this.maxY = y;
        }
        return commentSeries;
    }

    private void setVerticalLocation(double loc) {
        this.vertical.getData().clear();
        this.vertical.getData().add((Object)new XYChart.Data((Object)loc, (Object)0));
        this.vertical.getData().add((Object)new XYChart.Data((Object)(loc + 1.0E-9), (Object)this.maxY));
    }
}

