/*
 * Decompiled with CFR 0.152.
 */
package javaEval;

import java.io.IOException;
import java.security.SecureClassLoader;
import java.util.HashMap;
import java.util.Map;
import javaEval.JavaClassObject;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;

public class ClassFileManager
extends ForwardingJavaFileManager {
    private Map<String, JavaClassObject> jclassMap = new HashMap<String, JavaClassObject>();

    public ClassFileManager(StandardJavaFileManager standardManager) {
        super(standardManager);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return new SecureClassLoader(){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                JavaClassObject jclassObject = (JavaClassObject)ClassFileManager.this.jclassMap.get(name);
                byte[] b = jclassObject.getBytes();
                return super.defineClass(name, jclassObject.getBytes(), 0, b.length);
            }
        };
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        JavaClassObject jclassObject = new JavaClassObject(className, kind);
        this.jclassMap.put(className, jclassObject);
        return jclassObject;
    }
}

