/*
 * Decompiled with CFR 0.152.
 */
package minions;

import java.util.ArrayList;
import java.util.List;
import minions.TokenScanner;

public class KarelParser {
    TokenScanner scanner;
    boolean correctlyCarriageReturned = false;
    int indentationErrors = 0;
    boolean parsed = true;
    int indentLevel = 0;

    public int getIndentationErrors() {
        return this.indentationErrors;
    }

    public void parse(String karelCode) {
        this.indentationErrors = 0;
        this.scanner = new TokenScanner(karelCode);
        this.indentLevel = 0;
        List<String> line;
        while (!(line = this.getNextLine()).isEmpty()) {
            if (this.isWhitespace(line)) continue;
            this.lookForCodeBlockEnd(line);
            if (this.hasIndentationError(line)) {
                ++this.indentationErrors;
            }
            this.lookForCodeBlockStart(line);
        }
        return;
    }

    private boolean isWhitespace(List<String> line) {
        for (String str : line) {
            if (str.trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void lookForCodeBlockEnd(List<String> line) {
        if (line.contains("}")) {
            --this.indentLevel;
            this.indentLevel = Math.max(this.indentLevel, 0);
        }
    }

    private void lookForCodeBlockStart(List<String> line) {
        if (line.contains("{")) {
            ++this.indentLevel;
        }
    }

    private boolean hasIndentationError(List<String> line) {
        if (line.size() < this.indentLevel) {
            return true;
        }
        int i = 0;
        while (i < this.indentLevel) {
            if (!line.get(i).equals("\t")) {
                return true;
            }
            ++i;
        }
        return line.get(this.indentLevel).equals("\t");
    }

    private List<String> getNextLine() {
        ArrayList<String> lineTokens = new ArrayList<String>();
        while (this.scanner.hasMoreTokens()) {
            String nextToken = this.scanner.nextToken();
            if (nextToken.equals("\n")) {
                if (lineTokens.isEmpty()) continue;
                return lineTokens;
            }
            lineTokens.add(nextToken);
        }
        return lineTokens;
    }

    public static void main(String[] args) {
        String code = "/*\n * File: StoneMasonKarel.java\n * --------------------------\n * The StoneMasonKarel subclass as it appears here does nothing.\n * When you finish writing it, it should solve the \"repair the quad\"\n * problem from Assignment 1.  In addition to editing the program,\n * you should be sure to edit this comment so that it no longer\n * indicates that the program does nothing.\n */\n\nimport stanford.karel.*;\n\npublic class StoneMasonKarel extends SuperKarel {\n\n\t// Precondition: None\n\t// Postcondition: All columns have been fixed\n\tpublic void run() {\n\t\twhile (frontIsClear()) {\n\t\t\taddStonesToCurrentColumn();\n\t\t\tmoveDownColumn();\n\t\t\tmoveToNextColumn();\n\t\t}\n\t\t//These additional two methods prevent the fencepost error that results from the whileloop not accounting for the last column after hitting wall.\n\t\taddStonesToCurrentColumn();\n\t\tmoveDownColumn();\n\t}\n\t\n\n\t// Makes Karel move up column she is on while detecting whether beeper is present. \n\t// When beeper is not present, Karel places beeper, thus fixing column.\n\t// Final if-statement prevents fencepost error that results from whileloop not accounting for last position after hitting wall.\n\t// Precondition: None\n\t// Postconditions: \n\tprivate void addStonesToCurrentColumn() {\n\t\t// Karel must turn left to face north and move up.\n\t\tturnLeft();\n\t\twhile (frontIsClear()) {\n\t\t\tif (beepersPresent()) {\n\t\t\t\tmove();\n\t\t\t} else {\n\t\t\t\tputBeeper();\n\t\t\t\tmove();\n\t\t\t}\n\t\t}\n\t\tif (noBeepersPresent()) {\n\t\t\tputBeeper();\n\t\t}\n\t}\n\n\t// Makes Karel turn after hitting wall at top of column and move down column until wall at bottom of column is hit.\n\t// Turn left makes Karel face same direction as initial direction (east).\n\tprivate void moveDownColumn() {\n\t\tturnAround();\n\t\twhile (frontIsClear()) {\n\t\t\tmove();\n\t\t}\n\t\tturnLeft();\n\t}\n\n\t// Makes Karel move to next column, which is four spaces away.\n\tprivate void moveToNextColumn() {\n\t\t// Karel will keep moving right until the world ends\n\t\tmove();\n\t\tmove();\n\t\tmove();\n\t\tmove();\n\t}\n}";
        KarelParser parser = new KarelParser();
        parser.parse(code);
        System.out.println(parser.indentationErrors);
    }
}

