/*
 * Decompiled with CFR 0.152.
 */
package minions;

import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javaEval.CharSequenceJavaFileObject;
import javaEval.ClassFileManager;
import javaEval.JavaSource;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import stanford.karel.Karel;
import stanford.karel.KarelCore;
import stanford.karel.KarelException;
import stanford.karel.KarelState;
import util.FileSystem;
import util.Warnings;

public class KarelTester {
    private static final long TIMEOUT_SECONDS = 15L;
    private static String className = "Submission";
    private static List<JavaFileObject> unitTestObjects = null;

    public static void setClassName(String className) {
        KarelTester.className = className;
    }

    public static boolean testCompile(String src, boolean silent) {
        return KarelTester.createCompiledUnit(src, silent) != null;
    }

    public static List<KarelState> getIntermediateStates(KarelState pre, String src) {
        JavaFileManager fileManager = KarelTester.createCompiledUnit(src, true);
        if (fileManager == null) {
            Warnings.error("Program did not compile");
        }
        KarelCore studentInstance = null;
        try {
            String className = KarelTester.className;
            ClassLoader loader = fileManager.getClassLoader(null);
            Class<?> tester = loader.loadClass(className);
            studentInstance = (Karel)tester.newInstance();
            studentInstance.loadPrecondition_salt25041988(pre);
            KarelTester.executeProgram((Karel)studentInstance);
            return studentInstance.getAllStates_salt25041988();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (KarelException e) {
            return studentInstance.getAllStates_salt25041988();
        }
        return null;
    }

    public static KarelState getPostcondition(KarelState pre, String src) {
        JavaFileManager fileManager = KarelTester.createCompiledUnit(src, true);
        if (fileManager == null) {
            return null;
        }
        KarelCore studentInstance = null;
        try {
            String className = KarelTester.className;
            ClassLoader loader = fileManager.getClassLoader(null);
            Class<?> tester = loader.loadClass(className);
            studentInstance = (Karel)tester.newInstance();
            studentInstance.loadPrecondition_salt25041988(pre);
            KarelTester.executeProgram((Karel)studentInstance);
            return studentInstance.getState_salt25041988();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (KarelException e) {
            return studentInstance.getState_salt25041988();
        }
        return null;
    }

    private static JavaFileManager createCompiledUnit(String src, boolean silent) {
        ArrayList<JavaSource> srcToAdd = new ArrayList<JavaSource>();
        try {
            srcToAdd.add(new JavaSource(className, src));
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("failed to create java for ast");
            throw new RuntimeException("test");
        }
        return KarelTester.getCompiledUnit(srcToAdd, silent);
    }

    /*
     * Loose catch block
     */
    private static void executeProgram(final Karel studentInstance) {
        ExecutorService executor;
        block6: {
            executor = Executors.newCachedThreadPool();
            Callable<Object> task = new Callable<Object>(){

                @Override
                public Object call() {
                    studentInstance.run();
                    return null;
                }
            };
            Future<Object> future = executor.submit(task);
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Warnings.error("who interrupted you?");
                future.cancel(true);
                break block6;
            }
            catch (ExecutionException executionException) {
                future.cancel(true);
                break block6;
                catch (Throwable throwable) {
                    future.cancel(true);
                    throw throwable;
                }
            }
            future.cancel(true);
        }
        executor.shutdown();
    }

    private static JavaFileManager getCompiledUnit(List<JavaSource> srcToAdd, boolean silent) {
        boolean compiled;
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        ClassFileManager fileManager = new ClassFileManager(compiler.getStandardFileManager(null, null, null));
        ArrayList<JavaFileObject> jfiles = new ArrayList<JavaFileObject>();
        if (unitTestObjects == null) {
            KarelTester.setUnitTestObjects();
        }
        for (JavaFileObject javaFile : unitTestObjects) {
            jfiles.add(javaFile);
        }
        for (JavaSource javaSource : srcToAdd) {
            String src = javaSource.getSource();
            String className = javaSource.getClassName();
            jfiles.add(new CharSequenceJavaFileObject(className, src));
        }
        StringWriter output = null;
        if (silent) {
            output = new StringWriter();
        }
        if (!(compiled = compiler.getTask(output, fileManager, null, null, null, jfiles).call().booleanValue())) {
            return null;
        }
        return fileManager;
    }

    private static void setUnitTestObjects() {
        unitTestObjects = new ArrayList<JavaFileObject>();
        File srcDir = new File("src");
        File blockySrcDir = new File(srcDir, "karel");
        for (File f : FileSystem.listFiles(blockySrcDir)) {
            if (!FileSystem.getExtension(f).equals("java")) continue;
            String className = FileSystem.getNameWithoutExtension(f);
            String src = FileSystem.getFileContents(f);
            CharSequenceJavaFileObject javaFile = new CharSequenceJavaFileObject(className, src);
            unitTestObjects.add(javaFile);
        }
    }
}

