/*
 * Decompiled with CFR 0.152.
 */
package minions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TokenScanner {
    private String buffer = "";
    boolean ignoreWhitespaceFlag = false;
    boolean ignoreCommentsFlag = true;
    boolean scanNumbersFlag = false;
    boolean scanStringsFlag = false;
    int cp;
    int length;
    private Set<String> operators;
    private Set<Character> wordChars;
    private List<String> savedTokens;
    private List<Character> savedCharacters;
    boolean inputSet = false;
    private static final int INITIAL_STATE = 0;
    private static final int BEFORE_DECIMAL_POINT = 1;
    private static final int AFTER_DECIMAL_POINT = 2;
    private static final int STARTING_EXPONENT = 3;
    private static final int FOUND_EXPONENT_SIGN = 4;
    private static final int SCANNING_EXPONENT = 5;
    private static final int LEADING_ZERO = 6;
    private static final int SCANNING_HEX = 7;
    private static final int FINAL_STATE = 8;

    public TokenScanner(String karelCode) {
        this.setInput(karelCode);
    }

    public void setInput(String input) {
        this.inputSet = true;
        this.buffer = input;
        this.length = input.length();
        this.cp = 0;
        this.savedCharacters = new ArrayList<Character>();
        this.savedTokens = new ArrayList<String>();
        this.wordChars = new HashSet<Character>();
        this.operators = new HashSet<String>();
    }

    public boolean hasMoreTokens() {
        String token = this.nextToken();
        this.saveToken(token);
        return !token.isEmpty();
    }

    /*
     * Unable to fully structure code
     */
    public String nextToken() {
        block12: {
            if (this.savedTokens.size() != 0) {
                return this.popSavedToken();
            }
            block0: while (true) {
                if (this.ignoreWhitespaceFlag) {
                    this.skipSpaces();
                }
                if ((ch = this.getChar()) == null) {
                    return "";
                }
                if (ch.charValue() != '/' || !this.ignoreCommentsFlag) break block12;
                ch = this.getChar();
                if (ch.charValue() == '/') {
                    while ((ch = this.getChar()) != null && ch.charValue() != '\n' && ch.charValue() != '\r') {
                    }
                    if (ch == null || ch.charValue() != '\n') continue;
                    this.saveChar(ch);
                    continue;
                }
                if (ch.charValue() != '*') break;
                prev = null;
                while (true) {
                    if ((ch = this.getChar()) != null && (prev == null || prev.charValue() != '*' || ch.charValue() != '/')) ** break;
                    continue block0;
                    prev = ch;
                }
                break;
            }
            this.saveChar(ch);
            ch = Character.valueOf('/');
        }
        if ((ch.charValue() == '\"' || ch.charValue() == '\'') && this.scanStringsFlag) {
            this.saveChar(ch);
            return this.scanString();
        }
        if (ch != null && Character.isDigit(ch.charValue()) && this.scanNumbersFlag) {
            this.saveChar(ch);
            return this.scanNumber();
        }
        if (this.isWordCharacter(ch)) {
            this.saveChar(ch);
            return this.scanWord();
        }
        op = "" + ch;
        while (this.isOperatorPrefix(op)) {
            ch = this.getChar();
            if (ch == null) break;
            op = String.valueOf(op) + ch;
        }
        while (op.length() > 1 && !this.isOperator(op)) {
            this.saveChar(Character.valueOf(op.charAt(op.length() - 1)));
            op = op.substring(0, op.length() - 1);
        }
        return op;
    }

    public String peekNext() {
        String next = this.nextToken();
        this.saveToken(next);
        return next;
    }

    public void saveToken(String token) {
        this.savedTokens.add(token);
    }

    private String scanString() {
        String token = "";
        char delim = this.getChar().charValue();
        token = String.valueOf(token) + delim;
        while (true) {
            Character ch;
            if ((ch = this.getChar()) == null) {
                throw new Error("Unterminated string");
            }
            if (ch.charValue() == delim) break;
            if (ch.charValue() == '\\') {
                token = String.valueOf(token) + this.scanEscapeCharacter();
                continue;
            }
            token = String.valueOf(token) + ch;
        }
        return String.valueOf(token) + delim;
    }

    private String scanEscapeCharacter() {
        String str = "\\";
        Character ch = this.getChar();
        str = String.valueOf(str) + ch;
        if (Character.isDigit(ch.charValue()) || ch.charValue() == 'x' || ch.charValue() == 'u') {
            boolean hex = !Character.isDigit(ch.charValue());
            while (true) {
                ch = this.getChar();
                if (hex ? !this.isxdigit(ch) : !Character.isDigit(ch.charValue())) break;
                str = String.valueOf(str) + ch;
            }
            this.saveChar(ch);
        }
        return str;
    }

    private boolean isxdigit(Character ch) {
        if (ch == null) {
            return false;
        }
        System.out.println("Warning, I don't parse hex digits");
        return Character.isDigit(ch.charValue());
    }

    private boolean isOperator(String op) {
        return this.operators.contains(op);
    }

    private String scanWord() {
        Character ch;
        String token = "";
        while ((ch = this.getChar()) != null) {
            if (!this.isWordCharacter(ch)) {
                this.saveChar(ch);
                break;
            }
            token = String.valueOf(token) + ch;
        }
        return token;
    }

    private String scanNumber() {
        String token = "";
        int state = 0;
        while (state != 8) {
            Character ch = this.getChar();
            char xch = 'e';
            switch (state) {
                case 0: {
                    if (ch.charValue() == '0') {
                        state = 6;
                        break;
                    }
                    state = 1;
                    break;
                }
                case 1: {
                    if (ch.charValue() == '.') {
                        state = 2;
                        break;
                    }
                    if (ch.charValue() == 'E' || ch.charValue() == 'e') {
                        state = 3;
                        xch = ch.charValue();
                        break;
                    }
                    if (Character.isDigit(ch.charValue())) break;
                    this.saveChar(ch);
                    state = 8;
                    break;
                }
                case 2: {
                    if (ch.charValue() == 'E' || ch.charValue() == 'e') {
                        state = 3;
                        xch = ch.charValue();
                        break;
                    }
                    if (Character.isDigit(ch.charValue())) break;
                    this.saveChar(ch);
                    state = 8;
                    break;
                }
                case 3: {
                    if (ch.charValue() == '+' || ch.charValue() == '-') {
                        state = 4;
                        break;
                    }
                    if (Character.isDigit(ch.charValue())) {
                        state = 5;
                        break;
                    }
                    this.saveChar(ch);
                    state = 8;
                    break;
                }
                case 4: {
                    if (Character.isDigit(ch.charValue())) {
                        state = 5;
                        break;
                    }
                    this.saveChar(ch);
                    this.saveChar(Character.valueOf(xch));
                    state = 8;
                    break;
                }
                case 5: {
                    if (Character.isDigit(ch.charValue())) break;
                    this.saveChar(ch);
                    state = 8;
                    break;
                }
                case 6: {
                    if (ch.charValue() == 'x' || ch.charValue() == 'X') {
                        state = 7;
                        break;
                    }
                    if (ch.charValue() == '.') {
                        state = 2;
                        break;
                    }
                    if (ch.charValue() == 'E' || ch.charValue() == 'e') {
                        state = 3;
                        xch = ch.charValue();
                        break;
                    }
                    if (Character.isDigit(ch.charValue())) break;
                    this.saveChar(ch);
                    state = 8;
                    break;
                }
                case 7: {
                    if (this.isxdigit(ch)) break;
                    this.saveChar(ch);
                    state = 8;
                    break;
                }
                default: {
                    state = 8;
                }
            }
            if (state == 8) continue;
            token = String.valueOf(token) + ch;
        }
        return token;
    }

    private boolean isOperatorPrefix(String op) {
        for (String str : this.operators) {
            if (!str.startsWith(op)) continue;
            return true;
        }
        return false;
    }

    private boolean isWordCharacter(Character ch) {
        if (ch == null) {
            return false;
        }
        return Character.isAlphabetic(ch.charValue()) || Character.isDigit(ch.charValue()) || this.wordChars.contains(ch);
    }

    private void saveChar(Character ch) {
        --this.cp;
        this.savedCharacters.add(ch);
    }

    private void skipSpaces() {
        Character ch;
        do {
            if ((ch = this.getChar()) != null) continue;
            return;
        } while (Character.isWhitespace(ch.charValue()));
        this.saveChar(ch);
    }

    private Character getChar() {
        if (this.savedCharacters.size() == 0) {
            return this.cp >= this.length ? null : Character.valueOf(this.buffer.charAt(this.cp++));
        }
        ++this.cp;
        return this.popSavedCharacter();
    }

    private Character popSavedCharacter() {
        return this.savedCharacters.remove(this.savedCharacters.size() - 1);
    }

    private String popSavedToken() {
        return this.savedTokens.remove(this.savedTokens.size() - 1);
    }
}

