/*
 * Decompiled with CFR 0.152.
 */
package stanford.edu.gitviewer;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebView;
import org.apache.commons.io.IOUtils;

public class CodeEditor
extends StackPane {
    private static final String JAVA_CODE = "x-java";
    private final WebView webview = new WebView();
    private Map<String, String> jsCache = new HashMap<String, String>();
    int scrollY;
    private final String editingTemplate = "<!doctype html><html><head>  ${codemirrorjs}  ${clikejs}</head><body><form><textarea id=\"code\" name=\"code\">\n${code}</textarea></form><script>  var editor = CodeMirror.fromTextArea(document.getElementById(\"code\"), {    lineNumbers: false,    matchBrackets: true,    indentUnit:4,    lineWrapping: true,    indentWithTabs: true,    readOnly: true,    mode: \"text/x-java\"  });  window.onload = function(){window.scrollTo(0,${scrollY});};</script></body></html>";

    CodeEditor(String starterCode) {
        this.webview.setPrefWidth(600.0);
        URL cssUrl = ((Object)((Object)this)).getClass().getResource("css/codemirror.css");
        String cssPath = cssUrl.toExternalForm();
        this.webview.getEngine().setUserStyleSheetLocation(cssPath);
        this.getChildren().add((Object)this.webview);
        this.webview.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent event) {
                CodeEditor.this.scrollY = (Integer)CodeEditor.this.webview.getEngine().executeScript("document.body.scrollTop;");
            }
        });
    }

    public void resetScroll() {
        this.scrollY = 0;
    }

    private String applyEditingTemplate(String code) {
        String html = "<!doctype html><html><head>  ${codemirrorjs}  ${clikejs}</head><body><form><textarea id=\"code\" name=\"code\">\n${code}</textarea></form><script>  var editor = CodeMirror.fromTextArea(document.getElementById(\"code\"), {    lineNumbers: false,    matchBrackets: true,    indentUnit:4,    lineWrapping: true,    indentWithTabs: true,    readOnly: true,    mode: \"text/x-java\"  });  window.onload = function(){window.scrollTo(0,${scrollY});};</script></body></html>".replace("${code}", code);
        html = html.replace("${codemirrorjs}", this.loadCodeFromFile("codemirror.js"));
        html = html.replace("${clikejs}", this.loadCodeFromFile("clike.js"));
        html = html.replace("${scrollY}", "" + this.scrollY);
        return html;
    }

    private String loadCodeFromFile(String fileName) {
        if (this.jsCache.containsKey(fileName)) {
            return this.jsCache.get(fileName);
        }
        String resourceName = "js/" + fileName;
        InputStream input = ((Object)((Object)this)).getClass().getResourceAsStream(resourceName);
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy(input, writer, "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String js = writer.toString();
        String sourceTag = "<script>" + js + "</script>";
        return sourceTag;
    }

    public String getCode() {
        return (String)this.webview.getEngine().executeScript("editor.getValue();");
    }

    public void setCode(String code) {
        this.webview.getEngine().loadContent(this.applyEditingTemplate(code));
    }

    public WebView getView() {
        return this.webview;
    }
}

