/*
 * Decompiled with CFR 0.152.
 */
package stanford.edu.gitviewer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import stanford.edu.gitviewer.Intermediate;
import stanford.edu.gitviewer.Parser;
import stanford.edu.gitviewer.Runner;

public class FileHistory {
    private static final int BREAK_MINS = 10;

    public static ArrayList<String> getFiles(String repoPath) {
        try {
            Git git = Git.init().setDirectory(new File(repoPath)).call();
            Repository repo = git.getRepository();
            ObjectId from = repo.resolve("refs/heads/master");
            RevWalk revWalk = new RevWalk(repo);
            RevCommit headCommit = revWalk.parseCommit(from);
            revWalk.markStart(headCommit);
            HashSet<String> paths = new HashSet<String>();
            for (RevCommit commit : revWalk) {
                RevTree masterTree = commit.getTree();
                TreeWalk treeWalk = new TreeWalk(repo);
                treeWalk.addTree(masterTree);
                treeWalk.setRecursive(false);
                while (treeWalk.next()) {
                    if (treeWalk.isSubtree()) {
                        System.out.println("dir: " + treeWalk.getPathString());
                        treeWalk.enterSubtree();
                        continue;
                    }
                    String pathStr = treeWalk.getPathString();
                    if (!FileHistory.isValidFile(pathStr)) continue;
                    paths.add(pathStr);
                }
                treeWalk.close();
            }
            revWalk.close();
            return new ArrayList<String>(paths);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isValidFile(String name) {
        String caps = name.toUpperCase();
        return !caps.contains("autograder");
    }

    public static ArrayList<Intermediate> getHistory(String repoPath, String filePath, boolean shouldCompile) {
        ArrayList<Intermediate> history = FileHistory.getRawIntermediate(repoPath, filePath);
        FileHistory.addCommitIndex(history);
        FileHistory.addFilePath(history, filePath);
        FileHistory.addIntermediateTiming(history);
        FileHistory.parseIntermediateCode(history);
        if (shouldCompile) {
            FileHistory.runIntermediateCode(history);
        }
        return history;
    }

    private static void addCommitIndex(ArrayList<Intermediate> history) {
        int i = 0;
        while (i < history.size()) {
            history.get((int)i).commitIndex = i;
            ++i;
        }
    }

    private static void addFilePath(ArrayList<Intermediate> history, String filePath) {
        for (Intermediate intermediate : history) {
            intermediate.filePath = filePath;
        }
    }

    private static void runIntermediateCode(ArrayList<Intermediate> history) {
        for (Intermediate intermediate : history) {
            Runner.run(intermediate);
        }
    }

    private static void parseIntermediateCode(ArrayList<Intermediate> history) {
        for (Intermediate intermediate : history) {
            Parser.parse(intermediate);
        }
    }

    private static void addIntermediateTiming(ArrayList<Intermediate> history) {
        int startTime = 0;
        int workingTimeSeconds = 0;
        int lastTime = 0;
        if (!history.isEmpty()) {
            lastTime = startTime = history.get((int)0).timeStamp;
        }
        for (Intermediate intermediate : history) {
            int time = intermediate.timeStamp;
            boolean tookBreak = false;
            int deltaSeconds = time - lastTime;
            if (deltaSeconds > 600) {
                deltaSeconds = 0;
                tookBreak = true;
            }
            double workingMins = (double)(workingTimeSeconds += deltaSeconds) / 60.0;
            double workingHours = workingMins / 60.0;
            intermediate.workingHours = workingHours;
            if (tookBreak) {
                double breakSeconds = time - lastTime;
                double breakMins = breakSeconds / 60.0;
                double breakHours = breakMins / 60.0;
                intermediate.breakHours = breakHours;
            } else {
                intermediate.breakHours = null;
            }
            lastTime = time;
        }
    }

    private static ArrayList<Intermediate> getRawIntermediate(String repoPath, String filePath) {
        ArrayList<Intermediate> history = new ArrayList<Intermediate>();
        try {
            Git git = Git.init().setDirectory(new File(repoPath)).call();
            Repository repo = git.getRepository();
            RevWalk walk = new RevWalk(repo);
            ObjectId from = repo.resolve("refs/heads/master");
            walk.markStart(walk.parseCommit(from));
            String lastText = "";
            int lastRuns = 0;
            ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
            for (RevCommit commit : walk) {
                commits.add(commit);
            }
            Collections.reverse(commits);
            for (RevCommit commit : commits) {
                String currText = FileHistory.getFile(repo, commit, filePath);
                boolean editedFile = !currText.isEmpty() && !currText.equals(lastText);
                Integer runs = FileHistory.getRuns(commit.getShortMessage());
                if (editedFile) {
                    Intermediate intr = new Intermediate();
                    intr.commitMsg = commit.getShortMessage();
                    intr.deltaRuns = FileHistory.calcDeltaRuns(lastRuns, runs);
                    intr.code = currText;
                    intr.timeStamp = commit.getCommitTime();
                    history.add(intr);
                    lastText = currText;
                }
                if (runs == null) continue;
                lastRuns = runs;
            }
            walk.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return history;
    }

    private static int calcDeltaRuns(int lastRuns, Integer runs) {
        if (runs != null) {
            if (runs < lastRuns) {
                return runs;
            }
            return runs - lastRuns;
        }
        return 0;
    }

    private static Integer getRuns(String shortMessage) {
        int locRun = shortMessage.indexOf("runs");
        if (locRun == -1) {
            return null;
        }
        try {
            int locNum = locRun + 6;
            int endIndex = shortMessage.length() - 1;
            String numStr = shortMessage.substring(locNum, endIndex);
            return Integer.parseInt(numStr);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getFile(Repository repo, RevCommit commit, String path) throws IOException {
        ObjectReader reader = repo.newObjectReader();
        RevTree tree = commit.getTree();
        TreeWalk treewalk = TreeWalk.forPath(reader, path, tree);
        if (treewalk != null) {
            byte[] data = reader.open(treewalk.getObjectId(0)).getBytes();
            return new String(data, "utf-8").trim();
        }
        return "";
    }
}

