/*
 * Decompiled with CFR 0.152.
 */
package stanford.edu.gitviewer;

import graphs.GraphChoser;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import stanford.edu.gitviewer.CodeEditor;
import stanford.edu.gitviewer.FileHistory;
import stanford.edu.gitviewer.Intermediate;

public class GitViewer
extends Application {
    private static final String TEST_REPO_PATH = "/Users/piech/Documents/Teaching/cs106a/GitCoach/exampleGits/aaldana_1";
    private static final String CURR_DIR = ".";
    private static final String REPO_PATH = "/Users/piech/Documents/Teaching/cs106a/GitCoach/exampleGits/aaldana_1";
    private final ComboBox<String> comboBox = new ComboBox();
    private final CodeEditor editor = new CodeEditor("hello world");
    private final ListView<String> listView = new ListView();
    private List<Intermediate> history = null;
    private GraphChoser topGraph = new GraphChoser("SourceLength");
    private GraphChoser bottomGraph = new GraphChoser("Runs");
    private boolean shouldCompile = false;

    public static void main(String[] args) {
        GitViewer.launch((String[])args);
    }

    public void start(Stage primaryStage) {
        this.makeDisplay(primaryStage);
        this.displayFile((String)this.comboBox.getValue());
    }

    private void displayFile(String filePath) {
        this.editor.resetScroll();
        this.history = FileHistory.getHistory("/Users/piech/Documents/Teaching/cs106a/GitCoach/exampleGits/aaldana_1", filePath, this.shouldCompile);
        this.makeListView(this.history);
        this.topGraph.drawGraph(this.history);
        this.bottomGraph.drawGraph(this.history);
    }

    private ListView<String> makeListView(List<Intermediate> history) {
        ObservableList data = FXCollections.observableArrayList();
        this.listView.setMinSize(200.0, 200.0);
        int i = 0;
        while (i < history.size()) {
            Intermediate intermediate = history.get(i);
            double workingHours = intermediate.workingHours;
            String label = String.valueOf(i) + "\t" + this.formatTime(workingHours);
            if (intermediate.breakHours != null) {
                double breakHours = intermediate.breakHours;
                label = String.valueOf(label) + " (" + this.formatTime(breakHours) + ")";
            }
            data.add((Object)label);
            ++i;
        }
        this.listView.setItems(data);
        Intermediate codeVersion = history.get(0);
        String code = codeVersion.code;
        this.editor.setCode(code);
        return this.listView;
    }

    private String formatTime(double workingHours) {
        int hours = (int)workingHours;
        int mins = (int)Math.round(60.0 * (workingHours - (double)hours));
        return String.valueOf(hours) + "h " + mins + "m";
    }

    private void onIntermediateSelection(int index) {
        Intermediate codeVersion = this.history.get(index);
        String code = codeVersion.code;
        this.editor.setCode(code);
        this.topGraph.setSelectedTime(codeVersion.workingHours);
        this.bottomGraph.setSelectedTime(codeVersion.workingHours);
    }

    private void makeDisplay(Stage primaryStage) {
        primaryStage.setTitle("CS106A Pensive");
        this.listView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldValue, String newValue) {
                int index = GitViewer.this.listView.getSelectionModel().getSelectedIndex();
                if (index == -1) {
                    return;
                }
                GitViewer.this.onIntermediateSelection(index);
            }
        });
        SplitPane graphCodeSplit = new SplitPane();
        WebView editorView = this.editor.getView();
        graphCodeSplit.getItems().add(this.listView);
        graphCodeSplit.getItems().add((Object)editorView);
        VBox graphs = new VBox();
        graphs.getChildren().add((Object)this.topGraph.getView());
        graphs.getChildren().add((Object)new Separator());
        graphs.getChildren().add((Object)this.bottomGraph.getView());
        graphCodeSplit.getItems().add((Object)graphs);
        graphCodeSplit.setDividerPositions(new double[]{0.12, 0.65});
        BorderPane border = new BorderPane();
        border.setCenter((Node)graphCodeSplit);
        Label fileLabel = new Label("File: ");
        ArrayList<String> allFiles = FileHistory.getFiles("/Users/piech/Documents/Teaching/cs106a/GitCoach/exampleGits/aaldana_1");
        ObservableList options = FXCollections.observableArrayList(allFiles);
        this.comboBox.setItems(options);
        this.comboBox.setValue((Object)((String)this.comboBox.getItems().get(0)));
        HBox hb = new HBox();
        hb.setAlignment(Pos.CENTER);
        hb.getChildren().addAll((Object[])new Node[]{fileLabel, this.comboBox});
        hb.setSpacing(10.0);
        border.setTop((Node)hb);
        this.comboBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                String filePath = (String)GitViewer.this.comboBox.getValue();
                GitViewer.this.displayFile(filePath);
            }
        });
        Scene scene = new Scene((Parent)new Group());
        scene.setRoot((Parent)border);
        String style = ((Object)((Object)this)).getClass().getResource("css/program.css").toExternalForm();
        scene.getStylesheets().add((Object)style);
        primaryStage.setScene(scene);
        primaryStage.show();
    }
}

