/*
 * Decompiled with CFR 0.152.
 */
package stanford.edu.gitviewer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;
import stanford.edu.gitviewer.Intermediate;

public class RunnerOld {
    public static void run(Intermediate intermediate) {
        String code = intermediate.code;
        String className = RunnerOld.getClassName(intermediate.filePath);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StringJavaFileObject compilationUnit = new StringJavaFileObject(className, code);
        SimpleJavaFileManager fileManager = new SimpleJavaFileManager(compiler.getStandardFileManager(null, null, null));
        JavaCompiler.CompilationTask compilationTask = compiler.getTask(null, fileManager, null, null, null, Arrays.asList(compilationUnit));
        compilationTask.call();
        CompiledClassLoader classLoader = new CompiledClassLoader(fileManager.getGeneratedOutputFiles());
        try {
            Class<?> karelTest = classLoader.loadClass(className);
            Class[] cArg = new Class[]{};
            Method run = karelTest.getMethod("main", String[].class);
            System.out.println(run);
            run.invoke(null, new Object[1]);
            System.out.println("worked");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    private static String getClassName(String filePath) {
        File f = new File(filePath);
        return f.getName().split("\\.")[0];
    }

    private static class ClassJavaFileObject
    extends SimpleJavaFileObject {
        private final ByteArrayOutputStream outputStream;
        private final String className;

        protected ClassJavaFileObject(String className, JavaFileObject.Kind kind) {
            super(URI.create("mem:///" + className.replace('.', '/') + kind.extension), kind);
            this.className = className;
            this.outputStream = new ByteArrayOutputStream();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.outputStream;
        }

        public byte[] getBytes() {
            return this.outputStream.toByteArray();
        }

        public String getClassName() {
            return this.className;
        }
    }

    private static class CompiledClassLoader
    extends ClassLoader {
        private final List<ClassJavaFileObject> files;

        private CompiledClassLoader(List<ClassJavaFileObject> files) {
            this.files = files;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Iterator<ClassJavaFileObject> itr = this.files.iterator();
            while (itr.hasNext()) {
                ClassJavaFileObject file = itr.next();
                if (!file.getClassName().equals(name)) continue;
                itr.remove();
                byte[] bytes = file.getBytes();
                return super.defineClass(name, bytes, 0, bytes.length);
            }
            return super.findClass(name);
        }
    }

    private static class SimpleJavaFileManager
    extends ForwardingJavaFileManager {
        private final List<ClassJavaFileObject> outputFiles = new ArrayList<ClassJavaFileObject>();

        protected SimpleJavaFileManager(JavaFileManager fileManager) {
            super(fileManager);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            ClassJavaFileObject file = new ClassJavaFileObject(className, kind);
            this.outputFiles.add(file);
            return file;
        }

        public List<ClassJavaFileObject> getGeneratedOutputFiles() {
            return this.outputFiles;
        }
    }

    private static class StringJavaFileObject
    extends SimpleJavaFileObject {
        private final String code;

        public StringJavaFileObject(String name, String code) {
            super(URI.create("string:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.code;
        }
    }
}

