/*
 * Decompiled with CFR 0.152.
 */
package stanford.karel;

import java.awt.Color;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import stanford.karel.KarelConstants;
import stanford.karel.KarelException;
import stanford.karel.KarelState;
import stanford.karel.KarelWorld;
import stanford.karel.PrePost;

public class KarelCore
implements KarelConstants {
    public int col;
    public int row;
    public int direction;
    public int beepersInBag = 999999999;
    public KarelWorld world = new KarelWorld();
    public int status = 0;
    public int instructionCount = 0;
    protected String cmdString = "";
    protected Stack<KarelState> preconditions = new Stack();
    protected Map<String, List<PrePost>> prePostMap = new HashMap<String, List<PrePost>>();
    protected List<KarelState> allStates = new LinkedList<KarelState>();
    protected File worldFile;
    public static final Color BLACK = Color.BLACK;
    public static final Color BLUE = Color.BLUE;
    public static final Color CYAN = Color.CYAN;
    public static final Color DARK_GRAY = Color.DARK_GRAY;
    public static final Color GRAY = Color.GRAY;
    public static final Color GREEN = Color.GREEN;
    public static final Color LIGHT_GRAY = Color.LIGHT_GRAY;
    public static final Color MAGENTA = Color.MAGENTA;
    public static final Color ORANGE = Color.ORANGE;
    public static final Color PINK = Color.PINK;
    public static final Color RED = Color.RED;
    public static final Color WHITE = Color.WHITE;
    public static final Color YELLOW = Color.YELLOW;

    public void move_salt04251988() {
        if (!this.checkRunning_salt25041988()) {
            return;
        }
        int nX = this.col + this.dx_salt04251988(this.direction);
        int nY = this.row + this.dy_salt04251988(this.direction);
        if (this.world.w[this.col][this.row].walls[this.direction] || nX < 0 || nX >= this.world.numCols || nY < 0 || nY >= this.world.numRows) {
            this.moveError_salt04251988();
            return;
        }
        this.col = nX;
        this.row = nY;
        this.cmdString = String.valueOf(this.cmdString) + "M";
        this.allStates.add(new KarelState(this, this.worldFile));
    }

    public void turnLeft_salt04251988() {
        if (!this.checkRunning_salt25041988()) {
            return;
        }
        this.direction = (this.direction + 3) % 4;
        this.cmdString = String.valueOf(this.cmdString) + "L";
        this.allStates.add(new KarelState(this, this.worldFile));
    }

    public void turnRight_salt04251988() {
        if (!this.checkRunning_salt25041988()) {
            return;
        }
        this.direction = (this.direction + 1) % 4;
        this.cmdString = String.valueOf(this.cmdString) + "R";
        this.allStates.add(new KarelState(this, this.worldFile));
    }

    public void turnAround_salt04251988() {
        if (!this.checkRunning_salt25041988()) {
            return;
        }
        this.direction = (this.direction + 2) % 4;
        this.cmdString = String.valueOf(this.cmdString) + "RR";
        this.allStates.add(new KarelState(this, this.worldFile));
    }

    public boolean frontIsClear_salt04251988() {
        this.cmdString = String.valueOf(this.cmdString) + "F";
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return !this.world.w[this.col][this.row].walls[this.direction];
    }

    public boolean frontIsBlocked_salt04251988() {
        this.cmdString = String.valueOf(this.cmdString) + "F";
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return this.world.w[this.col][this.row].walls[this.direction];
    }

    public boolean leftIsClear_salt04251988() {
        this.cmdString = String.valueOf(this.cmdString) + "Q";
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return !this.world.w[this.col][this.row].walls[(this.direction + 3) % 4];
    }

    public boolean rightIsClear_salt04251988() {
        this.cmdString = String.valueOf(this.cmdString) + "P";
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return !this.world.w[this.col][this.row].walls[(this.direction + 1) % 4];
    }

    public boolean leftIsBlocked_salt04251988() {
        this.cmdString = String.valueOf(this.cmdString) + "Q";
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return this.world.w[this.col][this.row].walls[(this.direction + 3) % 4];
    }

    public boolean rightIsBlocked_salt04251988() {
        this.cmdString = String.valueOf(this.cmdString) + "P";
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return this.world.w[this.col][this.row].walls[(this.direction + 1) % 4];
    }

    public boolean beepersPresent_salt04251988() {
        this.cmdString = String.valueOf(this.cmdString) + "B";
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return this.world.w[this.col][this.row].nBeepers > 0;
    }

    public boolean noBeepersPresent_salt04251988() {
        this.cmdString = String.valueOf(this.cmdString) + "B";
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return this.world.w[this.col][this.row].nBeepers == 0;
    }

    public void pickBeeper_salt04251988() {
        if (!this.checkRunning_salt25041988()) {
            return;
        }
        if (this.world.w[this.col][this.row].nBeepers == 0) {
            this.pickBeeperError_salt04251988();
            return;
        }
        --this.world.w[this.col][this.row].nBeepers;
        ++this.beepersInBag;
        this.cmdString = String.valueOf(this.cmdString) + "T";
        this.allStates.add(new KarelState(this, this.worldFile));
    }

    public void putBeeper_salt04251988() {
        if (!this.checkRunning_salt25041988()) {
            return;
        }
        if (this.beepersInBag == 0) {
            this.putBeeperError_salt04251988();
            return;
        }
        ++this.world.w[this.col][this.row].nBeepers;
        --this.beepersInBag;
        this.cmdString = String.valueOf(this.cmdString) + "A";
        this.allStates.add(new KarelState(this, this.worldFile));
    }

    public boolean beepersInBag_salt04251988() {
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return this.beepersInBag > 0;
    }

    public boolean noBeepersInBag_salt04251988() {
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return this.beepersInBag == 0;
    }

    public boolean facingNorth_salt04251988() {
        this.cmdString = String.valueOf(this.cmdString) + "1";
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return this.direction == 0;
    }

    public boolean facingEast_salt04251988() {
        this.cmdString = String.valueOf(this.cmdString) + "2";
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return this.direction == 1;
    }

    public boolean facingSouth_salt04251988() {
        this.cmdString = String.valueOf(this.cmdString) + "3";
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return this.direction == 2;
    }

    public boolean facingWest_salt04251988() {
        this.cmdString = String.valueOf(this.cmdString) + "4";
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return this.direction == 3;
    }

    public boolean notFacingNorth_salt04251988() {
        this.cmdString = String.valueOf(this.cmdString) + "1";
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return this.direction != 0;
    }

    public boolean notFacingEast_salt04251988() {
        this.cmdString = String.valueOf(this.cmdString) + "2";
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return this.direction != 1;
    }

    public boolean notFacingSouth_salt04251988() {
        this.cmdString = String.valueOf(this.cmdString) + "3";
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return this.direction != 2;
    }

    public boolean notFacingWest_salt04251988() {
        this.cmdString = String.valueOf(this.cmdString) + "4";
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return this.direction != 3;
    }

    public boolean cornerColorIs_salt04251988(Color c) {
        if (!this.checkRunning_salt25041988()) {
            return false;
        }
        return c == this.world.w[this.col][this.row].c;
    }

    public void paintCorner_salt04251988(Color c) {
        if (!this.checkRunning_salt25041988()) {
            return;
        }
        this.world.w[this.col][this.row].c = c;
    }

    public void run_salt25041988() {
    }

    public List<KarelState> getAllStates_salt25041988() {
        return this.allStates;
    }

    public Map<String, List<PrePost>> getPrePostMap_salt25041988() {
        return this.prePostMap;
    }

    public String getCmdString_salt25041988() {
        return this.cmdString;
    }

    public int getNumInstructions_salt25041988() {
        return this.instructionCount;
    }

    public void load_salt25041988(KarelState pre) {
        if (pre.getWorldFile() != null) {
            this.loadWorldFile_salt25041988(pre.getWorldFile());
        } else {
            this.reset_salt04251988();
            this.world = new KarelWorld(pre.getWorld());
        }
    }

    public void loadWorldFile_salt25041988(File worldFile) {
        this.worldFile = worldFile;
        try {
            String line;
            this.reset_salt04251988();
            BufferedReader rd = new BufferedReader(new FileReader(worldFile));
            while ((line = rd.readLine()) != null) {
                String cmd = line.substring(0, line.indexOf(58)).toUpperCase();
                this.processCommand_salt04251988(cmd, line.substring(cmd.length() + 2));
            }
            rd.close();
        }
        catch (IOException e) {
            String worldPath = worldFile.getPath();
            System.out.println("Karel crashed trying to load the world from file " + worldPath + ".");
        }
    }

    public void beforeMethod_salt25041988(String name) {
        KarelState precondition = new KarelState(this, this.worldFile, name);
        this.preconditions.push(precondition);
    }

    public void afterMethod_salt25041988(String name) {
        KarelState postcondition = new KarelState(this, this.worldFile, name);
        KarelState precondition = this.preconditions.pop();
        String preMethod = precondition.getCurrentMethod();
        if (preMethod != name) {
            throw new RuntimeException("names must match");
        }
        if (!this.prePostMap.containsKey(name)) {
            this.prePostMap.put(name, new LinkedList());
        }
        PrePost newPrePost = new PrePost(precondition, postcondition);
        this.prePostMap.get(name).add(newPrePost);
    }

    public boolean checkRunning_salt25041988() {
        ++this.instructionCount;
        if (this.instructionCount > 10000) {
            this.infiniteLoopError_salt04251988();
        }
        return true;
    }

    public void loadPrecondition_salt25041988(KarelState pre) {
        this.load_salt25041988(pre);
        this.status = pre.getStatus();
        this.col = pre.getKarelCol();
        this.row = pre.getKarelRow();
        this.direction = pre.getDirection();
        this.world.setDynamicElements(pre);
    }

    public KarelState getState_salt25041988() {
        return new KarelState(this, this.worldFile);
    }

    protected void processCommand_salt04251988(String cmd, String line) {
        if (cmd.equals("BEEPER")) {
            this.world.beeperCommand(this.toPoint_salt04251988(line.substring(0, line.indexOf(41) + 1)), this.getInt_salt04251988(line.substring(line.indexOf(41) + 2)));
        } else if (cmd.equals("WALL")) {
            this.world.wallCommand(this.toPoint_salt04251988(line.substring(0, line.indexOf(41) + 1)), this.toDir_salt04251988(line.substring(line.indexOf(41) + 2).toUpperCase()));
        } else if (cmd.equals("DIMENSION")) {
            this.world.dimensionCommand(this.toPoint_salt04251988(line.substring(0, line.indexOf(41) + 1)));
        } else if (cmd.equals("BEEPERBAG")) {
            this.bagCommand_salt04251988(this.getInt_salt04251988(line));
        } else if (cmd.equals("KAREL")) {
            this.karelCommand_salt04251988(this.toPoint_salt04251988(line.substring(0, line.indexOf(41) + 1)), this.toDir_salt04251988(line.substring(line.indexOf(41) + 2).toUpperCase()));
        }
    }

    protected int getInt_salt04251988(String s) {
        if (s.toUpperCase().startsWith("INF")) {
            return 999999999;
        }
        return Integer.valueOf(s);
    }

    protected Point toPoint_salt04251988(String s) {
        return new Point(Integer.valueOf(s.substring(1, s.indexOf(44))) - 1, Integer.valueOf(s.substring(s.indexOf(32) + 1, s.indexOf(41))) - 1);
    }

    protected void karelCommand_salt04251988(Point p, int d) {
        this.col = p.x;
        this.row = p.y;
        this.direction = d;
    }

    protected void bagCommand_salt04251988(int n) {
        this.beepersInBag = n;
    }

    protected int dx_salt04251988(int d) {
        if (d == 0 || d == 2) {
            return 0;
        }
        if (d == 1) {
            return 1;
        }
        return -1;
    }

    protected int dy_salt04251988(int d) {
        if (d == 1 || d == 3) {
            return 0;
        }
        if (d == 0) {
            return 1;
        }
        return -1;
    }

    protected int toDir_salt04251988(String dir) {
        if (dir.equals("NORTH")) {
            return 0;
        }
        if (dir.equals("SOUTH")) {
            return 2;
        }
        if (dir.equals("EAST")) {
            return 1;
        }
        return 3;
    }

    protected void reset_salt04251988() {
        this.status = 0;
        this.beepersInBag = 999999999;
        this.col = 0;
        this.row = 0;
        this.direction = 1;
        this.instructionCount = 0;
        this.cmdString = "";
    }

    protected void moveError_salt04251988() {
        this.status = 1;
        this.cmdString = String.valueOf(this.cmdString) + "E";
        throw new KarelException();
    }

    protected void pickBeeperError_salt04251988() {
        this.status = 3;
        this.cmdString = String.valueOf(this.cmdString) + "E";
        throw new KarelException();
    }

    protected void putBeeperError_salt04251988() {
        this.status = 2;
        this.cmdString = String.valueOf(this.cmdString) + "E";
        throw new KarelException();
    }

    protected void infiniteLoopError_salt04251988() {
        this.status = 4;
        this.cmdString = String.valueOf(this.cmdString) + "I";
        throw new KarelException();
    }
}

