/*
 * Decompiled with CFR 0.152.
 */
package stanford.karel;

import java.awt.Color;
import java.util.ArrayList;
import org.json.JSONObject;
import stanford.karel.KarelConstants;

public class KarelSquare
implements KarelConstants {
    public int nBeepers;
    public boolean[] walls;
    public Color c;

    public KarelSquare() {
        this.nBeepers = 0;
        this.walls = new boolean[4];
        int i = 0;
        while (i <= 3) {
            this.walls[i] = false;
            ++i;
        }
        this.c = null;
    }

    public KarelSquare(KarelSquare toCopy) {
        this.nBeepers = toCopy.nBeepers;
        this.c = toCopy.c;
        this.walls = new boolean[toCopy.walls.length];
        System.arraycopy(toCopy.walls, 0, this.walls, 0, toCopy.walls.length);
    }

    public KarelSquare(JSONObject json) {
        this.nBeepers = 0;
        this.walls = new boolean[4];
        int i = 0;
        while (i <= 3) {
            this.walls[i] = false;
            ++i;
        }
        this.c = null;
        if (json.has("nBeepers")) {
            this.nBeepers = json.getInt("nBeepers");
        }
        if (json.has("color")) {
            int rgb = json.getInt("color");
            this.c = new Color(rgb);
        }
    }

    public JSONObject getJson() {
        JSONObject root = new JSONObject();
        if (this.nBeepers > 0) {
            root.put("nBeepers", this.nBeepers);
        }
        if (this.c != null) {
            root.put("color", this.c.getRGB());
        }
        return root;
    }

    public boolean isEmpty() {
        if (this.c != null) {
            return false;
        }
        return this.nBeepers == 0;
    }

    public void setDynamicElements(KarelSquare other) {
        this.nBeepers = other.nBeepers;
        this.c = other.c;
    }

    public int hashCode() {
        ArrayList<Integer> hashes = new ArrayList<Integer>();
        hashes.add(this.nBeepers);
        if (this.c != null) {
            hashes.add(this.c.getRGB());
        }
        return hashes.hashCode();
    }

    public boolean equals(Object o) {
        KarelSquare other = (KarelSquare)o;
        if (other.nBeepers != this.nBeepers) {
            return false;
        }
        return !(this.c == null ? other.c != null : other.c.getRGB() != this.c.getRGB());
    }
}

