/*
 * Decompiled with CFR 0.152.
 */
package stanford.karel;

import java.io.File;
import java.util.ArrayList;
import org.json.JSONObject;
import stanford.karel.KarelCore;
import stanford.karel.KarelWorld;

public class KarelState {
    private KarelWorld world = null;
    private int karelCol;
    private int karelRow;
    private int direction;
    private int status;
    private File worldFile;
    private String currentMethod;

    public static KarelState getDefaultWorld() {
        KarelState defaultWorld = new KarelState();
        return defaultWorld;
    }

    public KarelState(File worldFile) {
        KarelCore core = new KarelCore();
        core.loadWorldFile_salt25041988(worldFile);
        this.init(core, worldFile, null);
    }

    public KarelState() {
        this.world = new KarelWorld(8, 8);
        this.karelCol = 0;
        this.karelRow = 0;
        this.direction = 1;
        this.status = 0;
        this.worldFile = null;
        this.currentMethod = null;
    }

    public KarelState(KarelCore k, File worldFile) {
        this(k, worldFile, null);
    }

    public KarelState(KarelCore k, File worldFile, String currentMethod) {
        this.init(k, worldFile, currentMethod);
    }

    private void init(KarelCore k, File worldFile, String currentMethod) {
        this.world = new KarelWorld(k.world);
        this.karelCol = k.col;
        this.karelRow = k.row;
        this.direction = k.direction;
        this.status = k.status;
        this.worldFile = worldFile;
        this.currentMethod = currentMethod;
    }

    public KarelState(JSONObject json) {
        this.karelCol = json.getInt("col");
        this.karelRow = json.getInt("row");
        this.direction = json.getInt("direction");
        this.status = json.getInt("status");
        String worldPath = json.getString("worldPath");
        this.worldFile = new File(worldPath);
        this.world = new KarelWorld(json.getJSONObject("world"));
    }

    public JSONObject getJson() {
        JSONObject root = new JSONObject();
        root.put("col", this.karelCol);
        root.put("row", this.karelRow);
        root.put("direction", this.direction);
        root.put("status", this.status);
        root.put("world", this.world.getJson());
        return root;
    }

    public String getWorldPath() {
        return this.worldFile.getName();
    }

    public File getWorldFile() {
        return this.worldFile;
    }

    public int hashCode() {
        ArrayList<Integer> intValues = new ArrayList<Integer>();
        intValues.add(this.karelCol);
        intValues.add(this.karelRow);
        intValues.add(this.status);
        intValues.add(this.direction);
        intValues.add(this.world.hashCode());
        intValues.add(this.getWorldPath().hashCode());
        return intValues.hashCode();
    }

    public KarelWorld getWorld() {
        return this.world;
    }

    public int getKarelCol() {
        return this.karelCol;
    }

    public int getKarelRow() {
        return this.karelRow;
    }

    public int getDirection() {
        return this.direction;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        KarelState other = (KarelState)o;
        if (this.karelCol != other.karelCol) {
            return false;
        }
        if (this.karelRow != other.karelRow) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        if (this.direction != other.direction) {
            return false;
        }
        if (!this.getWorldPath().equals(other.getWorldPath())) {
            return false;
        }
        return this.world.equals(other.world);
    }

    public String toString() {
        return this.getJson().toString(2);
    }

    public String getCurrentMethod() {
        return this.currentMethod;
    }
}

