/*
 * Decompiled with CFR 0.152.
 */
package stanford.karel;

import java.awt.Point;
import java.util.ArrayList;
import org.json.JSONObject;
import stanford.karel.KarelConstants;
import stanford.karel.KarelSquare;
import stanford.karel.KarelState;

public class KarelWorld
implements KarelConstants {
    public int numCols;
    public int numRows;
    public KarelSquare[][] w;

    public KarelWorld() {
    }

    public KarelWorld(int rows, int cols) {
        this.numCols = cols;
        this.numRows = rows;
        this.w = new KarelSquare[this.numCols][this.numRows];
        int x = 0;
        while (x < this.numCols) {
            int y = 0;
            while (y < this.numRows) {
                this.w[x][y] = new KarelSquare();
                ++y;
            }
            ++x;
        }
    }

    public KarelWorld(KarelWorld toCopy) {
        this.numCols = toCopy.numCols;
        this.numRows = toCopy.numRows;
        this.w = new KarelSquare[this.numCols][this.numRows];
        int x = 0;
        while (x < this.numCols) {
            int y = 0;
            while (y < this.numRows) {
                this.w[x][y] = new KarelSquare(toCopy.w[x][y]);
                ++y;
            }
            ++x;
        }
    }

    public KarelWorld(JSONObject json) {
        this.numCols = json.getInt("numCols");
        this.numRows = json.getInt("numRows");
        this.w = new KarelSquare[this.numCols][this.numRows];
        JSONObject squares = json.getJSONObject("squares");
        int x = 0;
        while (x < this.numCols) {
            int y = 0;
            while (y < this.numRows) {
                String squareKey = KarelWorld.getSquareKey(x, y);
                if (squares.has(squareKey)) {
                    JSONObject squareJson = squares.getJSONObject(squareKey);
                    this.w[x][y] = new KarelSquare(squareJson);
                } else {
                    this.w[x][y] = new KarelSquare();
                }
                ++y;
            }
            ++x;
        }
    }

    private static String getSquareKey(int x, int y) {
        return String.valueOf(x) + "," + y;
    }

    public JSONObject getJson() {
        JSONObject root = new JSONObject();
        root.put("numCols", this.numCols);
        root.put("numRows", this.numRows);
        JSONObject squares = new JSONObject();
        int x = 0;
        while (x < this.numCols) {
            int y = 0;
            while (y < this.numRows) {
                KarelSquare sq = this.w[x][y];
                if (!sq.isEmpty()) {
                    String key = KarelWorld.getSquareKey(x, y);
                    squares.put(key, sq.getJson());
                }
                ++y;
            }
            ++x;
        }
        root.put("squares", squares);
        return root;
    }

    public void initializeBlankWorld(int myX, int myY) {
        this.numCols = myX;
        this.numRows = myY;
        this.w = new KarelSquare[this.numCols][this.numRows];
        int x = 0;
        while (x < this.numCols) {
            int y = 0;
            while (y < this.numRows) {
                this.w[x][y] = new KarelSquare();
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < this.numCols) {
            this.w[x][0].walls[2] = true;
            this.w[x][this.numRows - 1].walls[0] = true;
            ++x;
        }
        int y = 0;
        while (y < this.numRows) {
            this.w[0][y].walls[3] = true;
            this.w[this.numCols - 1][y].walls[1] = true;
            ++y;
        }
    }

    public void beeperCommand(Point p, int n) {
        this.w[p.x][p.y].nBeepers = n;
    }

    public void wallCommand(Point p, int d) {
        this.w[p.x][p.y].walls[d] = true;
        this.w[p.x + this.dx((int)d)][p.y + this.dy((int)d)].walls[(d + 2) % 4] = true;
    }

    private int dx(int d) {
        if (d == 0 || d == 2) {
            return 0;
        }
        if (d == 1) {
            return 1;
        }
        return -1;
    }

    private int dy(int d) {
        if (d == 1 || d == 3) {
            return 0;
        }
        if (d == 0) {
            return 1;
        }
        return -1;
    }

    public void dimensionCommand(Point p) {
        this.initializeBlankWorld(p.x + 1, p.y + 1);
    }

    public void print() {
        int y = this.numRows - 1;
        while (y >= 0) {
            String line = " ";
            int x = 0;
            while (x < this.numCols) {
                line = this.w[x][y].walls[0] ? String.valueOf(line) + "-" : String.valueOf(line) + " ";
                line = String.valueOf(line) + "  ";
                ++x;
            }
            System.out.println(line);
            line = "";
            x = 0;
            while (x < this.numCols) {
                line = this.w[x][y].walls[3] ? String.valueOf(line) + "|" : String.valueOf(line) + " ";
                line = String.valueOf(line) + this.w[x][y].nBeepers;
                line = this.w[x][y].walls[1] ? String.valueOf(line) + "|" : String.valueOf(line) + " ";
                ++x;
            }
            System.out.println(line);
            line = " ";
            x = 0;
            while (x < this.numCols) {
                line = this.w[x][y].walls[2] ? String.valueOf(line) + "-" : String.valueOf(line) + " ";
                line = String.valueOf(line) + "  ";
                ++x;
            }
            System.out.println(line);
            --y;
        }
    }

    public String toString() {
        return this.getJson().toString(3);
    }

    public int hashCode() {
        ArrayList<Integer> hashes = new ArrayList<Integer>();
        int x = 0;
        while (x < this.numCols) {
            int y = 0;
            while (y < this.numRows) {
                hashes.add(this.w[x][y].hashCode());
                ++y;
            }
            ++x;
        }
        return hashes.hashCode();
    }

    public boolean equals(Object o) {
        KarelWorld other = (KarelWorld)o;
        int x = 0;
        while (x < this.numCols) {
            int y = 0;
            while (y < this.numRows) {
                if (!this.w[x][y].equals(other.w[x][y])) {
                    return false;
                }
                ++y;
            }
            ++x;
        }
        return true;
    }

    public void setDynamicElements(KarelState pre) {
        KarelWorld preWorld = pre.getWorld();
        int x = 0;
        while (x < this.numCols) {
            int y = 0;
            while (y < this.numRows) {
                KarelSquare preWorldSquare = preWorld.w[x][y];
                this.w[x][y].setDynamicElements(preWorldSquare);
                ++y;
            }
            ++x;
        }
    }

    public int getNumBeepers(int col, int row) {
        return this.w[col][row].nBeepers;
    }
}

